/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.sidmapping;

import builder.jusbsid.JUSBSIDMapping;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;
import sidplay.ini.IniConfig;

@WebServlet(name="USBSIDMappingServlet", displayName="USBSIDMappingServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/usbsid-mapping/*"}, description="Get USBSID-Pico SID mapping information")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class USBSIDMappingServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.USBSIDMappingServlet.MAX_USBSIDMAPPING_IN_PARALLEL, new DefaultThreadFactory("/usbsidmapping"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.USBSIDMappingServlet.USBSIDMAPPING_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        USBSIDMappingServletParameters servletParameters = new USBSIDMappingServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(USBSIDMappingServlet.this.configuration, USBSIDMappingServlet.this.directoryProperties, parser, USBSIDMappingServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        IEmulationSection emulationSection = servletParameters.emulationSection;
                        SidTune tune = SidTune.load(file);
                        Map<Integer, String> result = JUSBSIDMapping.mapping(emulationSection, tune);
                        if (!this.isComplete()) {
                            USBSIDMappingServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, result);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(USBSIDMappingServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        USBSIDMappingServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.sidmapping.USBSIDMappingServletParameters")
    public static class USBSIDMappingServletParameters
    extends FileRequestPathServletParameters {
        @ParametersDelegate
        private IEmulationSection emulationSection = new IniConfig().getEmulationSection();
    }
}

