/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.whatssid;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import libsidutils.fingerprinting.rest.beans.MusicInfoBean;
import server.restful.JSIDPlay2Server;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import ui.entities.whatssid.service.WhatsSidService;

@WebServlet(name="TuneExistsServlet", displayName="TuneExistsServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/tune-exists"}, description="WhatsSID tune recognition. Check tune exists")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class TuneExistsServlet
extends JSIDPlay2Servlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            MusicInfoBean musicInfoBean = this.getInput(request, MusicInfoBean.class);
            WhatsSidService whatsSidService = new WhatsSidService(JSIDPlay2Server.getEntityManager());
            Boolean exists = whatsSidService.tuneExists(musicInfoBean);
            this.setOutput(request, response, (Object)exists);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
        finally {
            JSIDPlay2Server.freeEntityManager();
        }
    }
}

