/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.SidReads;
import libsidplay.common.Ultimate64Mode;
import libsidplay.config.IDeviceMapping;
import libsidplay.config.IEmulationSection;
import sidplay.ini.IniDefaults;
import sidplay.ini.IniDeviceMapping;
import sidplay.ini.IniReader;
import sidplay.ini.IniSection;
import sidplay.ini.converter.BeanToStringConverter;
import sidplay.ini.converter.NegatedBooleanConverter;
import sidplay.ini.converter.ShortConverter;
import sidplay.ini.validator.FilterNameValidator;
import sidplay.ini.validator.LatencyTimerValidator;
import ui.common.converter.NegatedBooleanDeserializer;
import ui.common.converter.NegatedBooleanSerializer;

@Parameters(resourceBundle="sidplay.ini.IniEmulationSection")
public class IniEmulationSection
extends IniSection
implements IEmulationSection {
    private static final String SECTION_ID = "Emulation";
    private IEmulationSection.OverrideSection overrideSection = new IEmulationSection.OverrideSection();

    protected IniEmulationSection(IniReader iniReader) {
        super(iniReader);
    }

    @Override
    public final Engine getEngine() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "Engine", IniDefaults.DEFAULT_ENGINE, Engine.class);
    }

    @Override
    @Parameter(names={"--engine", "-E"}, descriptionKey="ENGINE", order=1000)
    public final void setEngine(Engine engine) {
        this.iniReader.setProperty(SECTION_ID, "Engine", (Object)engine);
    }

    @Override
    public final Emulation getDefaultEmulation() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "DefaultEmulation", IniDefaults.DEFAULT_EMULATION, Emulation.class);
    }

    @Override
    @Parameter(names={"--defaultEmulation", "-e"}, descriptionKey="DEFAULT_EMULATION", order=1001)
    public final void setDefaultEmulation(Emulation emulation) {
        this.iniReader.setProperty(SECTION_ID, "DefaultEmulation", (Object)emulation);
    }

    @Override
    public final Emulation getUserEmulation() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "UserEmulation", IniDefaults.DEFAULT_USER_EMULATION, Emulation.class);
    }

    @Override
    @Parameter(names={"--forceEmulation", "--userEmulation"}, descriptionKey="FORCE_EMULATION", order=1002)
    public final void setUserEmulation(Emulation emulation) {
        this.iniReader.setProperty(SECTION_ID, "UserEmulation", (Object)emulation);
    }

    @Override
    public final Emulation getStereoEmulation() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "StereoEmulation", IniDefaults.DEFAULT_STEREO_EMULATION, Emulation.class);
    }

    @Override
    @Parameter(names={"--forceStereoEmulation", "--stereoEmulation"}, descriptionKey="FORCE_STEREO_EMULATION", order=1003)
    public final void setStereoEmulation(Emulation model) {
        this.iniReader.setProperty(SECTION_ID, "StereoEmulation", (Object)model);
    }

    @Override
    public final Emulation getThirdEmulation() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "3rdEmulation", IniDefaults.DEFAULT_3SID_EMULATION, Emulation.class);
    }

    @Override
    @Parameter(names={"--forceThirdEmulation", "--thirdEmulation"}, descriptionKey="FORCE_THIRD_EMULATION", order=1004)
    public final void setThirdEmulation(Emulation emulation) {
        this.iniReader.setProperty(SECTION_ID, "3rdEmulation", (Object)emulation);
    }

    @Override
    public final CPUClock getDefaultClockSpeed() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "DefaultClockSpeed", IniDefaults.DEFAULT_CLOCK_SPEED, CPUClock.class);
    }

    @Override
    @Parameter(names={"--defaultClock", "-k", "--defaultClockSpeed"}, descriptionKey="DEFAULT_CLOCK", order=1005)
    public final void setDefaultClockSpeed(CPUClock speed) {
        this.iniReader.setProperty(SECTION_ID, "DefaultClockSpeed", (Object)speed);
    }

    @Override
    public final CPUClock getUserClockSpeed() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "UserClockSpeed", IniDefaults.DEFAULT_USER_CLOCK_SPEED, CPUClock.class);
    }

    @Override
    @Parameter(names={"--forceClock", "-c", "--userClockSpeed"}, descriptionKey="FORCE_CLOCK", order=1006)
    public final void setUserClockSpeed(CPUClock speed) {
        this.iniReader.setProperty(SECTION_ID, "UserClockSpeed", (Object)speed);
    }

    @Override
    public final ChipModel getDefaultSidModel() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "DefaultSidModel", IniDefaults.DEFAULT_SID_MODEL, ChipModel.class);
    }

    @Override
    @Parameter(names={"--defaultModel", "-u", "--defaultSidModel"}, descriptionKey="DEFAULT_MODEL", order=1007)
    public final void setDefaultSidModel(ChipModel model) {
        this.iniReader.setProperty(SECTION_ID, "DefaultSidModel", (Object)model);
    }

    @Override
    public final ChipModel getUserSidModel() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "UserSidModel", IniDefaults.DEFAULT_USER_MODEL, ChipModel.class);
    }

    @Override
    @Parameter(names={"--forceModel", "-m", "--userSidModel"}, descriptionKey="FORCE_MODEL", order=1008)
    public final void setUserSidModel(ChipModel model) {
        this.iniReader.setProperty(SECTION_ID, "UserSidModel", (Object)model);
    }

    @Override
    public final ChipModel getStereoSidModel() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "StereoSidModel", IniDefaults.DEFAULT_STEREO_MODEL, ChipModel.class);
    }

    @Override
    @Parameter(names={"--forceStereoModel", "--stereoSidModel"}, descriptionKey="FORCE_STEREO_MODEL", order=1009)
    public final void setStereoSidModel(ChipModel model) {
        this.iniReader.setProperty(SECTION_ID, "StereoSidModel", (Object)model);
    }

    @Override
    public final ChipModel getThirdSIDModel() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "3rdSIDModel", IniDefaults.DEFAULT_3SID_MODEL, ChipModel.class);
    }

    @Override
    @Parameter(names={"--forceThirdModel", "--thirdSIDModel"}, descriptionKey="FORCE_THIRD_MODEL", order=1010)
    public final void setThirdSIDModel(ChipModel model) {
        this.iniReader.setProperty(SECTION_ID, "3rdSIDModel", (Object)model);
    }

    @Override
    public final int getHardsid6581() {
        return this.iniReader.getPropertyInt(SECTION_ID, "HardSID6581", IniDefaults.DEFAULT_HARD_SID_6581);
    }

    @Override
    @Parameter(names={"--hardSid6581"}, descriptionKey="HARDSID_6581", order=1011)
    public final void setHardsid6581(int chip) {
        this.iniReader.setProperty(SECTION_ID, "HardSID6581", chip);
    }

    @Override
    public final int getHardsid8580() {
        return this.iniReader.getPropertyInt(SECTION_ID, "HardSID8580", IniDefaults.DEFAULT_HARD_SID_8580);
    }

    @Override
    @Parameter(names={"--hardSid8580"}, descriptionKey="HARDSID_8580", order=1012)
    public final void setHardsid8580(int chip) {
        this.iniReader.setProperty(SECTION_ID, "HardSID8580", chip);
    }

    @Override
    public final List<? extends IDeviceMapping> getSidBlasterDeviceList() {
        int mappingCount = this.iniReader.getPropertyInt(SECTION_ID, "SIDBlasterMapping_N", 0);
        int mappingNum = 0;
        ArrayList<String> mappingList = new ArrayList<String>();
        do {
            mappingList.add(this.iniReader.getPropertyString(SECTION_ID, "SIDBlasterMapping_" + mappingNum++, ""));
        } while (mappingNum < mappingCount);
        return mappingList.stream().filter(Objects::nonNull).map(mapping -> mapping.split("=")).filter(mapping -> ((String[])mapping).length == 2).filter(mapping -> Arrays.asList(ChipModel.values()).stream().map(Enum::toString).filter(model -> Objects.equals(model, mapping[1])).findFirst().isPresent()).map(tokens -> new IniDeviceMapping(tokens[0], ChipModel.valueOf(tokens[1]), true)).collect(Collectors.toList());
    }

    @Override
    public final int getSidBlasterWriteBufferSize() {
        return this.iniReader.getPropertyInt(SECTION_ID, "SIDBlasterWriteBuffer Size", IniDefaults.DEFAULT_SIDBLASTER_WRITE_BUFFER_SIZE);
    }

    @Override
    public final void setSidBlasterWriteBufferSize(int sidBlasterWriteBufferSize) {
        this.iniReader.setProperty(SECTION_ID, "SIDBlasterWriteBuffer Size", sidBlasterWriteBufferSize);
    }

    @Override
    public final String getSidBlasterSerialNumber() {
        return this.iniReader.getPropertyString(SECTION_ID, "SIDBlasterSerialNumber", IniDefaults.DEFAULT_SIDBLASTER_SERIAL_NUMBER);
    }

    @Override
    public final void setSidBlasterSerialNumber(String sidBlasterSerialNumber) {
        this.iniReader.setProperty(SECTION_ID, "SIDBlasterSerialNumber", sidBlasterSerialNumber);
    }

    @Override
    public final boolean isSidBlasterRead() {
        return this.iniReader.getPropertyBool(SECTION_ID, "SIDBlasterRead", IniDefaults.DEFAULT_SIDBLASTER_READ);
    }

    @Override
    @Parameter(names={"--sidBlasterRead"}, descriptionKey="SIDBLASTER_READ", arity=1, order=1013)
    public final void setSidBlasterRead(boolean sidBlasterRead) {
        this.iniReader.setProperty(SECTION_ID, "SIDBlasterRead", sidBlasterRead);
    }

    @Override
    public final short getSidBlasterLatencyTimer() {
        return this.iniReader.getPropertyShort(SECTION_ID, "SIDBlasterLatencyTimer", IniDefaults.DEFAULT_SIDBLASTER_LATENCY_TIMER);
    }

    @Override
    @Parameter(names={"--sidBlasterLatencyTimer"}, descriptionKey="SIDBLASTER_LATENCY_TIMER", converter=ShortConverter.class, validateWith={LatencyTimerValidator.class}, arity=1, order=1014)
    public final void setSidBlasterLatencyTimer(short sidBlasterLatencyTimer) {
        this.iniReader.setProperty(SECTION_ID, "SIDBlasterLatencyTimer", sidBlasterLatencyTimer);
    }

    @Override
    public final boolean isExsidFakeStereo() {
        return this.iniReader.getPropertyBool(SECTION_ID, "ExSID Fake Stereo", IniDefaults.DEFAULT_EXSID_FAKE_STEREO);
    }

    @Override
    @Parameter(names={"--exsidFakeStereo"}, descriptionKey="EXSID_FAKE_STEREO", arity=1, order=1015)
    public final void setExsidFakeStereo(boolean exsidFakeStereo) {
        this.iniReader.setProperty(SECTION_ID, "ExSID Fake Stereo", exsidFakeStereo);
    }

    @Override
    public final String getNetSIDDevHost() {
        return this.iniReader.getPropertyString(SECTION_ID, "NetSIDDev Host", IniDefaults.DEFAULT_NETSIDDEV_HOST);
    }

    @Override
    @Parameter(names={"--NetSIDDevHost"}, descriptionKey="NET_SID_DEV_HOST", order=1016)
    public final void setNetSIDDevHost(String hostname) {
        this.iniReader.setProperty(SECTION_ID, "NetSIDDev Host", hostname);
    }

    @Override
    public final int getNetSIDDevPort() {
        return this.iniReader.getPropertyInt(SECTION_ID, "NetSIDDev Port", IniDefaults.DEFAULT_NETSIDDEV_PORT);
    }

    @Override
    @Parameter(names={"--NetSIDDevPort"}, descriptionKey="NET_SID_DEV_PORT", order=1017)
    public final void setNetSIDDevPort(int port) {
        this.iniReader.setProperty(SECTION_ID, "NetSIDDev Port", port);
    }

    @Override
    public final Ultimate64Mode getUltimate64Mode() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "Ultimate64 Mode", IniDefaults.DEFAULT_ULTIMATE64_MODE, Ultimate64Mode.class);
    }

    @Override
    @Parameter(names={"--ultimate64Mode"}, descriptionKey="ULTIMATE64_MODE", order=1018)
    public final void setUltimate64Mode(Ultimate64Mode ultimate64Mode) {
        this.iniReader.setProperty(SECTION_ID, "Ultimate64 Mode", (Object)ultimate64Mode);
    }

    @Override
    public final String getUltimate64Host() {
        return this.iniReader.getPropertyString(SECTION_ID, "Ultimate64 Host", IniDefaults.DEFAULT_ULTIMATE64_HOST);
    }

    @Override
    @Parameter(names={"--Ultimate64Host"}, descriptionKey="ULTIMATE64_HOST", order=1019)
    public final void setUltimate64Host(String hostname) {
        this.iniReader.setProperty(SECTION_ID, "Ultimate64 Host", hostname);
    }

    @Override
    public final int getUltimate64Port() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Ultimate64 Port", IniDefaults.DEFAULT_ULTIMATE64_PORT);
    }

    @Override
    @Parameter(names={"--Ultimate64Port"}, descriptionKey="ULTIMATE64_PORT", order=1020)
    public final void setUltimate64Port(int port) {
        this.iniReader.setProperty(SECTION_ID, "Ultimate64 Port", port);
    }

    @Override
    public final int getUltimate64SyncDelay() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Ultimate64 Sync Delay", IniDefaults.DEFAULT_ULTIMATE64_SYNC_DELAY);
    }

    @Override
    @Parameter(names={"--Ultimate64SyncDelay"}, descriptionKey="ULTIMATE64_SYNC_DELAY", order=1021)
    public final void setUltimate64SyncDelay(int syncDelay) {
        this.iniReader.setProperty(SECTION_ID, "Ultimate64 Sync Delay", syncDelay);
    }

    @Override
    public final boolean isFilter() {
        return this.iniReader.getPropertyBool(SECTION_ID, "UseFilter", IniDefaults.DEFAULT_USE_FILTER);
    }

    @Override
    @JsonSerialize(using=NegatedBooleanSerializer.class)
    @JsonDeserialize(using=NegatedBooleanDeserializer.class)
    @Parameter(names={"--disableFilter", "-i", "--filter"}, descriptionKey="DISABLE_FILTER", arity=1, converter=NegatedBooleanConverter.class, order=1022)
    public final void setFilter(boolean enable) {
        this.iniReader.setProperty(SECTION_ID, "UseFilter", enable);
    }

    @Override
    public final boolean isStereoFilter() {
        return this.iniReader.getPropertyBool(SECTION_ID, "UseStereoFilter", IniDefaults.DEFAULT_USE_STEREO_FILTER);
    }

    @Override
    @JsonSerialize(using=NegatedBooleanSerializer.class)
    @JsonDeserialize(using=NegatedBooleanDeserializer.class)
    @Parameter(names={"--disableStereoFilter", "-j", "--stereoFilter"}, descriptionKey="DISABLE_STEREO_FILTER", arity=1, converter=NegatedBooleanConverter.class, order=1023)
    public final void setStereoFilter(boolean enable) {
        this.iniReader.setProperty(SECTION_ID, "UseStereoFilter", enable);
    }

    @Override
    public final boolean isThirdSIDFilter() {
        return this.iniReader.getPropertyBool(SECTION_ID, "Use3rdSIDFilter", IniDefaults.DEFAULT_USE_3SID_FILTER);
    }

    @Override
    @JsonSerialize(using=NegatedBooleanSerializer.class)
    @JsonDeserialize(using=NegatedBooleanDeserializer.class)
    @Parameter(names={"--disable3rdSidFilter", "-J", "--thirdSIDFilter"}, descriptionKey="DISABLE_3RD_SID_FILTER", arity=1, converter=NegatedBooleanConverter.class, order=1024)
    public final void setThirdSIDFilter(boolean enable) {
        this.iniReader.setProperty(SECTION_ID, "Use3rdSIDFilter", enable);
    }

    @Override
    public final SidReads getSidToRead() {
        return this.iniReader.getPropertyEnum(SECTION_ID, "SidToRead", IniDefaults.DEFAULT_SID_TO_READ, SidReads.class);
    }

    @Override
    @Parameter(names={"--sidToRead"}, descriptionKey="SID_TO_READ", order=1025)
    public final void setSidToRead(SidReads sidRead) {
        this.iniReader.setProperty(SECTION_ID, "SidToRead", (Object)sidRead);
    }

    @Override
    public final boolean isDigiBoosted8580() {
        return this.iniReader.getPropertyBool(SECTION_ID, "DigiBoosted8580", IniDefaults.DEFAULT_DIGI_BOOSTED_8580);
    }

    @Override
    @Parameter(names={"--digiBoosted8580"}, descriptionKey="DIGIBOOSTED8580", arity=1, order=1026)
    public final void setDigiBoosted8580(boolean boost) {
        this.iniReader.setProperty(SECTION_ID, "DigiBoosted8580", boost);
    }

    @Override
    public final int getDualSidBase() {
        return this.iniReader.getPropertyInt(SECTION_ID, "dualSidBase", IniDefaults.DEFAULT_DUAL_SID_BASE);
    }

    @Override
    @Parameter(names={"--dualSIDBase", "--dualSidBase"}, descriptionKey="DUAL_SID_BASE", arity=1, order=1027)
    public final void setDualSidBase(int base) {
        this.iniReader.setProperty(SECTION_ID, "dualSidBase", String.format("0x%04x", base));
    }

    @Override
    public final int getThirdSIDBase() {
        return this.iniReader.getPropertyInt(SECTION_ID, "thirdSIDBase", IniDefaults.DEFAULT_THIRD_SID_BASE);
    }

    @Override
    @Parameter(names={"--thirdSIDBase"}, descriptionKey="THIRD_SID_BASE", arity=1, order=1028)
    public final void setThirdSIDBase(int base) {
        this.iniReader.setProperty(SECTION_ID, "thirdSIDBase", String.format("0x%04x", base));
    }

    @Override
    public final boolean isFakeStereo() {
        return this.iniReader.getPropertyBool(SECTION_ID, "fakeStereo", IniDefaults.DEFAULT_FAKE_STEREO);
    }

    @Override
    @Parameter(names={"--fakeStereo"}, descriptionKey="FAKE_STEREO", arity=1, order=1029)
    public final void setFakeStereo(boolean fakeStereo) {
        this.iniReader.setProperty(SECTION_ID, "fakeStereo", fakeStereo);
    }

    @Override
    public final boolean isForceStereoTune() {
        return this.iniReader.getPropertyBool(SECTION_ID, "forceStereoTune", IniDefaults.DEFAULT_FORCE_STEREO_TUNE);
    }

    @Override
    @Parameter(names={"--dualSID", "-d", "--forceStereoTune"}, descriptionKey="DUAL_SID", arity=1, order=1030)
    public final void setForceStereoTune(boolean force) {
        this.iniReader.setProperty(SECTION_ID, "forceStereoTune", force);
    }

    @Override
    public final boolean isForce3SIDTune() {
        return this.iniReader.getPropertyBool(SECTION_ID, "force3SIDTune", IniDefaults.DEFAULT_FORCE_3SID_TUNE);
    }

    @Override
    @Parameter(names={"--thirdSID", "-D", "--force3SIDTune"}, descriptionKey="THIRD_SID", arity=1, order=1031)
    public final void setForce3SIDTune(boolean force) {
        this.iniReader.setProperty(SECTION_ID, "force3SIDTune", force);
    }

    @Override
    public final boolean isMuteVoice1() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteVoice1", IniDefaults.DEFAULT_MUTE_VOICE1);
    }

    @Override
    @Parameter(names={"--muteVoice1", "-1"}, descriptionKey="MUTE_VOICE_1", arity=1, order=1032)
    public final void setMuteVoice1(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteVoice1", mute);
    }

    @Override
    public final boolean isMuteVoice2() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteVoice2", IniDefaults.DEFAULT_MUTE_VOICE2);
    }

    @Override
    @Parameter(names={"--muteVoice2", "-2"}, descriptionKey="MUTE_VOICE_2", arity=1, order=1033)
    public final void setMuteVoice2(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteVoice2", mute);
    }

    @Override
    public final boolean isMuteVoice3() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteVoice3", IniDefaults.DEFAULT_MUTE_VOICE3);
    }

    @Override
    @Parameter(names={"--muteVoice3", "-3"}, descriptionKey="MUTE_VOICE_3", arity=1, order=1034)
    public final void setMuteVoice3(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteVoice3", mute);
    }

    @Override
    public final boolean isMuteVoice4() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteVoice4", IniDefaults.DEFAULT_MUTE_VOICE4);
    }

    @Override
    @Parameter(names={"--muteVoice4", "-4"}, descriptionKey="MUTE_VOICE_4", arity=1, order=1035)
    public final void setMuteVoice4(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteVoice4", mute);
    }

    @Override
    public final boolean isMuteStereoVoice1() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteStereoVoice1", IniDefaults.DEFAULT_MUTE_STEREO_VOICE1);
    }

    @Override
    @Parameter(names={"--muteStereoVoice1", "-5"}, descriptionKey="MUTE_VOICE_5", arity=1, order=1036)
    public final void setMuteStereoVoice1(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteStereoVoice1", mute);
    }

    @Override
    public final boolean isMuteStereoVoice2() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteStereoVoice2", IniDefaults.DEFAULT_MUTE_STEREO_VOICE2);
    }

    @Override
    @Parameter(names={"--muteStereoVoice2", "-6"}, descriptionKey="MUTE_VOICE_6", arity=1, order=1037)
    public final void setMuteStereoVoice2(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteStereoVoice2", mute);
    }

    @Override
    public final boolean isMuteStereoVoice3() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteStereoVoice3", IniDefaults.DEFAULT_MUTE_STEREO_VOICE3);
    }

    @Override
    @Parameter(names={"--muteStereoVoice3", "-7"}, descriptionKey="MUTE_VOICE_7", arity=1, order=1038)
    public final void setMuteStereoVoice3(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteStereoVoice3", mute);
    }

    @Override
    public final boolean isMuteStereoVoice4() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteStereoVoice4", IniDefaults.DEFAULT_MUTE_STEREO_VOICE4);
    }

    @Override
    @Parameter(names={"--muteStereoVoice4", "-8"}, descriptionKey="MUTE_VOICE_8", arity=1, order=1039)
    public final void setMuteStereoVoice4(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteStereoVoice4", mute);
    }

    @Override
    public final boolean isMuteThirdSIDVoice1() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteThirdSIDVoice1", IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE1);
    }

    @Override
    @Parameter(names={"--muteThirdSidVoice1", "-9", "--muteThirdSIDVoice1"}, descriptionKey="MUTE_VOICE_9", arity=1, order=1040)
    public final void setMuteThirdSIDVoice1(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteThirdSIDVoice1", mute);
    }

    @Override
    public final boolean isMuteThirdSIDVoice2() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteThirdSIDVoice2", IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE2);
    }

    @Override
    @Parameter(names={"--muteThirdSidVoice2", "--muteThirdSIDVoice2"}, descriptionKey="MUTE_VOICE_10", arity=1, order=1041)
    public final void setMuteThirdSIDVoice2(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteThirdSIDVoice2", mute);
    }

    @Override
    public final boolean isMuteThirdSIDVoice3() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteThirdSIDVoice3", IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE3);
    }

    @Override
    @Parameter(names={"--muteThirdSidVoice3", "--muteThirdSIDVoice3"}, descriptionKey="MUTE_VOICE_11", arity=1, order=1042)
    public final void setMuteThirdSIDVoice3(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteThirdSIDVoice3", mute);
    }

    @Override
    public final boolean isMuteThirdSIDVoice4() {
        return this.iniReader.getPropertyBool(SECTION_ID, "muteThirdSIDVoice4", IniDefaults.DEFAULT_MUTE_THIRDSID_VOICE4);
    }

    @Override
    @Parameter(names={"--muteThirdSidVoice4", "--muteThirdSIDVoice4"}, descriptionKey="MUTE_VOICE_12", arity=1, order=1043)
    public final void setMuteThirdSIDVoice4(boolean mute) {
        this.iniReader.setProperty(SECTION_ID, "muteThirdSIDVoice4", mute);
    }

    @Override
    public final String getNetSIDFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "NetSID_Filter6581", IniDefaults.DEFAULT_NETSID_FILTER_6581);
    }

    @Override
    public final void setNetSIDFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "NetSID_Filter6581", filterName);
    }

    @Override
    public final String getNetSIDStereoFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "NetSID_Stereo_Filter6581", IniDefaults.DEFAULT_NETSID_STEREO_FILTER_6581);
    }

    @Override
    public final void setNetSIDStereoFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "NetSID_Stereo_Filter6581", filterName);
    }

    @Override
    public final String getNetSIDThirdSIDFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "NetSID_3rdSID_Filter6581", IniDefaults.DEFAULT_NETSID_3SID_FILTER_6581);
    }

    @Override
    public final void setNetSIDThirdSIDFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "NetSID_3rdSID_Filter6581", filterName);
    }

    @Override
    public final String getNetSIDFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "NetSID_Filter8580", IniDefaults.DEFAULT_NETSID_FILTER_8580);
    }

    @Override
    public final void setNetSIDFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "NetSID_Filter8580", filterName);
    }

    @Override
    public final String getNetSIDStereoFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "NetSID_Stereo_Filter8580", IniDefaults.DEFAULT_NETSID_STEREO_FILTER_8580);
    }

    @Override
    public final void setNetSIDStereoFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "NetSID_Stereo_Filter8580", filterName);
    }

    @Override
    public final String getNetSIDThirdSIDFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "NetSID_3rdSID_Filter8580", IniDefaults.DEFAULT_NETSID_3SID_FILTER_8580);
    }

    @Override
    public final void setNetSIDThirdSIDFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "NetSID_3rdSID_Filter8580", filterName);
    }

    @Override
    public final String getFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "Filter6581", IniDefaults.DEFAULT_FILTER_6581);
    }

    @Override
    @Parameter(names={"--filter6581"}, descriptionKey="FILTER_6581", validateWith={FilterNameValidator.ReSidFilter6581Validator.class}, order=1044)
    public final void setFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "Filter6581", filterName);
    }

    @Override
    public final String getStereoFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "Stereo_Filter6581", IniDefaults.DEFAULT_STEREO_FILTER_6581);
    }

    @Override
    @Parameter(names={"--stereoFilter6581"}, descriptionKey="STEREO_FILTER_6581", validateWith={FilterNameValidator.ReSidFilter6581Validator.class}, order=1045)
    public final void setStereoFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "Stereo_Filter6581", filterName);
    }

    @Override
    public final String getThirdSIDFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "3rdSID_Filter6581", IniDefaults.DEFAULT_3SID_FILTER_6581);
    }

    @Override
    @Parameter(names={"--thirdFilter6581", "--thirdSIDFilter6581"}, descriptionKey="THIRD_FILTER_6581", validateWith={FilterNameValidator.ReSidFilter6581Validator.class}, order=1046)
    public final void setThirdSIDFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "3rdSID_Filter6581", filterName);
    }

    @Override
    public final String getFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "Filter8580", IniDefaults.DEFAULT_FILTER_8580);
    }

    @Override
    @Parameter(names={"--filter8580"}, descriptionKey="FILTER_8580", validateWith={FilterNameValidator.ReSidFilter8580Validator.class}, order=1047)
    public final void setFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "Filter8580", filterName);
    }

    @Override
    public final String getStereoFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "Stereo_Filter8580", IniDefaults.DEFAULT_STEREO_FILTER_8580);
    }

    @Override
    @Parameter(names={"--stereoFilter8580"}, descriptionKey="STEREO_FILTER_8580", validateWith={FilterNameValidator.ReSidFilter8580Validator.class}, order=1048)
    public final void setStereoFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "Stereo_Filter8580", filterName);
    }

    @Override
    public final String getThirdSIDFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "3rdSID_Filter8580", IniDefaults.DEFAULT_3SID_FILTER_8580);
    }

    @Override
    @Parameter(names={"--thirdFilter8580", "--thirdSIDFilter8580"}, descriptionKey="THIRD_FILTER_8580", validateWith={FilterNameValidator.ReSidFilter8580Validator.class}, order=1049)
    public final void setThirdSIDFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "3rdSID_Filter8580", filterName);
    }

    @Override
    public final String getReSIDfpFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "ReSIDfp_Filter6581", IniDefaults.DEFAULT_ReSIDfp_FILTER_6581);
    }

    @Override
    @Parameter(names={"--reSIDfpFilter6581"}, descriptionKey="RESIDFP_FILTER_6581", validateWith={FilterNameValidator.ReSidFpFilter6581Validator.class}, order=1050)
    public final void setReSIDfpFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "ReSIDfp_Filter6581", filterName);
    }

    @Override
    public final String getReSIDfpStereoFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "ReSIDfp_Stereo_Filter6581", IniDefaults.DEFAULT_ReSIDfp_STEREO_FILTER_6581);
    }

    @Override
    @Parameter(names={"--reSIDfpStereoFilter6581"}, descriptionKey="RESIDFP_STEREO_FILTER_6581", validateWith={FilterNameValidator.ReSidFpFilter6581Validator.class}, order=1051)
    public final void setReSIDfpStereoFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "ReSIDfp_Stereo_Filter6581", filterName);
    }

    @Override
    public final String getReSIDfpThirdSIDFilter6581() {
        return this.iniReader.getPropertyString(SECTION_ID, "ReSIDfp_3rdSID_Filter6581", IniDefaults.DEFAULT_ReSIDfp_3SID_FILTER_6581);
    }

    @Override
    @Parameter(names={"--reSIDfpThirdFilter6581", "--reSIDfpThirdSIDFilter6581"}, descriptionKey="RESIDFP_THIRD_FILTER_6581", validateWith={FilterNameValidator.ReSidFpFilter6581Validator.class}, order=1052)
    public final void setReSIDfpThirdSIDFilter6581(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "ReSIDfp_3rdSID_Filter6581", filterName);
    }

    @Override
    public final String getReSIDfpFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "ReSIDfp_Filter8580", IniDefaults.DEFAULT_ReSIDfp_FILTER_8580);
    }

    @Override
    @Parameter(names={"--reSIDfpFilter8580"}, descriptionKey="RESIDFP_FILTER_8580", validateWith={FilterNameValidator.ReSidFpFilter8580Validator.class}, order=1053)
    public final void setReSIDfpFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "ReSIDfp_Filter8580", filterName);
    }

    @Override
    public final String getReSIDfpStereoFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "ReSIDfp_Stereo_Filter8580", IniDefaults.DEFAULT_ReSIDfp_STEREO_FILTER_8580);
    }

    @Override
    @Parameter(names={"--reSIDfpStereoFilter8580"}, descriptionKey="RESIDFP_STEREO_FILTER_8580", validateWith={FilterNameValidator.ReSidFpFilter8580Validator.class}, order=1054)
    public final void setReSIDfpStereoFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "ReSIDfp_Stereo_Filter8580", filterName);
    }

    @Override
    public final String getReSIDfpThirdSIDFilter8580() {
        return this.iniReader.getPropertyString(SECTION_ID, "ReSIDfp_3rdSID_Filter8580", IniDefaults.DEFAULT_ReSIDfp_3SID_FILTER_8580);
    }

    @Override
    @Parameter(names={"--reSIDfpThirdFilter8580", "--reSIDfpThirdSIDFilter8580"}, descriptionKey="RESIDFP_THIRD_FILTER_8580", validateWith={FilterNameValidator.ReSidFpFilter8580Validator.class}, order=1055)
    public final void setReSIDfpThirdSIDFilter8580(String filterName) {
        this.iniReader.setProperty(SECTION_ID, "ReSIDfp_3rdSID_Filter8580", filterName);
    }

    @Override
    public final IEmulationSection.OverrideSection getOverrideSection() {
        return this.overrideSection;
    }

    @Override
    public final boolean isDetectPSID64ChipModel() {
        return this.iniReader.getPropertyBool(SECTION_ID, "DetectPSID64ChipModel", IniDefaults.DEFAULT_DETECT_PSID64_CHIP_MODEL);
    }

    @Override
    @Parameter(names={"--detectPSID64ChipModel"}, descriptionKey="DETECT_PSID64_CHIP_MODEL", arity=1, order=1056)
    public final void setDetectPSID64ChipModel(boolean detectPSID64ChipModel) {
        this.iniReader.setProperty(SECTION_ID, "DetectPSID64ChipModel", detectPSID64ChipModel);
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

