/*
 * Decompiled with CFR 0.152.
 */
package sidplay.player;

import java.util.List;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;

public final class PSid64DetectedTuneInfo {
    private final boolean detected;
    private final CPUClock cpuClock;
    private final List<ChipModel> chipModels;
    private final int stereoAddress;

    public PSid64DetectedTuneInfo(boolean detected, CPUClock cpuClock, List<ChipModel> chipModels, int stereoAddress) {
        this.detected = detected;
        this.cpuClock = cpuClock;
        this.chipModels = chipModels;
        this.stereoAddress = stereoAddress;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public CPUClock getCpuClock() {
        return this.cpuClock;
    }

    public ChipModel getUserChipModel() {
        return this.chipModels.get(0);
    }

    public ChipModel getStereoChipModel() {
        return this.chipModels.get(1);
    }

    public int getStereoAddress() {
        return this.stereoAddress;
    }

    public boolean hasDifferentCPUClock(CPUClock clock) {
        return this.cpuClock != null && this.cpuClock != clock;
    }

    public boolean hasDifferentUserChipModel(ChipModel userSidModel) {
        return this.chipModels.size() > 0 && userSidModel != this.chipModels.get(0);
    }

    public boolean hasDifferentStereoChipModel(ChipModel stereoSidModel) {
        return this.chipModels.size() > 1 && stereoSidModel != this.chipModels.get(1);
    }

    public boolean hasDifferentStereoAddress(int dualSidBase) {
        return this.stereoAddress != 0 && dualSidBase != this.stereoAddress;
    }
}

