/*
 * Decompiled with CFR 0.152.
 */
package sidplay.player;

import java.io.IOException;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2Section;
import libsidplay.config.IWhatsSidSection;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import sidplay.Player;
import sidplay.fingerprinting.WhatsSidSupport;

public class WhatsSidEvent
extends Event {
    private final Player player;
    private final WhatsSidSupport whatsSidSupport;
    private volatile boolean abort;

    public WhatsSidEvent(Player player, WhatsSidSupport whatsSidSupport) {
        super("WhatsSID?");
        this.player = player;
        this.whatsSidSupport = whatsSidSupport;
        whatsSidSupport.reset();
    }

    @Override
    public void event() throws InterruptedException {
        Thread whatsSidMatcherThread = new Thread(() -> {
            IWhatsSidSection whatsSidSection = this.player.getConfig().getWhatsSidSection();
            int matchRetryTimeInSeconds = whatsSidSection.getMatchRetryTime();
            try {
                MusicInfoWithConfidenceBean result;
                if (!this.abort && whatsSidSection.isEnable() && this.player.getFingerPrintMatcher() != null && (result = this.whatsSidSupport.match(this.player.getFingerPrintMatcher())) != null) {
                    this.player.getWhatsSidHook().accept(result);
                    if (whatsSidSection.isDetectChipModel()) {
                        this.setWhatsSidDetectedChipModel(result);
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (!this.abort) {
                    this.player.getC64().getEventScheduler().schedule(this, (long)((double)matchRetryTimeInSeconds * this.player.getC64().getClock().getCpuFrequency()));
                }
            }
        }, "WhatsSID?");
        whatsSidMatcherThread.setPriority(1);
        whatsSidMatcherThread.start();
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public void start() {
        IWhatsSidSection whatsSidSection = this.player.getConfig().getWhatsSidSection();
        int matchStartTimeInSeconds = whatsSidSection.getMatchStartTime();
        Double songLength = this.player.getSidDatabaseInfo(db -> db.getSongLength(this.player.getTune()), 0.0);
        if (songLength > 0.0 && songLength < (double)matchStartTimeInSeconds) {
            matchStartTimeInSeconds = Math.min((int)(songLength * 0.9), matchStartTimeInSeconds);
        }
        this.player.getC64().getEventScheduler().schedule(this, (long)((double)matchStartTimeInSeconds * this.player.getC64().getClock().getCpuFrequency()));
    }

    private void setWhatsSidDetectedChipModel(MusicInfoWithConfidenceBean result) throws IOException, SidTuneError {
        SidTune tune = this.player.getTune();
        ISidPlay2Section sidPlay2Section = this.player.getConfig().getSidplay2Section();
        IEmulationSection emulationSection = this.player.getConfig().getEmulationSection();
        String infoDir = result.getMusicInfo().getInfoDir();
        SidTune detectedTune = SidTune.load(IOUtils.getFile(infoDir, sidPlay2Section.getHvsc(), null));
        boolean update = false;
        for (int sidNum = 0; sidNum < 3; ++sidNum) {
            SidTune.Model tuneSidModel;
            ChipModel detectedChipModel = detectedTune.getInfo().getSIDModel(sidNum).asChipModel();
            SidTune.Model model = tuneSidModel = tune != SidTune.RESET ? tune.getInfo().getSIDModel(0) : SidTune.Model.UNKNOWN;
            if (tuneSidModel != SidTune.Model.UNKNOWN || detectedChipModel == null) continue;
            emulationSection.getOverrideSection().getSidModel()[sidNum] = detectedChipModel;
            update = true;
        }
        if (update) {
            this.player.updateSIDChipConfiguration();
        }
    }
}

