/*
 * Decompiled with CFR 0.152.
 */
package ui.assembly64;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import libsidplay.sidtune.SidTuneError;
import server.restful.common.parameter.requestpath.impl.FileRequestPathServletParametersImpl;
import sidplay.Player;
import ui.assembly64.Age;
import ui.assembly64.Category;
import ui.assembly64.CategoryDeserializer;
import ui.assembly64.CategoryToStringConverter;
import ui.assembly64.ContentEntry;
import ui.assembly64.ContentEntrySearchResult;
import ui.assembly64.ErrorMessage;
import ui.assembly64.Presets;
import ui.assembly64.SearchResult;
import ui.assembly64.ZeroIgnoringCellFactory;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.common.TypeTextField;
import ui.common.UIPart;
import ui.common.converter.EnumToStringConverter;
import ui.common.converter.IntegerToStringConverter;
import ui.common.filefilter.DiskFileFilter;
import ui.common.filefilter.TapeFileFilter;
import ui.common.util.InternetUtil;
import ui.directory.Directory;
import ui.entities.config.Assembly64Column;
import ui.entities.config.Assembly64ColumnType;

public class Assembly64
extends C64VBox
implements UIPart {
    public static final String ID = "ASSEMBLY64";
    private static final int MAX_ROWS = 500;
    private static final int DEFAULT_WIDTH = 150;
    @FXML
    private BorderPane borderPane;
    @FXML
    private HBox hBox;
    @FXML
    private VBox nameVBox;
    @FXML
    private VBox groupVBox;
    @FXML
    private VBox handleVBox;
    @FXML
    private VBox eventVBox;
    @FXML
    private VBox ratingVBox;
    @FXML
    private VBox categoryVBox;
    @FXML
    private VBox updatedVBox;
    @FXML
    private VBox releasedVBox;
    @FXML
    private TextField nameTextField;
    @FXML
    private TextField groupTextField;
    @FXML
    private TextField handleTextField;
    @FXML
    private TextField eventTextField;
    @FXML
    private TextField updatedTextField;
    @FXML
    private TypeTextField releasedTextField;
    @FXML
    private ComboBox<Category> categoryComboBox;
    @FXML
    private ComboBox<Integer> ratingComboBox;
    @FXML
    private ComboBox<Age> ageComboBox;
    @FXML
    private CheckBox d64CheckBox;
    @FXML
    private CheckBox t64CheckBox;
    @FXML
    private CheckBox d81CheckBox;
    @FXML
    private CheckBox d71CheckBox;
    @FXML
    private CheckBox prgCheckBox;
    @FXML
    private CheckBox tapCheckBox;
    @FXML
    private CheckBox crtCheckBox;
    @FXML
    private CheckBox sidCheckBox;
    @FXML
    private CheckBox binCheckBox;
    @FXML
    private CheckBox g64CheckBox;
    @FXML
    private TableView<SearchResult> assembly64Table;
    @FXML
    private TableView<ContentEntry> contentEntryTable;
    @FXML
    private TableColumn<ContentEntry, String> contentEntryFilenameColumn;
    @FXML
    private ContextMenu assembly64ContextMenu;
    @FXML
    private ContextMenu contentEntryContextMenu;
    @FXML
    private Menu addColumnMenu;
    @FXML
    private MenuItem removeColumnMenuItem;
    @FXML
    private MenuItem insertDiskMenuItem;
    @FXML
    private MenuItem insertTapeMenuItem;
    @FXML
    private MenuItem autostartMenuItem;
    @FXML
    private Button prevButton;
    @FXML
    private Button nextButton;
    @FXML
    private Directory directory;
    @FXML
    private ObjectProperty<SearchResult> currentlyPlayedSearchResultRowProperty;
    @FXML
    private ObjectProperty<ContentEntry> currentlyPlayedContentEntryRowProperty;
    private ObservableList<Category> categoryItems;
    private ObservableList<SearchResult> searchResultItems;
    private ObservableList<ContentEntry> contentEntryItems;
    private SearchResult searchResult;
    private ContentEntry contentEntry;
    private File contentEntryFile;
    private int searchOffset;
    private int searchStop = 500;
    private DiskFileFilter diskFileFilter;
    private TapeFileFilter tapeFileFilter;
    private ObjectMapper objectMapper;
    private Convenience convenience;
    private AtomicBoolean autostart;
    private PauseTransition pauseTransitionSearchResult;
    private PauseTransition pauseTransitionContentEntries;
    private SequentialTransition sequentialTransitionSearchResult;
    private SequentialTransition sequentialTransitionContentEntries;
    private TablePosition<?, ?> searchResultTableSelectedCell;

    public Assembly64() {
    }

    public Assembly64(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.autostart = new AtomicBoolean();
        this.convenience = new Convenience(this.util.getPlayer());
        this.diskFileFilter = new DiskFileFilter();
        this.tapeFileFilter = new TapeFileFilter();
        this.categoryItems = FXCollections.observableArrayList(this.getCategories(this.requestPresets()));
        this.objectMapper = this.createObjectMapper();
        this.searchResultItems = FXCollections.observableArrayList();
        SortedList sortedSearchResultList = new SortedList(this.searchResultItems);
        sortedSearchResultList.comparatorProperty().bind((ObservableValue)this.assembly64Table.comparatorProperty());
        this.assembly64Table.setItems((ObservableList)sortedSearchResultList);
        this.assembly64Table.getSelectionModel().selectedItemProperty().addListener((s, o, n) -> this.getContentEntries(false));
        this.assembly64Table.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.assembly64Table.setOnMousePressed(e -> this.getContentEntries(e.isPrimaryButtonDown() && e.getClickCount() > 1));
        this.assembly64Table.setOnKeyPressed(event -> this.getContentEntries(event.getCode() == KeyCode.ENTER));
        this.assembly64Table.getColumns().addListener(change -> {
            while (change.next()) {
                if (!change.wasReplaced()) continue;
                this.moveColumn();
            }
        });
        this.assembly64ContextMenu.setOnShown(event -> this.showAssembly64ContextMenu());
        this.restoreColumns();
        this.contentEntryItems = FXCollections.observableArrayList();
        SortedList sortedContentEntryList = new SortedList(this.contentEntryItems);
        sortedContentEntryList.comparatorProperty().bind((ObservableValue)this.contentEntryTable.comparatorProperty());
        this.contentEntryTable.setItems((ObservableList)sortedContentEntryList);
        this.contentEntryTable.getSelectionModel().selectedItemProperty().addListener((s, o, n) -> this.getContentEntry(false));
        this.contentEntryTable.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.contentEntryTable.setOnMousePressed(e -> this.getContentEntry(e.isPrimaryButtonDown() && e.getClickCount() > 1));
        this.contentEntryTable.setOnKeyReleased(event -> this.getContentEntry(event.getCode() == KeyCode.ENTER));
        this.contentEntryTable.prefWidthProperty().bind((ObservableValue)this.assembly64Table.widthProperty().multiply(0.5));
        this.contentEntryTable.prefHeightProperty().bind((ObservableValue)this.borderPane.heightProperty().multiply(0.4));
        this.contentEntryContextMenu.setOnShown(event -> this.showContentEntryContextMenu());
        this.contentEntryFilenameColumn.prefWidthProperty().bind((ObservableValue)this.contentEntryTable.widthProperty());
        this.directory.getAutoStartFileProperty().addListener((s, o, n) -> this.autostart((String)n));
        this.directory.prefWidthProperty().bind((ObservableValue)this.assembly64Table.widthProperty().multiply(0.5));
        this.directory.prefHeightProperty().bind((ObservableValue)this.borderPane.heightProperty().multiply(0.4));
        this.ratingComboBox.setItems(FXCollections.observableArrayList((Collection)IntStream.concat(IntStream.of(0), IntStream.rangeClosed(1, 10)).boxed().collect(Collectors.toList())));
        this.ratingComboBox.getSelectionModel().select(0);
        this.ratingComboBox.setConverter((StringConverter)new IntegerToStringConverter(this.util.getBundle(), "ALL_CONTENT"));
        this.ageComboBox.setConverter(new EnumToStringConverter(this.util.getBundle()));
        this.ageComboBox.setItems(FXCollections.observableArrayList((Object[])Age.values()));
        this.ageComboBox.getSelectionModel().select((Object)Age.ALL);
        this.categoryComboBox.setConverter(new CategoryToStringConverter(this.util.getBundle()));
        this.categoryComboBox.setItems(this.categoryItems);
        this.categoryComboBox.getSelectionModel().select((Object)Category.ALL);
        this.pauseTransitionSearchResult = new PauseTransition(Duration.millis((double)1000.0));
        this.sequentialTransitionSearchResult = new SequentialTransition(new Animation[]{this.pauseTransitionSearchResult});
        this.sequentialTransitionSearchResult.setCycleCount(1);
        this.pauseTransitionSearchResult.setOnFinished(evt -> this.requestSearchResults());
        this.pauseTransitionContentEntries = new PauseTransition(Duration.millis((double)500.0));
        this.sequentialTransitionContentEntries = new SequentialTransition(new Animation[]{this.pauseTransitionContentEntries});
        this.sequentialTransitionContentEntries.setCycleCount(1);
        this.pauseTransitionContentEntries.setOnFinished(evt -> this.requestContentEntries());
    }

    private List<Category> getCategories(Collection<Presets> presets) {
        List<Category> categories = ((Collection)presets.stream().filter(preset -> "subcat".equals(preset.getType())).findFirst().map(Presets::getValues).orElse(Collections.emptyList())).stream().map(Category::new).sorted(Comparator.comparing(Category::getName)).collect(Collectors.toList());
        categories.add(0, Category.ALL);
        return categories;
    }

    @Override
    public void doClose() {
        this.sequentialTransitionSearchResult.stop();
        this.sequentialTransitionContentEntries.stop();
    }

    @FXML
    private void removeColumn() {
        if (this.searchResultTableSelectedCell == null) {
            return;
        }
        TableColumn tableColumn = this.searchResultTableSelectedCell.getTableColumn();
        this.assembly64Table.getColumns().remove((Object)tableColumn);
        this.removeColumn((Assembly64Column)tableColumn.getUserData());
    }

    @FXML
    private void search() {
        this.searchOffset = 0;
        this.searchAgain();
    }

    @FXML
    private void prevPage() {
        this.searchOffset -= 500;
        this.searchAgain();
    }

    @FXML
    private void nextPage() {
        this.searchOffset = this.searchStop;
        this.searchAgain();
    }

    @FXML
    private void autostart() {
        this.autostart(null);
    }

    @FXML
    private void insertDisk() {
        if (this.contentEntryFile != null) {
            try {
                this.util.getPlayer().insertDisk(this.contentEntryFile);
            }
            catch (IOException e) {
                System.err.println(String.format("Cannot insert media file '%s'.", this.contentEntry.getId()));
            }
        }
    }

    @FXML
    private void insertTape() {
        if (this.contentEntryFile != null) {
            try {
                this.util.getPlayer().insertTape(this.contentEntryFile);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", this.contentEntry.getId()));
            }
        }
    }

    private void restoreColumns() {
        this.hBox.getChildren().clear();
        this.util.getConfig().getAssembly64Section().getColumns().removeIf(column -> column.getColumnType() == null);
        for (Assembly64Column column2 : this.util.getConfig().getAssembly64Section().getColumns()) {
            this.setColumnWidth(column2, this.addColumn(column2).getPrefWidth());
        }
    }

    private void showAssembly64ContextMenu() {
        this.searchResultTableSelectedCell = this.assembly64Table.getSelectionModel().getSelectedCells().stream().findFirst().orElse(null);
        this.removeColumnMenuItem.setDisable(this.searchResultTableSelectedCell == null || this.searchResultTableSelectedCell.getColumn() <= 0);
        this.removeColumnMenuItem.setText(String.format(this.util.getBundle().getString("REMOVE_COLUMN"), !this.removeColumnMenuItem.isDisable() ? this.searchResultTableSelectedCell.getTableColumn().getText() : "?"));
        ArrayList<Assembly64ColumnType> columnTypes = new ArrayList<Assembly64ColumnType>(Arrays.asList(Assembly64ColumnType.values()));
        columnTypes.removeIf(columnType -> this.assembly64Table.getColumns().stream().map(tableColumn -> ((Assembly64Column)tableColumn.getUserData()).getColumnType()).collect(Collectors.toList()).contains(columnType));
        this.addColumnMenu.getItems().clear();
        for (Assembly64ColumnType columnType2 : columnTypes) {
            this.addAddColumnHeaderMenuItem(columnType2);
        }
    }

    private void showContentEntryContextMenu() {
        ContentEntry contentEntry = (ContentEntry)this.contentEntryTable.getSelectionModel().getSelectedItem();
        this.insertDiskMenuItem.setDisable(contentEntry == null || !this.diskFileFilter.accept(new File(contentEntry.getId())));
        this.insertTapeMenuItem.setDisable(contentEntry == null || !this.tapeFileFilter.accept(new File(contentEntry.getId())));
        this.autostartMenuItem.setDisable(contentEntry == null);
    }

    private void addAddColumnHeaderMenuItem(Assembly64ColumnType columnType) {
        MenuItem menuItem = new MenuItem();
        menuItem.setText(this.util.getBundle().getString(columnType.name()));
        menuItem.setOnAction(event -> {
            Assembly64Column column = new Assembly64Column();
            column.setColumnType(columnType);
            this.addColumn(column);
            this.util.getConfig().getAssembly64Section().getColumns().add(column);
        });
        this.addColumnMenu.getItems().add((Object)menuItem);
    }

    private TableColumn<SearchResult, ?> addColumn(Assembly64Column column) {
        TableColumn tableColumn;
        Assembly64ColumnType columnType = column.getColumnType();
        switch (columnType) {
            case RATING: {
                TableColumn tableColumnInteger;
                tableColumn = tableColumnInteger = new TableColumn();
                tableColumnInteger.setCellValueFactory((Callback)new PropertyValueFactory(columnType.name().toLowerCase()));
                tableColumnInteger.setCellFactory((Callback)new ZeroIgnoringCellFactory());
                break;
            }
            case UPDATED: 
            case RELEASED: {
                TableColumn tableColumnLocalDate;
                tableColumn = tableColumnLocalDate = new TableColumn();
                tableColumnLocalDate.setCellValueFactory((Callback)new PropertyValueFactory(columnType.name().toLowerCase()));
                break;
            }
            default: {
                TableColumn tableColumnString;
                tableColumn = tableColumnString = new TableColumn();
                tableColumnString.setCellValueFactory((Callback)new PropertyValueFactory(columnType.name().toLowerCase()));
            }
        }
        tableColumn.setUserData((Object)column);
        tableColumn.setText(this.util.getBundle().getString(columnType.name()));
        tableColumn.setPrefWidth(column.getWidth() != 0.0 ? column.getWidth() : 150.0);
        tableColumn.widthProperty().addListener((observable, oldValue, newValue) -> {
            column.setWidth(newValue.doubleValue());
            this.setColumnWidth(column, (Number)newValue);
        });
        this.assembly64Table.getColumns().add((Object)tableColumn);
        switch (columnType) {
            case NAME: {
                this.hBox.getChildren().add((Object)this.nameVBox);
                break;
            }
            case GROUP: {
                this.hBox.getChildren().add((Object)this.groupVBox);
                break;
            }
            case HANDLE: {
                this.hBox.getChildren().add((Object)this.handleVBox);
                break;
            }
            case EVENT: {
                this.hBox.getChildren().add((Object)this.eventVBox);
                break;
            }
            case RATING: {
                this.hBox.getChildren().add((Object)this.ratingVBox);
                break;
            }
            case CATEGORY: {
                this.hBox.getChildren().add((Object)this.categoryVBox);
                break;
            }
            case UPDATED: {
                this.hBox.getChildren().add((Object)this.updatedVBox);
                break;
            }
            case RELEASED: {
                this.hBox.getChildren().add((Object)this.releasedVBox);
                break;
            }
        }
        return tableColumn;
    }

    private void setColumnWidth(Assembly64Column column, Number width) {
        switch (column.getColumnType()) {
            case NAME: {
                this.nameTextField.setPrefWidth(width.doubleValue());
                break;
            }
            case GROUP: {
                this.groupTextField.setPrefWidth(width.doubleValue());
                break;
            }
            case HANDLE: {
                this.handleTextField.setPrefWidth(width.doubleValue());
                break;
            }
            case EVENT: {
                this.eventTextField.setPrefWidth(width.doubleValue());
                break;
            }
            case RATING: {
                this.ratingComboBox.setPrefWidth(width.doubleValue());
                break;
            }
            case CATEGORY: {
                this.categoryComboBox.setPrefWidth(width.doubleValue());
                break;
            }
            case UPDATED: {
                this.updatedTextField.setPrefWidth(width.doubleValue());
                break;
            }
            case RELEASED: {
                this.releasedTextField.setPrefWidth(width.doubleValue());
            }
        }
    }

    private void removeColumn(Assembly64Column column) {
        boolean repeatSearch = false;
        switch (column.getColumnType()) {
            case NAME: {
                this.hBox.getChildren().remove((Object)this.nameVBox);
                repeatSearch = !this.nameTextField.getText().isEmpty();
                this.nameTextField.setText("");
                break;
            }
            case GROUP: {
                this.hBox.getChildren().remove((Object)this.groupVBox);
                repeatSearch = !this.groupTextField.getText().isEmpty();
                this.groupTextField.setText("");
                break;
            }
            case HANDLE: {
                this.hBox.getChildren().remove((Object)this.handleVBox);
                repeatSearch = !this.handleTextField.getText().isEmpty();
                this.handleTextField.setText("");
                break;
            }
            case EVENT: {
                this.hBox.getChildren().remove((Object)this.eventVBox);
                repeatSearch = !this.eventTextField.getText().isEmpty();
                this.eventTextField.setText("");
                break;
            }
            case RATING: {
                this.hBox.getChildren().remove((Object)this.ratingVBox);
                repeatSearch = this.ratingComboBox.getSelectionModel().getSelectedIndex() > 0;
                this.ratingComboBox.getSelectionModel().select(0);
                break;
            }
            case CATEGORY: {
                this.hBox.getChildren().remove((Object)this.categoryVBox);
                repeatSearch = this.categoryComboBox.getSelectionModel().getSelectedIndex() > 0;
                this.categoryComboBox.getSelectionModel().select((Object)Category.ALL);
                break;
            }
            case UPDATED: {
                this.hBox.getChildren().remove((Object)this.updatedVBox);
                break;
            }
            case RELEASED: {
                this.hBox.getChildren().remove((Object)this.releasedVBox);
                repeatSearch = !this.releasedTextField.getText().isEmpty();
                break;
            }
        }
        this.util.getConfig().getAssembly64Section().getColumns().remove(column);
        if (repeatSearch) {
            this.search();
        }
    }

    private void moveColumn() {
        this.hBox.getChildren().clear();
        this.util.getConfig().getAssembly64Section().getColumns().clear();
        this.assembly64Table.getColumns().stream().map(tableColumn -> (Assembly64Column)tableColumn.getUserData()).filter(column -> {
            switch (column.getColumnType()) {
                case NAME: {
                    return this.hBox.getChildren().add((Object)this.nameVBox);
                }
                case GROUP: {
                    return this.hBox.getChildren().add((Object)this.groupVBox);
                }
                case HANDLE: {
                    return this.hBox.getChildren().add((Object)this.handleVBox);
                }
                case EVENT: {
                    return this.hBox.getChildren().add((Object)this.eventVBox);
                }
                case RATING: {
                    return this.hBox.getChildren().add((Object)this.ratingVBox);
                }
                case CATEGORY: {
                    return this.hBox.getChildren().add((Object)this.categoryVBox);
                }
                case UPDATED: {
                    return this.hBox.getChildren().add((Object)this.updatedVBox);
                }
                case RELEASED: {
                    return this.hBox.getChildren().add((Object)this.releasedVBox);
                }
            }
            return false;
        }).forEach(column -> this.util.getConfig().getAssembly64Section().getColumns().add((Assembly64Column)column));
    }

    private ObjectMapper createObjectMapper() {
        JavaTimeModule module = new JavaTimeModule();
        module.addDeserializer(Category.class, (JsonDeserializer)new CategoryDeserializer((List<Category>)this.categoryItems));
        return new ObjectMapper().registerModule((Module)module);
    }

    private Collection<Presets> requestPresets() {
        try {
            String assembly64Url = this.util.getConfig().getOnlineSection().getAssembly64Url();
            URL url = new URI(assembly64Url + "/leet/search/aql/presets").toURL();
            String responseString = this.readString(InternetUtil.openConnection(url, this.util.getConfig().getSidplay2Section()));
            return (Collection)new ObjectMapper().readerForListOf(Presets.class).readValue(responseString);
        }
        catch (IOException | URISyntaxException e) {
            System.err.println("Unexpected result: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private void searchAgain() {
        this.searchResultItems.clear();
        this.contentEntryItems.clear();
        this.directory.clear();
        Platform.runLater(() -> this.util.progressProperty(this.assembly64Table.getScene()).set(-1.0));
        this.sequentialTransitionSearchResult.playFromStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestSearchResults() {
        try {
            StringBuilder query;
            String responseString;
            String assembly64Url;
            block29: {
                assembly64Url = this.util.getConfig().getOnlineSection().getAssembly64Url();
                String name = this.get(this.nameTextField);
                String group = this.get(this.groupTextField);
                String handle = this.get(this.handleTextField);
                String event = this.get(this.eventTextField);
                Integer rating = this.get(this.ratingComboBox, value -> value, 0::equals, null);
                String subCategory = this.get(this.categoryComboBox, value -> value.getType(), Category.ALL::equals, null);
                Integer days = this.get(this.ageComboBox, value -> value.getDays(), Age.ALL::equals, -1);
                String dateFrom = this.get(this.releasedTextField, true);
                String dateTo = this.get(this.releasedTextField, false);
                String d64 = this.get(this.d64CheckBox);
                String t64 = this.get(this.t64CheckBox);
                String d71 = this.get(this.d71CheckBox);
                String d81 = this.get(this.d81CheckBox);
                String prg = this.get(this.prgCheckBox);
                String tap = this.get(this.tapCheckBox);
                String crt = this.get(this.crtCheckBox);
                String sid = this.get(this.sidCheckBox);
                String bin = this.get(this.binCheckBox);
                String g64 = this.get(this.g64CheckBox);
                responseString = null;
                ArrayList<String> searchCriterias = new ArrayList<String>();
                if (name != null) {
                    searchCriterias.add("name:\"" + name + "\"");
                }
                if (group != null) {
                    searchCriterias.add("group:\"" + group + "\"");
                }
                if (handle != null) {
                    searchCriterias.add("handle:\"" + handle + "\"");
                }
                if (event != null) {
                    searchCriterias.add("event:\"" + event + "\"");
                }
                if (rating != null) {
                    searchCriterias.add("rating:>=" + rating);
                }
                if (subCategory != null) {
                    searchCriterias.add("subcat:" + subCategory);
                }
                if (days > 0) {
                    searchCriterias.add("latest:\"" + days + "days\"");
                }
                if (dateFrom != null || dateTo != null) {
                    searchCriterias.add("date:" + dateFrom + "-" + dateTo);
                }
                ArrayList<String> types = new ArrayList<String>();
                if ("Y".equals(d64)) {
                    types.add("d64");
                }
                if ("Y".equals(t64)) {
                    types.add("t64");
                }
                if ("Y".equals(d71)) {
                    types.add("d71");
                }
                if ("Y".equals(d81)) {
                    types.add("d81");
                }
                if ("Y".equals(prg)) {
                    types.add("prg");
                }
                if ("Y".equals(tap)) {
                    types.add("tap");
                }
                if ("Y".equals(crt)) {
                    types.add("crt");
                }
                if ("Y".equals(sid)) {
                    types.add("sid");
                }
                if ("Y".equals(bin)) {
                    types.add("bin");
                }
                if ("Y".equals(g64)) {
                    types.add("g64");
                }
                query = new StringBuilder();
                if (!searchCriterias.isEmpty()) {
                    query.append(searchCriterias.stream().collect(Collectors.joining("+")));
                }
                if (!types.isEmpty()) {
                    query.append("+type:" + types.stream().collect(Collectors.joining(",")));
                }
                if (!searchCriterias.isEmpty()) break block29;
                return;
            }
            try {
                URL url = this.appendURI(new URI(assembly64Url + "/leet/search/aql/" + this.searchOffset + "/" + 500), query.toString()).toURL();
                responseString = this.readString(InternetUtil.openConnection(url, this.util.getConfig().getSidplay2Section()));
                this.searchResultItems.setAll((Object[])((SearchResult[])this.objectMapper.readValue(responseString, SearchResult[].class)));
                this.prevButton.setDisable(this.searchOffset == 0);
                this.nextButton.setDisable(this.searchResultItems.size() < 500);
                this.searchStop = this.searchOffset + this.searchResultItems.size();
            }
            catch (IOException | URISyntaxException e) {
                try {
                    ErrorMessage errorMessage = (ErrorMessage)this.objectMapper.readValue(responseString, ErrorMessage.class);
                    System.err.println(String.join((CharSequence)"\n", errorMessage.getStatus() + ": " + errorMessage.getError(), errorMessage.getMessage()));
                }
                catch (IOException e1) {
                    System.err.println("Unexpected result: " + e.getMessage());
                }
            }
        }
        finally {
            Platform.runLater(() -> this.util.progressProperty(this.assembly64Table.getScene()).set(0.0));
        }
    }

    private void getContentEntries(boolean doAutostart) {
        this.searchResult = (SearchResult)this.assembly64Table.getSelectionModel().getSelectedItem();
        if (this.searchResult == null) {
            return;
        }
        this.autostart.set(doAutostart);
        Platform.runLater(() -> this.util.progressProperty(this.assembly64Table.getScene()).set(-1.0));
        this.sequentialTransitionContentEntries.playFromStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestContentEntries() {
        try {
            if (this.searchResult == null) {
                return;
            }
            this.directory.clear();
            String assembly64Url = this.util.getConfig().getOnlineSection().getAssembly64Url();
            String itemId = Base64.getEncoder().encodeToString(this.searchResult.getId().getBytes());
            Integer categoryId = this.searchResult.getCategory().getId();
            URL url = new URI(assembly64Url + "/leet/search/legacy/entries/" + itemId + "/" + categoryId).toURL();
            String responseString = this.readString(InternetUtil.openConnection(url, this.util.getConfig().getSidplay2Section()));
            ContentEntrySearchResult contentEntry = (ContentEntrySearchResult)this.objectMapper.readValue(responseString, ContentEntrySearchResult.class);
            this.contentEntryItems.setAll((Collection)contentEntry.getContentEntry().stream().filter(e -> !e.getId().startsWith("__MACOSX")).collect(Collectors.toList()));
            this.contentEntryTable.getSelectionModel().select((Object)this.contentEntryItems.stream().findFirst().orElse(null));
            if (this.autostart.getAndSet(false)) {
                this.autostart(null);
            }
        }
        catch (IOException | URISyntaxException e2) {
            System.err.println("Unexpected result: " + e2.getMessage());
        }
        finally {
            Platform.runLater(() -> this.util.progressProperty(this.assembly64Table.getScene()).set(0.0));
        }
    }

    private void getContentEntry(boolean doAutostart) {
        try {
            if (this.contentEntryTable.getSelectionModel().getSelectedItem() == null || Objects.equals(this.contentEntryTable.getSelectionModel().getSelectedItem(), this.contentEntry)) {
                return;
            }
            this.contentEntry = (ContentEntry)this.contentEntryTable.getSelectionModel().getSelectedItem();
            this.contentEntryFile = FileRequestPathServletParametersImpl.fetchAssembly64File(this.util.getConfig(), this.searchResult.getId(), String.valueOf(this.searchResult.getCategory().getId()), this.contentEntry.getId());
            this.directory.loadPreview(this.contentEntryFile);
        }
        catch (IOException | URISyntaxException e) {
            System.err.println(String.format("Cannot DOWNLOAD file '%s'.", this.contentEntry.getId()));
        }
        finally {
            if (doAutostart) {
                this.autostart(null);
            }
        }
    }

    private String get(TypeTextField field, boolean dateFromTo) {
        Object value = field.getValue();
        if (value instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)value;
            value = LocalDate.of(yearMonth.getYear(), yearMonth.getMonthValue(), dateFromTo ? 1 : yearMonth.lengthOfMonth());
        } else if (value instanceof Year) {
            Year year = (Year)value;
            value = LocalDate.of(year.getValue(), dateFromTo ? 1 : 12, dateFromTo ? 1 : 31);
        }
        if (value == null) {
            return null;
        }
        return ((LocalDate)value).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private <T, U> U get(ComboBox<T> comboBox, Function<T, U> toResult, Predicate<T> checkEmpty, U emptyValue) {
        Object value = comboBox.getValue();
        if (checkEmpty.test(value)) {
            return emptyValue;
        }
        return toResult.apply(value);
    }

    private String get(TextField field) {
        String value = field.getText().trim();
        if (value.isEmpty()) {
            return null;
        }
        return value;
    }

    private String get(CheckBox field) {
        return field.isSelected() ? "Y" : "N";
    }

    private void autostart(String dirEntry) {
        if (this.contentEntry != null && this.contentEntryFile != null) {
            try {
                if (this.convenience.autostart(this.contentEntryFile, Convenience.LEXICALLY_FIRST_MEDIA, dirEntry, true).isSuccess()) {
                    this.util.setPlayingTab((Node)this, this.currentlyPlayedSearchResultRowProperty, this.currentlyPlayedContentEntryRowProperty);
                    this.currentlyPlayedSearchResultRowProperty.set((Object)this.searchResult);
                    this.currentlyPlayedContentEntryRowProperty.set((Object)this.contentEntry);
                }
            }
            catch (IOException | SidTuneError e) {
                e.printStackTrace();
                System.err.println(String.format("Cannot AUTOSTART file '%s'.", this.contentEntry.getId()));
            }
        }
    }

    public URI appendURI(URI oldUri, String queryParamValue) throws URISyntaxException {
        String newQuery = "query=" + queryParamValue;
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), newQuery, oldUri.getFragment());
    }

    private String readString(URLConnection connection) throws IOException {
        StringBuffer result = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String output;
            while ((output = br.readLine()) != null) {
                result.append(output).append("\n");
            }
        }
        return result.toString();
    }
}

