/*
 * Decompiled with CFR 0.152.
 */
package ui.common;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import libsidplay.components.cart.CartridgeType;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.ZipFileUtils;
import libsidutils.directory.DirEntry;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TFile;
import sidplay.Player;
import sidplay.filefilter.UUIDFileFilter;
import ui.JSidPlay2Main;
import ui.common.ConvenienceResult;
import ui.common.filefilter.CartFileFilter;
import ui.common.filefilter.DiskFileFilter;
import ui.common.filefilter.TapeFileFilter;
import ui.common.filefilter.TuneFileFilter;
import ui.common.util.Extract7ZipUtil;
import ui.menubar.MenuBar;

public class Convenience {
    public static final Comparator<? super File> TOP_LEVEL_FIRST_COMPARATOR = (f1, f2) -> {
        if (f1.isDirectory() && !f2.isDirectory()) {
            return 1;
        }
        if (!f1.isDirectory() && f2.isDirectory()) {
            return -1;
        }
        String ext1 = IOUtils.getFilenameSuffix(f1.getAbsolutePath());
        String ext2 = IOUtils.getFilenameSuffix(f2.getAbsolutePath());
        if (ext1.endsWith(".sid") && !ext2.endsWith(".sid")) {
            return 1;
        }
        if (!ext1.endsWith(".sid") && ext2.endsWith(".sid")) {
            return -1;
        }
        return f1.compareTo((File)f2);
    };
    private static final String NUVIE_PLAYER_PRG = "/libsidplay/roms/nuvieplayer-v1.0.prg";
    private static byte[] NUVIE_PLAYER;
    private static final Logger LOGGER;
    public static final String MACOSX = "__MACOSX";
    private static final UUIDFileFilter UUID_FILE_FILTER;
    private static final TuneFileFilter TUNE_FILE_FILTER;
    private static final DiskFileFilter DISK_FILE_FILTER;
    private static final TapeFileFilter TAPE_FILE_FILTER;
    private static final CartFileFilter CART_FILE_FILTER;
    public static final BiPredicate<File, File> LEXICALLY_FIRST_MEDIA;
    public static final BiPredicate<File, File> NO_MEDIA;
    private static final String LOAD_8_1_RUN = "LOAD\"%s\",8,1\rRUN\r";
    private static final String LOAD_RUN = "LOAD\rRUN\r";
    private Player player;
    private static Thread deleteOutdatedTempDirectoriesHook;

    public Convenience(Player player) {
        this.player = player;
        try {
            if (deleteOutdatedTempDirectoriesHook == null) {
                deleteOutdatedTempDirectoriesHook = new Thread(this::deleteOutdatedTempDirectories);
                Runtime.getRuntime().addShutdownHook(deleteOutdatedTempDirectoriesHook);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public ConvenienceResult autostart(File file, BiPredicate<File, File> isMediaToAttach, String dirEntry) throws IOException, SidTuneError {
        return this.autostart(file, isMediaToAttach, dirEntry, false);
    }

    public ConvenienceResult autostart(File file, BiPredicate<File, File> isMediaToAttach, String dirEntry, boolean deepScan) throws IOException, SidTuneError {
        ConvenienceResult result = new ConvenienceResult();
        if (!this.player.getC64().getCartridge().isCreatingSamples()) {
            this.player.getC64().ejectCartridge();
        }
        File tmpDir = new File(this.player.getConfig().getSidplay2Section().getTmpDir(), UUID.randomUUID().toString());
        tmpDir.mkdirs();
        boolean isCartridge = CART_FILE_FILTER.accept(file);
        TFile tFile = new TFile(file);
        File toAttach = null;
        if (tFile.exists()) {
            if (tFile.isArchive()) {
                TFile.cp_rp((File)tFile, (File)tmpDir, (TArchiveDetector)TArchiveDetector.ALL);
                toAttach = this.getToAttach(result, tmpDir, (File)tFile, isMediaToAttach, null, !isCartridge);
            } else if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".gz")) {
                File dst = new File(tmpDir, IOUtils.getFilenameWithoutSuffix(file.getName()));
                try (GZIPInputStream is = new GZIPInputStream(ZipFileUtils.newFileInputStream(file));){
                    TFile.cp((InputStream)is, (File)dst);
                }
                toAttach = this.getToAttach(result, tmpDir, tmpDir, isMediaToAttach, null, !isCartridge);
            } else if (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".7z")) {
                Extract7ZipUtil extract7Zip = new Extract7ZipUtil((File)tFile, tmpDir);
                extract7Zip.extract();
                toAttach = this.getToAttach(result, tmpDir, tmpDir, isMediaToAttach, null, !isCartridge);
            } else if (tFile.isEntry()) {
                File zipEntry = new File(tmpDir, tFile.getName());
                TFile.cp_rp((File)tFile, (File)zipEntry, (TArchiveDetector)TArchiveDetector.ALL);
                this.getToAttach(result, tmpDir, zipEntry.getParentFile(), NO_MEDIA, null, !isCartridge);
                toAttach = zipEntry;
            } else if (this.isSupportedMedia(file)) {
                if (deepScan) {
                    this.getToAttach(result, file.getParentFile(), file.getParentFile(), NO_MEDIA, null, !isCartridge);
                }
                toAttach = file;
            }
        }
        if (toAttach != null) {
            if (TUNE_FILE_FILTER.accept(toAttach)) {
                this.player.play(SidTune.load(toAttach));
                result.setSuccess(true);
                return result;
            }
            if (DISK_FILE_FILTER.accept(toAttach)) {
                this.player.insertDisk(toAttach);
                this.player.resetC64(String.format(LOAD_8_1_RUN, dirEntry != null ? DirEntry.toFilename(dirEntry) : "*"));
                result.setSuccess(true);
                return result;
            }
            if (TAPE_FILE_FILTER.accept(toAttach)) {
                this.player.insertTape(toAttach);
                this.player.resetC64(LOAD_RUN);
                result.setSuccess(true);
                return result;
            }
            if (toAttach.getName().toLowerCase(Locale.ENGLISH).endsWith(".reu")) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(NUVIE_PLAYER);){
                    this.player.insertCartridge(CartridgeType.REU, toAttach);
                    this.player.play(SidTune.load("nuvieplayer-v1.0.prg", is));
                }
                result.setAttatchedCartridge(toAttach);
                result.setAttachedCartridgeType(CartridgeType.REU);
                result.setSuccess(true);
                return result;
            }
            if (CART_FILE_FILTER.accept(toAttach)) {
                this.player.insertCartridge(CartridgeType.CRT, toAttach);
                this.player.resetC64(null);
                result.setAttatchedCartridge(toAttach);
                result.setAttachedCartridgeType(CartridgeType.CRT);
                result.setSuccess(true);
                return result;
            }
        }
        return result;
    }

    private File getToAttach(ConvenienceResult result, File dir, File file, BiPredicate<File, File> mediaTester, File toAttach, boolean canAttachCartridge) {
        File[] listFiles = file.listFiles();
        if (listFiles == null) {
            return toAttach;
        }
        List<File> asList = Arrays.asList(listFiles);
        asList.sort(TOP_LEVEL_FIRST_COMPARATOR);
        for (File member : asList) {
            File toAttachChild;
            File memberFile = new File(dir, member.getName());
            if (memberFile.isFile() && this.isSupportedMedia(memberFile)) {
                if (canAttachCartridge && !this.player.getC64().isCartridge() && memberFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".reu")) {
                    try {
                        this.player.insertCartridge(CartridgeType.REU, memberFile);
                        result.setAttatchedCartridge(memberFile);
                        result.setAttachedCartridgeType(CartridgeType.REU);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (canAttachCartridge && !this.player.getC64().isCartridge() && memberFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".crt")) {
                    try {
                        this.player.insertCartridge(CartridgeType.CRT, memberFile);
                        result.setAttatchedCartridge(memberFile);
                        result.setAttachedCartridgeType(CartridgeType.CRT);
                        toAttach = memberFile;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!mediaTester.test(memberFile, toAttach)) continue;
                toAttach = memberFile;
                continue;
            }
            if (!memberFile.isDirectory() || memberFile.getName().equals(MACOSX) || (toAttachChild = this.getToAttach(result, memberFile, (File)new TFile(memberFile), mediaTester, toAttach, canAttachCartridge)) == null) continue;
            toAttach = toAttachChild;
        }
        return toAttach;
    }

    public boolean isSupportedMedia(File file) {
        return CART_FILE_FILTER.accept(file) || TUNE_FILE_FILTER.accept(file) || DISK_FILE_FILTER.accept(file) || TAPE_FILE_FILTER.accept(file);
    }

    private void deleteOutdatedTempDirectories() {
        Arrays.asList(Optional.ofNullable(this.player.getConfig().getSidplay2Section().getTmpDir().listFiles(UUID_FILE_FILTER)).orElse(new File[0])).stream().filter(File::isDirectory).forEach(dir -> {
            try {
                LOGGER.fine(String.format("Convenience: Delete temp. directory: %s", dir));
                IOUtils.deleteDirectory(dir);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        });
    }

    static {
        try (DataInputStream is = new DataInputStream(MenuBar.class.getResourceAsStream(NUVIE_PLAYER_PRG));){
            URL us2 = JSidPlay2Main.class.getResource(NUVIE_PLAYER_PRG);
            NUVIE_PLAYER = new byte[us2.openConnection().getContentLength()];
            is.readFully(NUVIE_PLAYER);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        LOGGER = Logger.getLogger(Convenience.class.getName());
        UUID_FILE_FILTER = new UUIDFileFilter();
        TUNE_FILE_FILTER = new TuneFileFilter();
        DISK_FILE_FILTER = new DiskFileFilter();
        TAPE_FILE_FILTER = new TapeFileFilter();
        CART_FILE_FILTER = new CartFileFilter();
        LEXICALLY_FIRST_MEDIA = (file, toAttach) -> toAttach == null || !TUNE_FILE_FILTER.accept((File)file) && file.getName().compareTo(toAttach.getName()) < 0;
        NO_MEDIA = (f1, f2) -> false;
    }
}

