/*
 * Decompiled with CFR 0.152.
 */
package ui.common.download;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import net.java.truevfs.access.TFile;
import ui.common.download.IDownloadListener;
import ui.common.download.RBCWrapper;
import ui.common.download.RBCWrapperDelegate;
import ui.common.util.InternetUtil;
import ui.entities.config.Configuration;
import ui.entities.config.SidPlay2Section;

public class DownloadThread
extends Thread
implements RBCWrapperDelegate {
    private static final Logger LOG = Logger.getLogger(DownloadThread.class.getName());
    private static final String ILLEGAL_FILENAME_CHARS = "[?:]";
    private static final String REPLACEMENT_ILLEGAL_CHAR = "_";
    public static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MAX_TRY_COUNT = 3;
    private final Configuration config;
    private final URL url;
    private final IDownloadListener listener;
    private boolean handleCrcAndSplits;

    public DownloadThread(Configuration cfg, IDownloadListener listener, URL url, boolean handleCrcAndSplits) {
        this.config = cfg;
        this.url = url;
        this.listener = listener;
        this.handleCrcAndSplits = handleCrcAndSplits;
    }

    @Override
    public void run() {
        if (this.handleCrcAndSplits) {
            try {
                File availableFile = this.createLocalFile(this.url);
                if (availableFile.exists() && this.checkCrcOfAvailableFile(availableFile)) {
                    System.out.println("CRC32 check OK for download: " + this.url);
                    this.listener.downloadStop(availableFile);
                    return;
                }
                System.err.println("Online file contents has changed, re-download!");
            }
            catch (IOException availableFile) {
                // empty catch block
            }
        }
        File downloadedFile = null;
        try {
            boolean isSplittedInChunks;
            boolean bl = isSplittedInChunks = this.handleCrcAndSplits && this.isSplittedInChunks();
            downloadedFile = isSplittedInChunks ? this.downloadAndMergeChunks() : this.download(this.url, true, true);
        }
        catch (IOException | URISyntaxException e) {
            LOG.fine(e.getMessage());
            this.listener.downloadStop(null);
            return;
        }
        try {
            if (this.handleCrcAndSplits) {
                if (this.checkCrcOfAvailableFile(downloadedFile)) {
                    System.out.println("CRC32 check OK for download: " + this.url);
                } else {
                    System.err.println("CRC32 check failed!");
                    downloadedFile = null;
                }
            }
        }
        finally {
            this.listener.downloadStop(downloadedFile);
        }
    }

    private boolean checkCrcOfAvailableFile(File file) {
        try {
            File crcFile = this.download(this.getCrcUrl(), false, false);
            return this.checkCrc(crcFile, file);
        }
        catch (IOException | URISyntaxException e) {
            return true;
        }
    }

    private boolean isSplittedInChunks() throws MalformedURLException, URISyntaxException {
        return this.checkExistingURL(this.getURL(1));
    }

    private boolean hasNextPart(int part) throws MalformedURLException, URISyntaxException {
        return this.checkExistingURL(this.getURL(part));
    }

    private URL getCrcUrl() throws MalformedURLException, URISyntaxException {
        return new URI(this.getURLUsingExt(".crc")).toURL();
    }

    private File downloadAndMergeChunks() throws IOException, MalformedURLException, URISyntaxException {
        ArrayList<File> chunks = new ArrayList<File>();
        int part = 1;
        do {
            File chunk = this.download(this.getURL(part), true, true);
            chunk.deleteOnExit();
            chunks.add(chunk);
        } while (this.hasNextPart(++part));
        File downloadedFile = this.mergeChunks(chunks);
        return downloadedFile;
    }

    private URL getURL(int part) throws MalformedURLException, URISyntaxException {
        return new URI(this.getURLUsingExt("." + String.format("%03d", part))).toURL();
    }

    private boolean checkExistingURL(URL currentURL) {
        SidPlay2Section sidplay2Section = this.config.getSidplay2Section();
        try {
            URLConnection connection = InternetUtil.openConnection(currentURL, sidplay2Section);
            return connection.getContentLength() >= 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File download(URL currentURL, boolean retry, boolean useAlreadyAvailableFile) throws IOException {
        SidPlay2Section sidplay2Section = this.config.getSidplay2Section();
        String decoded = URLDecoder.decode(currentURL.toString(), StandardCharsets.UTF_8.name());
        int tries = 0;
        do {
            ++tries;
            try (FileOutputStream fos = null;){
                URLConnection connection = InternetUtil.openConnection(currentURL, sidplay2Section);
                currentURL = connection.getURL();
                long contentLength = connection.getContentLengthLong();
                File file = this.createLocalFile(currentURL);
                if (useAlreadyAvailableFile && this.isAlreadyAvailableFile(contentLength, file)) {
                    File file2 = file;
                    return file2;
                }
                RBCWrapper rbc = new RBCWrapper(Channels.newChannel(connection.getInputStream()), contentLength, this);
                file = this.createLocalFile(currentURL);
                fos = new FileOutputStream(file);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                if (this.isAlreadyAvailableFile(contentLength, file)) {
                    File file3 = file;
                    return file3;
                }
                file.delete();
            }
        } while (tries != 3);
        throw new IOException(String.format("Download error for %s, i have tried %d times! ", decoded, 3));
    }

    private boolean isAlreadyAvailableFile(long contentLength, File availableFile) {
        return availableFile.exists() && availableFile.isFile() && availableFile.canRead() && availableFile.length() == contentLength;
    }

    private File createLocalFile(URL currentURL) throws IOException {
        String decoded = URLDecoder.decode(currentURL.getFile(), StandardCharsets.UTF_8.name());
        String name = new File(decoded).getName();
        return new File(this.config.getSidplay2Section().getTmpDir(), name.replaceAll(ILLEGAL_FILENAME_CHARS, REPLACEMENT_ILLEGAL_CHAR));
    }

    private File mergeChunks(List<File> chunks) throws IOException {
        File mergedFile = null;
        for (File chunk : chunks) {
            if (mergedFile == null) {
                mergedFile = chunk;
                continue;
            }
            mergedFile = this.merge(mergedFile, chunk);
        }
        File resultFile = this.createLocalFile(this.url);
        TFile.cp((File)mergedFile, (File)resultFile);
        return resultFile;
    }

    private File merge(File resultFile, File chunk) throws IOException {
        File tmp = File.createTempFile("jsidplay2", "tmp");
        tmp.deleteOnExit();
        try (BufferedInputStream is = new BufferedInputStream(new SequenceInputStream(new FileInputStream(resultFile), new FileInputStream(chunk)));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmp));){
            int bytesRead;
            byte[] buffer = new byte[0x100000];
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        return tmp;
    }

    private boolean checkCrc(File crcFile, File download) throws IOException {
        Properties properties = new Properties();
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(crcFile));){
            properties.load(stream);
        }
        try {
            String crc = properties.getProperty("crc32");
            long fileLength = Integer.valueOf(properties.getProperty("size")).intValue();
            String filename = properties.getProperty("filename");
            if (!download.getName().equals(filename)) {
                return true;
            }
            String calculateCRC32 = DownloadThread.calculateCRC32(download);
            System.out.println("Check name: " + download.getName() + " with " + filename);
            System.out.println("Check size: " + download.length() + " with " + fileLength);
            System.out.println("Check  crc: " + calculateCRC32 + " with " + crc);
            return download.length() == fileLength && calculateCRC32.equals(crc);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String calculateCRC32(File file) throws IOException {
        try (CheckedInputStream cis = new CheckedInputStream(new FileInputStream(file), new CRC32());){
            byte[] buffer = new byte[0x100000];
            while (cis.read(buffer) >= 0) {
            }
            String string = String.format("%8X", cis.getChecksum().getValue()).replace(' ', '0');
            return string;
        }
    }

    private String getURLUsingExt(String ext) {
        String path = this.url.toExternalForm();
        int extIdx = path.lastIndexOf(46);
        if (extIdx != -1) {
            return path.substring(0, extIdx) + ext;
        }
        throw new RuntimeException("filename must have a file extension");
    }

    @Override
    public void rbcProgressCallback(double progress) {
        this.listener.downloadStep((int)progress);
    }
}

