/*
 * Decompiled with CFR 0.152.
 */
package ui.common.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import server.restful.common.IServletSystemProperties;
import ui.entities.config.SidPlay2Section;

public class InternetUtil {
    public static URLConnection openConnection(URL currentURL, SidPlay2Section sidplay2Section) throws IOException {
        URLConnection openConnection;
        block8: while ((openConnection = currentURL.openConnection(InternetUtil.getProxy(sidplay2Section))) instanceof HttpURLConnection) {
            HttpURLConnection connection = (HttpURLConnection)openConnection;
            connection.setConnectTimeout(IServletSystemProperties.JSIDPlay2Server.CONNECTION_TIMEOUT);
            connection.setInstanceFollowRedirects(false);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 301: 
                case 302: 
                case 303: {
                    String location = connection.getHeaderField("Location");
                    if (location != null) {
                        try {
                            currentURL = new URI(location).toURL();
                            continue block8;
                        }
                        catch (MalformedURLException | URISyntaxException e) {
                            try {
                                URI uri = new URI(currentURL.getProtocol(), currentURL.getUserInfo(), currentURL.getHost(), currentURL.getPort(), location, currentURL.getQuery(), currentURL.getRef());
                                currentURL = new URI(uri.toASCIIString()).toURL();
                                continue block8;
                            }
                            catch (URISyntaxException e2) {
                                throw new IOException("Redirection failed for location: " + location);
                            }
                        }
                    }
                }
                case 200: {
                    break block8;
                }
                default: {
                    throw new IOException("Unexpected response: " + responseCode);
                }
            }
        }
        return openConnection;
    }

    private static Proxy getProxy(SidPlay2Section sidplay2Section) {
        if (sidplay2Section.isProxyEnable()) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(sidplay2Section.getProxyHostname(), sidplay2Section.getProxyPort()));
        }
        return Proxy.NO_PROXY;
    }

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

