/*
 * Decompiled with CFR 0.152.
 */
package ui.directory;

import java.io.InputStream;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.text.Font;
import javafx.util.Callback;
import ui.directory.DirectoryItem;

public class DirectoryCellFactory
implements Callback<TableColumn<DirectoryItem, String>, TableCell<DirectoryItem, String>> {
    protected static Font c64Font;

    public TableCell<DirectoryItem, String> call(TableColumn<DirectoryItem, String> column) {
        TableCell<DirectoryItem, String> cell = new TableCell<DirectoryItem, String>(){

            public void updateItem(String value, boolean empty) {
                super.updateItem((Object)value, empty);
                if (!empty) {
                    this.setText(value);
                } else {
                    this.setText("");
                }
                this.setFont(c64Font);
            }
        };
        return cell;
    }

    static {
        try {
            InputStream fontStream = DirectoryCellFactory.class.getResourceAsStream("/libsidutils/C64_Elite_Mono_v1.0-STYLE.ttf");
            c64Font = Font.loadFont((InputStream)fontStream, (double)10.0);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

