/*
 * Decompiled with CFR 0.152.
 */
package ui.favorites;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.DirectoryChooser;
import javafx.util.Callback;
import javax.persistence.metamodel.SingularAttribute;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.psid64.Psid64;
import net.java.truevfs.access.TFile;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.common.fileextension.FavoritesExtensions;
import ui.common.filefilter.TuneFileFilter;
import ui.entities.collection.HVSCEntry;
import ui.entities.collection.HVSCEntry_;
import ui.entities.config.FavoriteColumn;
import ui.entities.config.FavoritesSection;
import ui.entities.config.SidPlay2Section;
import ui.favorites.Favorites;
import ui.favorites.FavoritesCellFactory;
import ui.musiccollection.SearchCriteria;
import ui.stilview.STILView;

public class FavoritesTab
extends C64VBox
implements UIPart {
    @FXML
    private TextField filterField;
    @FXML
    private TableView<HVSCEntry> favoritesTable;
    @FXML
    private Menu addColumnMenu;
    @FXML
    private Menu moveToTab;
    @FXML
    private Menu copyToTab;
    @FXML
    private MenuItem showStil;
    @FXML
    private MenuItem removeColumn;
    @FXML
    private Button moveUp;
    @FXML
    private Button moveDown;
    @FXML
    private ContextMenu contextMenu;
    private ObservableList<HVSCEntry> filteredFavorites;
    private FileFilter tuneFilter = new TuneFileFilter();
    private FavoritesSection favoritesSection;
    private ObjectProperty<HVSCEntry> currentlyPlayedHVSCEntryProperty;
    private Favorites favorites;
    private int selectedColumn;

    public FavoritesTab() {
    }

    public FavoritesTab(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.filteredFavorites = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(this.filteredFavorites);
        sortedList.comparatorProperty().bind((ObservableValue)this.favoritesTable.comparatorProperty());
        this.favoritesTable.setItems((ObservableList)sortedList);
        this.favoritesTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.favoritesTable.getColumns().addListener(change -> {
            while (change.next()) {
                if (!change.wasReplaced()) continue;
                this.moveColumn();
            }
        });
        this.favoritesTable.getSelectionModel().selectedIndexProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && newValue.intValue() != -1) {
                this.favoritesSection.setSelectedRowFrom(newValue.intValue());
                this.favoritesSection.setSelectedRowTo(newValue.intValue());
            }
            this.moveUp.setDisable(newValue == null || newValue.intValue() == 0 || this.favoritesTable.getSortOrder().size() > 0);
            this.moveDown.setDisable(newValue == null || newValue.intValue() == this.favoritesSection.getFavorites().size() - 1 || this.favoritesTable.getSortOrder().size() > 0);
        });
        this.favoritesTable.setOnMousePressed(event -> {
            HVSCEntry hvscEntry;
            if (event.isPrimaryButtonDown() && event.getClickCount() > 1 && this.getHVSCFile(hvscEntry = (HVSCEntry)this.favoritesTable.getSelectionModel().getSelectedItem()) != null) {
                this.playTune(hvscEntry);
                this.favoritesTable.scrollTo((Object)hvscEntry);
            }
        });
        this.favoritesTable.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                HVSCEntry hvscEntry = (HVSCEntry)this.favoritesTable.getSelectionModel().getSelectedItem();
                if (this.getHVSCFile(hvscEntry) != null) {
                    this.playTune(hvscEntry);
                }
            } else if (event.getCode() == KeyCode.DELETE) {
                this.removeSelectedFavorites();
            }
        });
        this.filterField.setOnKeyReleased(event -> this.filter(this.filterField.getText()));
        SearchCriteria.getSearchableAttributes().stream().filter((? super T searchCriteria) -> searchCriteria.getAttribute().getDeclaringType().getJavaType().getSimpleName().startsWith(HVSCEntry.class.getSimpleName())).forEach(searchCriteria -> this.addAddColumnHeaderMenuItem(this.addColumnMenu, searchCriteria.getAttribute()));
        this.contextMenu.setOnShown(event -> {
            HVSCEntry hvscEntry = (HVSCEntry)this.favoritesTable.getSelectionModel().getSelectedItem();
            this.showStil.setDisable(hvscEntry == null || this.util.getPlayer().getStilEntry(hvscEntry.getPath()) == null);
            List<Tab> tabs = this.favorites.getOtherFavoriteTabs();
            this.moveToTab.getItems().clear();
            this.copyToTab.getItems().clear();
            for (Tab tab : tabs) {
                String name = tab.getText();
                MenuItem moveToTabItem = new MenuItem(name);
                moveToTabItem.setOnAction(event2 -> {
                    ObservableList selectedItems = this.favoritesTable.getSelectionModel().getSelectedItems();
                    this.copyToTab((List<HVSCEntry>)selectedItems, (FavoritesTab)tab.getContent());
                    this.removeFavorites((ObservableList<HVSCEntry>)selectedItems);
                });
                this.moveToTab.getItems().add((Object)moveToTabItem);
                MenuItem copyToTabItem = new MenuItem(name);
                copyToTabItem.setOnAction(event2 -> {
                    ObservableList selectedItems = this.favoritesTable.getSelectionModel().getSelectedItems();
                    this.copyToTab((List<HVSCEntry>)selectedItems, (FavoritesTab)tab.getContent());
                });
                this.copyToTab.getItems().add((Object)copyToTabItem);
            }
            this.moveToTab.setDisable(this.moveToTab.getItems().isEmpty());
            this.copyToTab.setDisable(this.copyToTab.getItems().isEmpty());
            this.removeColumn.setDisable(true);
            Iterator iterator = this.favoritesTable.getSelectionModel().getSelectedCells().iterator();
            if (iterator.hasNext()) {
                TablePosition tablePosition = (TablePosition)iterator.next();
                this.selectedColumn = tablePosition.getColumn();
                this.removeColumn.setDisable(this.favoritesTable.getSelectionModel().getSelectedCells().size() != 1 || tablePosition.getColumn() <= 0);
            }
            if (this.selectedColumn > 0 && this.selectedColumn < this.favoritesTable.getColumns().size()) {
                TableColumn tableColumn = (TableColumn)this.favoritesTable.getColumns().get(this.selectedColumn);
                this.removeColumn.setText(String.format(this.util.getBundle().getString("REMOVE_COLUMN"), tableColumn.getText()));
            }
        });
        this.currentlyPlayedHVSCEntryProperty = new SimpleObjectProperty();
        for (TableColumn column : this.favoritesTable.getColumns()) {
            FavoritesCellFactory cellFactory = (FavoritesCellFactory)column.getCellFactory();
            cellFactory.setPlayer(this.util.getPlayer());
            cellFactory.setCurrentlyPlayedHVSCEntryProperty(this.currentlyPlayedHVSCEntryProperty);
        }
    }

    @FXML
    private void doMoveUp() {
        int from = this.favoritesTable.getSelectionModel().getSelectedIndex();
        if (from == -1) {
            return;
        }
        this.moveRow(from, from - 1);
    }

    @FXML
    private void doMoveDown() {
        int from = this.favoritesTable.getSelectionModel().getSelectedIndex();
        if (from == -1) {
            return;
        }
        this.moveRow(from, from + 1);
    }

    @FXML
    private void removeColumn() {
        if (this.selectedColumn < 0) {
            return;
        }
        TableColumn tableColumn = (TableColumn)this.favoritesTable.getColumns().get(this.selectedColumn);
        FavoriteColumn favoriteColumn = (FavoriteColumn)tableColumn.getUserData();
        this.favoritesTable.getColumns().remove((Object)tableColumn);
        this.favoritesSection.getColumns().remove(favoriteColumn);
    }

    @FXML
    private void exportToDir() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(sidplay2Section.getLastDirectory());
        File directory = fileDialog.showDialog(this.favoritesTable.getScene().getWindow());
        if (directory != null) {
            sidplay2Section.setLastDirectory(directory);
            for (HVSCEntry hvscEntry : this.favoritesTable.getSelectionModel().getSelectedItems()) {
                File file = this.getHVSCFile(hvscEntry);
                this.copyToUniqueName(file, directory, file.getName(), 1);
            }
        }
    }

    @FXML
    private void showStil() {
        HVSCEntry hvscEntry = (HVSCEntry)this.favoritesTable.getSelectionModel().getSelectedItem();
        if (hvscEntry == null) {
            return;
        }
        STILView stilInfo = new STILView(this.util.getPlayer());
        stilInfo.setEntry(this.util.getPlayer().getStilEntry(hvscEntry.getPath()));
        stilInfo.open();
    }

    @FXML
    private void convertToPsid64() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(sidPlay2Section.getLastDirectory());
        File directory = fileDialog.showDialog(this.favoritesTable.getScene().getWindow());
        if (directory != null) {
            sidPlay2Section.setLastDirectory(directory);
            ArrayList<File> files = new ArrayList<File>();
            for (HVSCEntry hvscEntry : this.favoritesTable.getSelectionModel().getSelectedItems()) {
                files.add(this.getHVSCFile(hvscEntry));
            }
            Psid64 c = new Psid64();
            c.setTmpDir(sidPlay2Section.getTmpDir());
            c.setVerbose(false);
            try {
                c.convertFiles(this.util.getPlayer(), files.toArray(new File[0]), directory, sidPlay2Section.getHvsc());
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    private File getHVSCFile(HVSCEntry hvscEntry) {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        return hvscEntry != null ? IOUtils.getFile(hvscEntry.getPath(), sidPlay2Section.getHvsc(), sidPlay2Section.getCgsc()) : null;
    }

    private void copyToUniqueName(File file, File directory, String name, int number) {
        File newFile;
        String newName = name;
        if (number > 1) {
            newName = IOUtils.getFilenameWithoutSuffix(name) + "_" + number + IOUtils.getFilenameSuffix(name);
        }
        if ((newFile = new File(directory, newName)).exists()) {
            this.copyToUniqueName(file, directory, name, ++number);
        } else {
            try {
                TFile.cp((File)file, (File)newFile);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.favoritesSection.getName();
    }

    public void setName(String name) {
        this.favoritesSection.setName(name);
    }

    public void addFavorites(List<File> files) {
        String result = "";
        for (File file : files) {
            File[] listFiles = file.listFiles();
            if (file.isDirectory() && listFiles != null) {
                this.addFavorites(Arrays.asList(listFiles));
                continue;
            }
            if (!this.tuneFilter.accept(file)) continue;
            result = String.join((CharSequence)"", result, this.addFavorite(file));
        }
        if (!result.isEmpty()) {
            this.openErrorDialog(result);
        }
    }

    public void restoreColumns(FavoritesSection favoritesSection) {
        this.favoritesSection = favoritesSection;
        this.filteredFavorites.addAll(favoritesSection.getFavorites());
        for (FavoriteColumn favoriteColumn : favoritesSection.getColumns()) {
            try {
                SingularAttribute<?, ?> attribute = this.getAttribute(favoriteColumn.getColumnProperty());
                this.addColumn(attribute, favoriteColumn);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        Iterator columnsIt = this.favoritesTable.getColumns().iterator();
        TableColumn pathColumn = (TableColumn)columnsIt.next();
        pathColumn.widthProperty().addListener((observable, oldValue, newValue) -> favoritesSection.setWidth(newValue.doubleValue()));
        double width = favoritesSection.getWidth();
        if (width != 0.0) {
            pathColumn.setPrefWidth(width);
        }
        for (FavoriteColumn favoriteColumn : favoritesSection.getColumns()) {
            TableColumn column = (TableColumn)columnsIt.next();
            width = favoriteColumn.getWidth();
            if (width == 0.0) continue;
            column.setPrefWidth(width);
        }
        ((ObservableList)favoritesSection.getFavorites()).addListener(change -> {
            while (change.next()) {
                if (change.wasPermutated() || change.wasUpdated()) continue;
                if (change.wasAdded()) {
                    this.filteredFavorites.addAll((Collection)change.getAddedSubList());
                    continue;
                }
                if (!change.wasRemoved()) continue;
                this.filteredFavorites.removeAll((Collection)change.getRemoved());
            }
        });
        Integer from = favoritesSection.getSelectedRowFrom();
        if (from != null && from != -1 && from < favoritesSection.getFavorites().size()) {
            this.favoritesTable.getSelectionModel().select(from.intValue());
            HVSCEntry hvscEntry = favoritesSection.getFavorites().get(from);
            this.favoritesTable.scrollTo((Object)hvscEntry);
        }
    }

    public void removeSelectedFavorites() {
        this.removeFavorites((ObservableList<HVSCEntry>)this.favoritesTable.getSelectionModel().getSelectedItems());
    }

    public void removeAllFavorites() {
        this.favoritesSection.getFavorites().clear();
        this.util.getConfig().getFavorites().remove(this.favoritesSection);
    }

    public void filter(String filterText) {
        this.filteredFavorites.clear();
        if (filterText.trim().length() == 0) {
            this.filteredFavorites.addAll(this.favoritesSection.getFavorites());
        } else {
            block2: for (HVSCEntry hvscEntry : this.favoritesSection.getFavorites()) {
                for (TableColumn tableColumn : this.favoritesTable.getColumns()) {
                    FavoriteColumn favoriteColumn = (FavoriteColumn)tableColumn.getUserData();
                    String name = favoriteColumn != null ? favoriteColumn.getColumnProperty() : HVSCEntry_.path.getName();
                    try {
                        Object value = ((Method)this.getAttribute(name).getJavaMember()).invoke((Object)hvscEntry, new Object[0]);
                        String text = value != null ? value.toString() : "";
                        if (!FavoritesTab.containsIgnoreCase(text, filterText)) continue;
                        this.filteredFavorites.add((Object)hvscEntry);
                        continue block2;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        int length = searchStr.length();
        if (length == 0) {
            return true;
        }
        for (int i = str.length() - length; i >= 0; --i) {
            if (!str.regionMatches(true, i, searchStr, 0, length)) continue;
            return true;
        }
        return false;
    }

    public void selectAllFavorites() {
        this.favoritesTable.getSelectionModel().selectAll();
    }

    public void clearSelection() {
        this.favoritesTable.getSelectionModel().clearSelection();
    }

    /*
     * Unable to fully structure code
     */
    public void loadFavorites(File favoritesFile) throws IOException {
        result = "";
        sidPlay2Section = this.util.getConfig().getSidplay2Section();
        if (favoritesFile.getName().endsWith(".json")) {
            try {
                playListEntries = (PlayListEntry[])new ObjectMapper().readValue(favoritesFile, PlayListEntry[].class);
                if (playListEntries == null) ** GOTO lbl31
                for (PlayListEntry playListEntry : playListEntries) {
                    line = playListEntry.filename;
                    if (line.startsWith("/C64Music")) {
                        line = line.substring("/C64Music".length() + 1);
                    }
                    if ((file = IOUtils.getFile(line, sidPlay2Section.getHvsc(), sidPlay2Section.getCgsc())) == null) continue;
                    result = String.join((CharSequence)"", new CharSequence[]{result, this.addFavorite(file)});
                }
            }
            catch (IOException e) {
                result = e.getMessage();
            }
        } else {
            favoritesFile = this.addFileExtension(favoritesFile);
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(favoritesFile), "ISO-8859-1"));
            try {
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("<HVSC>") || line.startsWith("<CGSC>")) {
                        line = line.substring(7);
                    }
                    if ((file = IOUtils.getFile(line, sidPlay2Section.getHvsc(), sidPlay2Section.getCgsc())) == null) continue;
                    result = String.join((CharSequence)"", new CharSequence[]{result, this.addFavorite(file)});
                }
            }
            finally {
                r.close();
            }
        }
        if (!result.isEmpty()) {
            this.openErrorDialog(result);
        }
    }

    public void saveFavorites(File favoritesFile) throws IOException {
        favoritesFile = this.addFileExtension(favoritesFile);
        try (PrintStream p = new PrintStream(favoritesFile);){
            for (HVSCEntry hvscEntry : this.favoritesTable.getItems()) {
                p.println(new TFile(hvscEntry.getPath()).getPath());
            }
        }
    }

    public void playNext(boolean repeated) {
        Iterator<HVSCEntry> it = this.favoritesSection.getFavorites().iterator();
        while (it.hasNext()) {
            HVSCEntry hvscEntry = it.next();
            if (hvscEntry != this.currentlyPlayedHVSCEntryProperty.get()) continue;
            if (it.hasNext()) {
                this.playTune(it.next());
                continue;
            }
            if (!repeated) continue;
            this.favoritesSection.getFavorites().stream().findFirst().ifPresent(this::playTune);
        }
    }

    public void playNextRandom() {
        if (this.favoritesSection.getFavorites().isEmpty()) {
            return;
        }
        HVSCEntry hvscEntry = this.favoritesSection.getFavorites().get(Math.abs(new Random().nextInt(Integer.MAX_VALUE)) % this.favoritesSection.getFavorites().size());
        this.playTune(hvscEntry);
    }

    public void removeFavorites(ObservableList<HVSCEntry> selectedItems) {
        this.favoritesSection.getFavorites().removeAll((Collection<?>)selectedItems);
        this.filter(this.filterField.getText());
    }

    public void addColumn(SingularAttribute<?, ?> attribute, FavoriteColumn favoriteColumn) {
        String text = this.util.getBundle().getString(attribute.getDeclaringType().getJavaType().getSimpleName() + "." + attribute.getName());
        TableColumn tableColumn = new TableColumn();
        tableColumn.setUserData((Object)favoriteColumn);
        tableColumn.setText(text);
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory(attribute.getName()));
        FavoritesCellFactory cellFactory = new FavoritesCellFactory();
        cellFactory.setPlayer(this.util.getPlayer());
        cellFactory.setCurrentlyPlayedHVSCEntryProperty(this.currentlyPlayedHVSCEntryProperty);
        tableColumn.setCellFactory((Callback)cellFactory);
        tableColumn.widthProperty().addListener((observable, oldValue, newValue) -> favoriteColumn.setWidth(newValue.doubleValue()));
        this.favoritesTable.getColumns().add((Object)tableColumn);
    }

    public void moveColumn() {
        ArrayList<FavoriteColumn> newOrderList = new ArrayList<FavoriteColumn>();
        for (TableColumn tableColumn : this.favoritesTable.getColumns()) {
            FavoriteColumn favoriteColumn = (FavoriteColumn)tableColumn.getUserData();
            if (favoriteColumn == null) continue;
            newOrderList.add(favoriteColumn);
        }
        this.favoritesSection.getColumns().clear();
        this.favoritesSection.getColumns().addAll(newOrderList);
    }

    public void moveRow(int from, int to) {
        Collections.swap(this.favoritesSection.getFavorites(), from, to);
        this.filter(this.filterField.getText());
        this.favoritesTable.getSelectionModel().select(to);
    }

    public void copyToTab(List<HVSCEntry> toCopy, FavoritesTab tab) {
        String result = "";
        for (HVSCEntry hvscEntry : toCopy) {
            result = String.join((CharSequence)"", result, tab.addFavorite(this.getHVSCFile(hvscEntry)));
        }
        if (!result.isEmpty()) {
            this.openErrorDialog(result);
        }
    }

    public void deselectCurrentlyPlayedHVSCEntry() {
        this.currentlyPlayedHVSCEntryProperty.set(null);
    }

    public void playTune(HVSCEntry hvscEntry) {
        this.favorites.setCurrentlyPlayedFavorites(this);
        this.util.setPlayingTab((Node)this, this.currentlyPlayedHVSCEntryProperty);
        try {
            if (!this.util.getPlayer().getC64().getCartridge().isCreatingSamples()) {
                this.util.getPlayer().getC64().ejectCartridge();
            }
            this.util.getPlayer().play(SidTune.load(this.getHVSCFile(hvscEntry)));
            this.currentlyPlayedHVSCEntryProperty.set((Object)hvscEntry);
            this.favoritesTable.scrollTo((Object)hvscEntry);
            int selectedIndex = this.filteredFavorites.indexOf((Object)hvscEntry);
            this.favoritesSection.setSelectedRowFrom(selectedIndex);
            this.favoritesSection.setSelectedRowTo(selectedIndex);
        }
        catch (IOException | SidTuneError e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
        }
    }

    public void setFavorites(Favorites favorites) {
        this.favorites = favorites;
    }

    private File addFileExtension(File favoritesFile) {
        String extension = FavoritesExtensions.EXTENSIONS.iterator().next();
        if (extension.startsWith("*")) {
            extension = extension.substring(1);
        }
        if (!favoritesFile.getName().endsWith(extension)) {
            favoritesFile = new File(favoritesFile.getParentFile(), favoritesFile.getName() + extension);
        }
        return favoritesFile;
    }

    private String addFavorite(File file) {
        String result = "";
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        try {
            SidTune tune = SidTune.load(file);
            String collectionName = IOUtils.getCollectionName(sidPlay2Section.getHvsc(), file);
            HVSCEntry entry = new HVSCEntry(() -> this.util.getPlayer().getSidDatabaseInfo(db -> db.getTuneLength(tune), 0.0), file.getName(), collectionName, file.length(), file.lastModified(), tune, tune.identify().stream().collect(Collectors.joining(",")));
            this.favoritesSection.getFavorites().add(entry);
        }
        catch (IOException | SidTuneError e) {
            result = String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()) + "\n";
        }
        return result;
    }

    private SingularAttribute<?, ?> getAttribute(String columnProperty) throws IllegalAccessException {
        for (Field field : HVSCEntry_.class.getDeclaredFields()) {
            if (field.getName().equals(HVSCEntry_.id.getName()) || !SingularAttribute.class.isAssignableFrom(field.getType()) || !columnProperty.equals(field.getName())) continue;
            return (SingularAttribute)field.get(null);
        }
        return null;
    }

    private void addAddColumnHeaderMenuItem(Menu addColumnMenu, SingularAttribute<?, ?> attribute) {
        MenuItem menuItem = new MenuItem();
        String text = this.util.getBundle().getString(attribute.getDeclaringType().getJavaType().getSimpleName() + "." + attribute.getName());
        menuItem.setText(text);
        menuItem.setOnAction(event -> {
            FavoriteColumn favoriteColumn = new FavoriteColumn(attribute);
            this.favoritesSection.getColumns().add(favoriteColumn);
            this.addColumn(attribute, favoriteColumn);
        });
        addColumnMenu.getItems().add((Object)menuItem);
    }

    private void openErrorDialog(String msg) {
        Alert alert = new Alert(Alert.AlertType.ERROR, "", new ButtonType[0]);
        alert.setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        TextArea textArea = new TextArea(msg);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        alert.getDialogPane().setContent((Node)textArea);
        alert.showAndWait();
    }

    public static class PlayListEntry {
        public String filename;
        public String itemId;
        public int categoryId;
    }
}

