/*
 * Decompiled with CFR 0.152.
 */
package ui.gamebase;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import jsidplay2.Photos;
import libsidplay.sidtune.SidTuneError;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.common.UIPart;
import ui.common.download.DownloadThread;
import ui.common.download.IDownloadListener;
import ui.entities.gamebase.Games;

public class GameBasePage
extends C64VBox
implements UIPart {
    @FXML
    private TableView<Games> gamebaseTable;
    private Convenience convenience;
    private ImageView screenshot;
    private ImageView photo;
    private String fileToRun;
    private final BiPredicate<File, File> FILE_TO_RUN_DETECTOR = (file, toAttach) -> this.fileToRun.length() == 0 && Convenience.LEXICALLY_FIRST_MEDIA.test((File)file, (File)toAttach) || this.fileToRun.equals(file.getName());
    private ObservableList<Games> allGames;
    private ObservableList<Games> filteredGames;

    public GameBasePage() {
    }

    public GameBasePage(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.convenience = new Convenience(this.util.getPlayer());
        this.allGames = FXCollections.observableArrayList();
        this.filteredGames = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(this.filteredGames);
        sortedList.comparatorProperty().bind((ObservableValue)this.gamebaseTable.comparatorProperty());
        this.gamebaseTable.setItems((ObservableList)sortedList);
        this.gamebaseTable.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.autostart();
            }
        });
        this.gamebaseTable.setOnMousePressed(event -> {
            if (event.isPrimaryButtonDown() && event.getClickCount() > 1) {
                Games game = (Games)this.gamebaseTable.getSelectionModel().getSelectedItem();
                this.startGame(game);
            }
        });
        this.gamebaseTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                if (!newValue.getScreenshotFilename().isEmpty()) {
                    this.setScreenshot(new Image(this.util.getConfig().getOnlineSection().getGb64ScreenshotUrl() + newValue.getScreenshotFilename().replace('\\', '/')));
                } else {
                    this.setScreenshot(null);
                }
                if (!newValue.getMusicians().getPhotoFilename().isEmpty()) {
                    this.setPhoto(new Image(this.util.getConfig().getOnlineSection().getGb64PhotosUrl() + newValue.getMusicians().getPhotoFilename().replace('\\', '/')));
                } else {
                    this.setPhoto(new Image((InputStream)new ByteArrayInputStream(Photos.getPhoto((String)"???", (String)"???"))));
                }
            }
        });
    }

    @FXML
    private void autostart() {
        Games game = (Games)this.gamebaseTable.getSelectionModel().getSelectedItem();
        this.startGame(game);
    }

    private void setScreenshot(Image image) {
        if (this.screenshot == null) {
            this.screenshot = (ImageView)this.gamebaseTable.getScene().lookup("#gamebase_screenshot");
        }
        if (this.screenshot != null) {
            Platform.runLater(() -> this.screenshot.setImage(image));
        }
    }

    private void setPhoto(Image image) {
        if (this.photo == null) {
            this.photo = (ImageView)this.gamebaseTable.getScene().lookup("#gamebase_musician_photo");
        }
        if (this.photo != null) {
            Platform.runLater(() -> this.photo.setImage(image));
        }
    }

    protected void startGame(Games game) {
        if (game == null) {
            return;
        }
        if (game.getFilename().isEmpty()) {
            System.out.println("Game is not available on GameBase64: " + game.getName());
            return;
        }
        try {
            this.fileToRun = game.getFileToRun();
            new DownloadThread(this.util.getConfig(), new IDownloadListener(){

                @Override
                public void downloadStop(File downloadedFile) {
                    try {
                        if (downloadedFile != null && GameBasePage.this.convenience.autostart(downloadedFile, GameBasePage.this.FILE_TO_RUN_DETECTOR, null, true).isSuccess()) {
                            downloadedFile.deleteOnExit();
                            Platform.runLater(() -> GameBasePage.this.util.setPlayingTab((Node)GameBasePage.this, new ObjectProperty[0]));
                        }
                    }
                    catch (IOException | SidTuneError exception) {
                        // empty catch block
                    }
                }

                @Override
                public void downloadStep(int step) {
                    DoubleProperty progressProperty = GameBasePage.this.util.progressProperty(GameBasePage.this.gamebaseTable.getScene());
                    progressProperty.setValue((Number)Float.valueOf((float)step / 100.0f));
                }
            }, new URI(this.util.getConfig().getOnlineSection().getGb64GamesUrl() + game.getFilename().replace('\\', '/')).toURL(), false).start();
        }
        catch (IOException | URISyntaxException e) {
            System.err.println(e.getMessage());
        }
    }

    void setGames(List<Games> games) {
        this.allGames.setAll(games);
        this.filteredGames.setAll(this.allGames);
    }

    void filter(String filterText) {
        this.filteredGames.clear();
        if (filterText.trim().length() == 0) {
            this.filteredGames.addAll(this.allGames);
        } else {
            this.allGames.stream().filter((? super T game) -> game.getName().toLowerCase(Locale.ENGLISH).contains(filterText.toLowerCase(Locale.ENGLISH))).forEach(arg_0 -> this.filteredGames.add(arg_0));
        }
    }

    public TableView<Games> getGamebaseTable() {
        return this.gamebaseTable;
    }
}

