/*
 * Decompiled with CFR 0.152.
 */
package ui.menubar;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import libsidplay.C64;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.components.c1541.ExtendImagePolicy;
import libsidplay.components.c1541.FloppyType;
import libsidplay.components.cart.CartridgeType;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.IOUtils;
import sidplay.Player;
import sidplay.player.PlayList;
import sidplay.player.State;
import ui.JSidPlay2Main;
import ui.about.About;
import ui.audiosettings.AudioSettings;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.Toast;
import ui.common.UIPart;
import ui.common.fileextension.CartFileExtensions;
import ui.common.fileextension.DiskFileExtensions;
import ui.common.fileextension.TapeFileExtensions;
import ui.common.fileextension.TuneFileExtensions;
import ui.common.properties.BindingUtils;
import ui.common.util.DesktopUtil;
import ui.diskcollection.DiskCollectionType;
import ui.emulationsettings.EmulationSettings;
import ui.entities.config.C1541Section;
import ui.entities.config.Configuration;
import ui.entities.config.PrinterSection;
import ui.entities.config.SidPlay2Section;
import ui.entities.config.ViewEntity;
import ui.favorites.PlaybackType;
import ui.joysticksettings.JoystickSettings;
import ui.musiccollection.MusicCollectionType;
import ui.proxysettings.ProxySettings;
import ui.ultimate64.Ultimate64Window;
import ui.update.Update;
import ui.videoscreen.Video;
import ui.webview.WebViewType;
import ui.whatssidsettings.WhatsSidSettings;

public class MenuBar
extends C64VBox
implements UIPart {
    private static final String NUVIE_PLAYER_PRG = "/libsidplay/roms/nuvieplayer-v1.0.prg";
    private static byte[] NUVIE_PLAYER;
    private static final String EMPTY_D64 = "/libsidplay/components/c1541/empty.d64";
    private static byte[] EMPTY_DISK;
    private static final String ACTION_REPLAY_MKVI = "/libsidplay/components/cart/AR_60PAL.CRT";
    @FXML
    protected CheckMenuItem pauseContinue;
    @FXML
    protected CheckMenuItem playListStartsWithOne;
    @FXML
    protected CheckMenuItem turboTape;
    @FXML
    protected CheckMenuItem driveOn;
    @FXML
    protected CheckMenuItem driveSoundOn;
    @FXML
    protected CheckMenuItem parCable;
    @FXML
    protected CheckMenuItem installJiffyDos;
    @FXML
    protected CheckMenuItem expand2000;
    @FXML
    protected CheckMenuItem expand4000;
    @FXML
    protected CheckMenuItem expand6000;
    @FXML
    protected CheckMenuItem expand8000;
    @FXML
    protected CheckMenuItem expandA000;
    @FXML
    protected CheckMenuItem turnPrinterOn;
    @FXML
    protected RadioMenuItem fastForward;
    @FXML
    protected RadioMenuItem normalSpeed;
    @FXML
    protected MenuItem previousSong;
    @FXML
    protected MenuItem nextSong;
    @FXML
    protected MenuItem stop;
    @FXML
    protected MenuItem video;
    @FXML
    protected MenuItem oscilloscope;
    @FXML
    protected MenuItem favorites;
    @FXML
    protected MenuItem hvsc;
    @FXML
    protected MenuItem cgsc;
    @FXML
    protected MenuItem hvmec;
    @FXML
    protected MenuItem demos;
    @FXML
    protected MenuItem mags;
    @FXML
    protected MenuItem sidDump;
    @FXML
    protected MenuItem sidRegisters;
    @FXML
    protected MenuItem asm;
    @FXML
    protected MenuItem disassembler;
    @FXML
    protected MenuItem assembly64;
    @FXML
    protected MenuItem csdb;
    @FXML
    protected MenuItem remixKwedOrg;
    @FXML
    protected MenuItem lemon64;
    @FXML
    protected MenuItem forum64;
    @FXML
    protected MenuItem soasc;
    @FXML
    protected MenuItem codebase64;
    @FXML
    protected MenuItem gamebase;
    @FXML
    protected MenuItem jsidplay2Src;
    @FXML
    protected MenuItem printer;
    @FXML
    protected MenuItem console;
    @FXML
    protected MenuItem jsidplay2userGuide;
    @FXML
    protected MenuItem jsidplay2Javadoc;
    @FXML
    protected MenuItem videoPlayer;
    @FXML
    protected MenuItem saveTune;
    @FXML
    protected Button btnPlay;
    @FXML
    protected Button btnPause;
    @FXML
    protected Button btnPreviousSong;
    @FXML
    protected Button btnNextSong;
    @FXML
    protected Button btnNextFavorite;
    @FXML
    protected Button btnStop;
    @FXML
    private ToggleGroup floppyGroup;
    @FXML
    private ToggleGroup extensionGroup;
    @FXML
    private ToggleButton btnFastForward;
    @FXML
    private ToggleButton btnMinimizeMaximize;
    @FXML
    protected Tooltip btnPreviousSongToolTip;
    @FXML
    protected Tooltip btnNextSongToolTip;
    @FXML
    protected Label tracks;
    @FXML
    protected Label whatssidPositioner;
    private BooleanProperty btnNextFavoriteDisabledState;
    private BooleanProperty btnNextSongDisabledState;
    private int hardcopyCounter;
    private StateChangeListener propertyChangeListener;

    public MenuBar() {
    }

    public MenuBar(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        Configuration config = this.util.getConfig();
        SidPlay2Section sidplay2Section = config.getSidplay2Section();
        C1541Section c1541Section = config.getC1541Section();
        PrinterSection printer = config.getPrinterSection();
        this.btnFastForward.selectedProperty().bindBidirectional((Property)this.fastForward.selectedProperty());
        this.btnNextFavoriteDisabledState = new SimpleBooleanProperty(true);
        this.btnNextFavorite.disableProperty().bind((ObservableValue)this.btnNextFavoriteDisabledState);
        this.btnNextSongDisabledState = new SimpleBooleanProperty(true);
        this.playListStartsWithOne.selectedProperty().bindBidirectional((Property)sidplay2Section.playListStartsWithOneProperty());
        this.turboTape.selectedProperty().bindBidirectional((Property)sidplay2Section.turboTapeProperty());
        this.driveOn.selectedProperty().bindBidirectional((Property)c1541Section.driveOnProperty());
        this.parCable.selectedProperty().bindBidirectional((Property)c1541Section.parallelCableProperty());
        this.installJiffyDos.selectedProperty().bindBidirectional((Property)c1541Section.jiffyDosInstalledProperty());
        this.driveSoundOn.selectedProperty().bindBidirectional((Property)c1541Section.driveSoundOnProperty());
        this.turnPrinterOn.selectedProperty().bindBidirectional((Property)printer.printerOnProperty());
        BindingUtils.bindBidirectional(this.floppyGroup, c1541Section.floppyTypeProperty(), FloppyType.class);
        BindingUtils.bindBidirectional(this.extensionGroup, c1541Section.extendImagePolicyProperty(), ExtendImagePolicy.class);
        this.expand2000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled0Property());
        this.expand4000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled1Property());
        this.expand6000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled2Property());
        this.expand8000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled3Property());
        this.expandA000.selectedProperty().bindBidirectional((Property)c1541Section.ramExpansionEnabled4Property());
        if (this.util.getWindow() != null) {
            Stage stage = this.util.getWindow().getStage();
            stage.maximizedProperty().addListener((observable, oldValue, newValue) -> this.btnMinimizeMaximize.setDisable(newValue.booleanValue()));
            this.btnMinimizeMaximize.selectedProperty().bindBidirectional((Property)sidplay2Section.minimizedProperty());
            this.btnMinimizeMaximize.selectedProperty().addListener((observable, oldValue, newValue) -> {
                this.hideMainTabbedPane(stage, (Boolean)newValue);
                if (newValue.booleanValue()) {
                    sidplay2Section.setMinimizedX(this.getScene().getWindow().getX());
                    sidplay2Section.setMinimizedY(this.getScene().getWindow().getY());
                    sidplay2Section.setMinimizedWidth(this.getScene().getWindow().getWidth());
                    sidplay2Section.setMinimizedHeight(this.getScene().getWindow().getHeight());
                    this.resizeToMinHeight(stage);
                } else {
                    this.getScene().getWindow().setX(sidplay2Section.getMinimizedX());
                    this.getScene().getWindow().setY(sidplay2Section.getMinimizedY());
                    this.getScene().getWindow().setWidth(sidplay2Section.getMinimizedWidth());
                    this.getScene().getWindow().setHeight(sidplay2Section.getMinimizedHeight());
                }
            });
            if (sidplay2Section.isMinimized()) {
                Platform.runLater(() -> {
                    this.hideMainTabbedPane(stage, true);
                    this.resizeToMinHeight(stage);
                });
            }
        }
        ((ObservableList)this.util.getConfig().getViews()).addListener(c -> this.updateMenuItems());
        this.updateMenuItems();
        this.updatePlayerButtons(this.util.getPlayer().stateProperty().get(), this.util.getPlayer().getMixerInfo(mixer -> mixer.isFastForward(), false));
        this.propertyChangeListener = new StateChangeListener();
        this.util.getPlayer().stateProperty().addListener(this.propertyChangeListener);
        this.util.getPlayer().setWhatsSidHook(musicInfoWithConfidence -> Platform.runLater(() -> {
            System.out.println(musicInfoWithConfidence);
            Toast.makeText("whatssid", (Node)this.whatssidPositioner, musicInfoWithConfidence.toString(), 5);
        }));
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.propertyChangeListener);
    }

    private void updateMenuItems() {
        for (MenuItem menuItem : Arrays.asList(this.video, this.oscilloscope, this.favorites, this.hvsc, this.cgsc, this.hvmec, this.demos, this.mags, this.sidDump, this.sidRegisters, this.asm, this.disassembler, this.assembly64, this.csdb, this.remixKwedOrg, this.lemon64, this.forum64, this.soasc, this.codebase64, this.gamebase, this.jsidplay2Src, this.printer, this.console, this.jsidplay2userGuide, this.jsidplay2Javadoc, this.videoPlayer)) {
            menuItem.setDisable(false);
        }
        this.util.getConfig().getViews().stream().map(ViewEntity::getFxId).forEach(fxId -> {
            if ("VIDEO".equals(fxId)) {
                this.video.setDisable(true);
            } else if ("OSCILLOSCOPE".equals(fxId)) {
                this.oscilloscope.setDisable(true);
            } else if ("FAVORITES".equals(fxId)) {
                this.favorites.setDisable(true);
            } else if (MusicCollectionType.HVSC.name().equals(fxId)) {
                this.hvsc.setDisable(true);
            } else if (MusicCollectionType.CGSC.name().equals(fxId)) {
                this.cgsc.setDisable(true);
            } else if (DiskCollectionType.HVMEC.name().equals(fxId)) {
                this.hvmec.setDisable(true);
            } else if (DiskCollectionType.DEMOS.name().equals(fxId)) {
                this.demos.setDisable(true);
            } else if (DiskCollectionType.MAGS.name().equals(fxId)) {
                this.mags.setDisable(true);
            } else if ("SIDDUMP".equals(fxId)) {
                this.sidDump.setDisable(true);
            } else if ("SIDREGISTERS".equals(fxId)) {
                this.sidRegisters.setDisable(true);
            } else if ("ASM".equals(fxId)) {
                this.asm.setDisable(true);
            } else if ("DISASSEMBLER".equals(fxId)) {
                this.disassembler.setDisable(true);
            } else if ("ASSEMBLY64".equals(fxId)) {
                this.assembly64.setDisable(true);
            } else if (WebViewType.CSDB.name().equals(fxId)) {
                this.csdb.setDisable(true);
            } else if (WebViewType.REMIX_KWED_ORG.name().equals(fxId)) {
                this.remixKwedOrg.setDisable(true);
            } else if (WebViewType.LEMON64_COM.name().equals(fxId)) {
                this.lemon64.setDisable(true);
            } else if (WebViewType.FORUM64_DE.name().equals(fxId)) {
                this.forum64.setDisable(true);
            } else if (WebViewType.SOASC.name().equals(fxId)) {
                this.soasc.setDisable(true);
            } else if (WebViewType.CODEBASE64.name().equals(fxId)) {
                this.codebase64.setDisable(true);
            } else if ("GAMEBASE".equals(fxId)) {
                this.gamebase.setDisable(true);
            } else if (WebViewType.JSIDPLAY2_SRC.name().equals(fxId)) {
                this.jsidplay2Src.setDisable(true);
            } else if ("PRINTER".equals(fxId)) {
                this.printer.setDisable(true);
            } else if ("CONSOLE".equals(fxId)) {
                this.console.setDisable(true);
            } else if (WebViewType.USERGUIDE.name().equals(fxId)) {
                this.jsidplay2userGuide.setDisable(true);
            } else if (WebViewType.JSIDPLAY2_JAVADOC.name().equals(fxId)) {
                this.jsidplay2Javadoc.setDisable(true);
            } else if ("VIDEOPLAYER".equals(fxId)) {
                this.videoPlayer.setDisable(true);
            } else {
                throw new RuntimeException("Unknown view ID: " + fxId);
            }
        });
    }

    private void hideMainTabbedPane(Stage stage, Boolean hide) {
        Node node = this.getScene().lookup("#tabbedPane");
        node.setVisible(hide == false);
        node.setManaged(hide == false);
        stage.setResizable(hide == false);
    }

    private void resizeToMinHeight(Stage stage) {
        stage.sizeToScene();
        Platform.runLater(() -> this.btnMinimizeMaximize.setDisable(false));
    }

    @FXML
    private void load() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Tunes", TuneFileExtensions.EXTENSIONS));
        File file = fileDialog.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            try {
                this.util.getPlayer().play(SidTune.load(file));
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    @FXML
    private void saveTune() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Tunes", TuneFileExtensions.EXTENSIONS));
        File file = fileDialog.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            try {
                this.util.getPlayer().getTune().save(file.getAbsolutePath());
            }
            catch (IOException e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    @FXML
    private void playVideo() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Cartridges", CartFileExtensions.EXTENSIONS));
        File file = fileDialog.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(NUVIE_PLAYER);){
                this.util.getPlayer().insertCartridge(CartridgeType.REU, file);
                this.util.getPlayer().play(SidTune.load("nuvieplayer-v1.0.prg", is));
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()));
            }
        }
    }

    @FXML
    private void reset() {
        this.util.getPlayer().play(SidTune.RESET);
    }

    @FXML
    private void quit() {
        this.util.getWindow().close();
    }

    @FXML
    private void pauseContinue() {
        this.util.getPlayer().pauseContinue();
    }

    @FXML
    private void previousSong() {
        this.util.getPlayer().previousSong();
    }

    @FXML
    private void nextSong() {
        this.util.getPlayer().nextSong();
    }

    @FXML
    private void normalSpeed() {
        this.util.getPlayer().configureMixer(mixer -> mixer.normalSpeed());
    }

    @FXML
    private void fastForward() {
        this.util.getPlayer().configureMixer(mixer -> mixer.fastForward());
    }

    @FXML
    private void fastForward2X() {
        Boolean isFastForward = this.util.getPlayer().getMixerInfo(mixer -> mixer.isFastForward(), false);
        if (isFastForward.booleanValue()) {
            this.util.getPlayer().configureMixer(mixer -> mixer.normalSpeed());
        } else {
            this.util.getPlayer().configureMixer(mixer -> mixer.fastForward());
        }
        this.updatePlayerButtons(this.util.getPlayer().stateProperty().get(), isFastForward == false);
    }

    @FXML
    private void nextFavorite() {
        C64 c64 = this.util.getPlayer().getC64();
        EventScheduler ctx = c64.getEventScheduler();
        ctx.scheduleThreadSafe(Event.of("Timer End To Play Next Favorite!", event -> {
            if (this.util.getPlayer().stateProperty().get() == State.PLAY || this.util.getPlayer().stateProperty().get() == State.PAUSE) {
                this.util.getPlayer().getPlayList().last();
                this.util.getPlayer().getTimer().end();
            }
        }));
    }

    @FXML
    private void stop() {
        this.util.getPlayer().quit();
    }

    @FXML
    private void playListStartsWithOne() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        this.util.getPlayer().setFirstPlayListEntryIsOne(sidplay2Section.isPlayListStartsWithOne());
    }

    @FXML
    private void doHardcopyGif() {
        this.createHardCopy("gif");
    }

    @FXML
    private void doHardcopyJpg() {
        this.createHardCopy("jpg");
    }

    @FXML
    private void doHardcopyPng() {
        this.createHardCopy("png");
    }

    @FXML
    private void ultimate64() {
        new Ultimate64Window(this.util.getPlayer()).open();
    }

    @FXML
    private void audioSettings() {
        new AudioSettings(this.util.getPlayer()).open();
    }

    @FXML
    private void emulationSettings() {
        new EmulationSettings(this.util.getPlayer()).open();
    }

    @FXML
    private void whatsSidSettings() {
        new WhatsSidSettings(this.util.getPlayer()).open();
    }

    @FXML
    private void joystickSettings() {
        new JoystickSettings(this.util.getPlayer()).open();
    }

    @FXML
    private void proxySettings() {
        new ProxySettings(this.util.getPlayer()).open();
    }

    @FXML
    private void recordTape() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.RECORD);
    }

    @FXML
    private void playTape() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.START);
    }

    @FXML
    private void rewindTape() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.REWIND);
    }

    @FXML
    private void forwardTape() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.FORWARD);
    }

    @FXML
    private void stopTape() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.STOP);
    }

    @FXML
    private void resetCounter() {
        this.util.getPlayer().getDatasette().control(Datasette.Control.RESET_COUNTER);
    }

    @FXML
    private void insertTape() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Tapes", TapeFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_TAPE"));
        File file = fileDialog.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertTape(file);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void ejectTape() {
        try {
            this.util.getPlayer().getDatasette().ejectTape();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void turnDriveOn() {
        this.util.getPlayer().enableFloppyDiskDrives(this.util.getConfig().getC1541Section().isDriveOn());
    }

    @FXML
    private void parallelCable() {
        this.util.getPlayer().connectC64AndC1541WithParallelCable(this.util.getConfig().getC1541Section().isParallelCable());
    }

    @FXML
    private void installJiffyDos() {
        this.reset();
    }

    @FXML
    private void floppyTypeC1541() {
        this.getFirstFloppy().setFloppyType(FloppyType.C1541);
        this.util.getConfig().getC1541Section().setFloppyType(FloppyType.C1541);
    }

    @FXML
    private void floppyTypeC1541_II() {
        this.getFirstFloppy().setFloppyType(FloppyType.C1541_II);
        this.util.getConfig().getC1541Section().setFloppyType(FloppyType.C1541_II);
    }

    @FXML
    private void extendNever() {
        this.util.getConfig().getC1541Section().setExtendImagePolicy(ExtendImagePolicy.EXTEND_NEVER);
    }

    @FXML
    private void extendAsk() {
        this.util.getConfig().getC1541Section().setExtendImagePolicy(ExtendImagePolicy.EXTEND_ASK);
    }

    @FXML
    private void extendAccess() {
        this.util.getConfig().getC1541Section().setExtendImagePolicy(ExtendImagePolicy.EXTEND_ACCESS);
    }

    @FXML
    private void expansion0x2000() {
        this.getFirstFloppy().setRamExpansion(0, this.util.getConfig().getC1541Section().isRamExpansionEnabled0());
    }

    @FXML
    private void expansion0x4000() {
        this.getFirstFloppy().setRamExpansion(1, this.util.getConfig().getC1541Section().isRamExpansionEnabled1());
    }

    @FXML
    private void expansion0x6000() {
        this.getFirstFloppy().setRamExpansion(2, this.util.getConfig().getC1541Section().isRamExpansionEnabled2());
    }

    @FXML
    private void expansion0x8000() {
        this.getFirstFloppy().setRamExpansion(3, this.util.getConfig().getC1541Section().isRamExpansionEnabled3());
    }

    @FXML
    private void expansion0xA000() {
        this.getFirstFloppy().setRamExpansion(4, this.util.getConfig().getC1541Section().isRamExpansionEnabled4());
    }

    @FXML
    private void insertDisk() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Disks", DiskFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_DISK"));
        File file = fileDialog.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertDisk(file);
            }
            catch (IOException e) {
                System.err.println(String.format("Cannot insert media file '%s'.", file.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void ejectDisk() {
        try {
            this.getFirstFloppy().getDiskController().ejectDisk();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    private void resetDrive() {
        this.getFirstFloppy().reset();
    }

    @FXML
    private void insertEmptyDisk() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Disks", DiskFileExtensions.STD_EXTENSIONS()));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_EMPTY_DISK"));
        File file = fileDialog.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            File target = new File(file.getParentFile(), IOUtils.getFilenameWithoutSuffix(file.getName()) + ".d64");
            try (DataOutputStream os = new DataOutputStream(new FileOutputStream(target));){
                os.write(EMPTY_DISK);
            }
            catch (IOException e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_WRITE_ERROR"), e.getMessage()));
            }
            this.video();
            try {
                this.util.getPlayer().insertDisk(target);
            }
            catch (IOException e) {
                System.err.println(String.format("Cannot insert media file '%s'.", target.getAbsolutePath()));
            }
        }
    }

    @FXML
    private void printerOn() {
        this.util.getPlayer().enablePrinter(this.util.getConfig().getPrinterSection().isPrinterOn());
    }

    @FXML
    private void insertCartridge() {
        this.chooseCartridge(CartridgeType.CRT);
    }

    @FXML
    private void insertGeoRAM() {
        this.chooseCartridge(CartridgeType.GEORAM);
    }

    @FXML
    private void insertGeoRAM64() {
        this.insertCartridge(CartridgeType.GEORAM, 64);
    }

    @FXML
    private void insertGeoRAM128() {
        this.insertCartridge(CartridgeType.GEORAM, 128);
    }

    @FXML
    private void insertGeoRAM256() {
        this.insertCartridge(CartridgeType.GEORAM, 256);
    }

    @FXML
    private void insertGeoRAM512() {
        this.insertCartridge(CartridgeType.GEORAM, 512);
    }

    @FXML
    private void insertGeoRAM1024() {
        this.insertCartridge(CartridgeType.GEORAM, 1024);
    }

    @FXML
    private void insertGeoRAM2048() {
        this.insertCartridge(CartridgeType.GEORAM, 2048);
    }

    @FXML
    private void insertREU() {
        this.chooseCartridge(CartridgeType.REU);
    }

    @FXML
    private void insertREU128() {
        this.insertCartridge(CartridgeType.REU, 128);
    }

    @FXML
    private void insertREU256() {
        this.insertCartridge(CartridgeType.REU, 256);
    }

    @FXML
    private void insertREU512() {
        this.insertCartridge(CartridgeType.REU, 512);
    }

    @FXML
    private void insertREU2048() {
        this.insertCartridge(CartridgeType.REU, 2048);
    }

    @FXML
    private void insertREU16384() {
        this.insertCartridge(CartridgeType.REU, 16384);
    }

    @FXML
    private void insertARMKVI() {
        this.insertCartridge(MenuBar.class.getResourceAsStream(ACTION_REPLAY_MKVI));
    }

    @FXML
    private void insertSoundExpander3526() {
        this.insertCartridge(CartridgeType.SOUNDEXPANDER, 0);
        this.reset();
    }

    @FXML
    private void insertSoundExpander3812() {
        this.insertCartridge(CartridgeType.SOUNDEXPANDER, 1);
        this.reset();
    }

    @FXML
    private void ejectCartridge() {
        this.util.getPlayer().getC64().ejectCartridge();
        this.reset();
    }

    @FXML
    private void freezeCartridge() {
        this.util.getPlayer().getC64().getCartridge().freeze();
    }

    @FXML
    private void video() {
        this.addView("VIDEO");
    }

    @FXML
    private void oscilloscope() {
        this.addView("OSCILLOSCOPE");
    }

    @FXML
    private void hvsc() {
        this.addView(MusicCollectionType.HVSC.name());
    }

    @FXML
    private void cgsc() {
        this.addView(MusicCollectionType.CGSC.name());
    }

    @FXML
    private void hvmec() {
        this.addView(DiskCollectionType.HVMEC.name());
    }

    @FXML
    private void demos() {
        this.addView(DiskCollectionType.DEMOS.name());
    }

    @FXML
    private void mags() {
        this.addView(DiskCollectionType.MAGS.name());
    }

    @FXML
    private void favorites() {
        this.addView("FAVORITES");
    }

    @FXML
    private void gamebase() {
        this.addView("GAMEBASE");
    }

    @FXML
    private void asm() {
        this.addView("ASM");
    }

    @FXML
    private void printer() {
        this.addView("PRINTER");
    }

    @FXML
    private void console() {
        this.addView("CONSOLE");
    }

    @FXML
    private void sidDump() {
        this.addView("SIDDUMP");
    }

    @FXML
    private void sidRegisters() {
        this.addView("SIDREGISTERS");
    }

    @FXML
    private void disassembler() {
        this.addView("DISASSEMBLER");
    }

    @FXML
    private void assembly64() {
        this.addView("ASSEMBLY64");
    }

    @FXML
    private void csdb() {
        this.addView(WebViewType.CSDB.name());
    }

    @FXML
    private void codebase64() {
        this.addView(WebViewType.CODEBASE64.name());
    }

    @FXML
    private void remixKweqOrg() {
        this.addView(WebViewType.REMIX_KWED_ORG.name());
    }

    @FXML
    private void forum64() {
        this.addView(WebViewType.FORUM64_DE.name());
    }

    @FXML
    private void lemon64() {
        this.addView(WebViewType.LEMON64_COM.name());
    }

    @FXML
    private void soasc() {
        this.addView(WebViewType.SOASC.name());
    }

    @FXML
    private void jsidplay2Src() {
        this.addView(WebViewType.JSIDPLAY2_SRC.name());
    }

    @FXML
    private void jsidplay2Javadoc() {
        this.addView(WebViewType.JSIDPLAY2_JAVADOC.name());
    }

    @FXML
    private void userguide() {
        this.addView(WebViewType.USERGUIDE.name());
    }

    @FXML
    private void videoPlayer() {
        this.addView("VIDEOPLAYER");
    }

    @FXML
    private void updateCheck() {
        new Update(this.util.getPlayer()).open();
    }

    @FXML
    private void about() {
        new About(this.util.getPlayer()).open();
    }

    private void addView(String fxId) {
        if (!this.util.getConfig().getViews().stream().map(ViewEntity::getFxId).filter(fxId::equals).findFirst().isPresent()) {
            this.util.getConfig().getViews().add(new ViewEntity(fxId));
        }
    }

    private void chooseCartridge(CartridgeType type2) {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        fileDialog.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("C64 Cartridges", CartFileExtensions.EXTENSIONS));
        fileDialog.setTitle(this.util.getBundle().getString("INSERT_CARTRIDGE"));
        File file = fileDialog.showOpenDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                this.util.getPlayer().insertCartridge(type2, file);
                this.util.getPlayer().play(SidTune.RESET);
            }
            catch (IOException e) {
                System.err.println(String.format("Cannot insert file '%s' as cartridge of type '%s'.", file.getAbsolutePath(), type2.name()));
            }
        }
    }

    private void insertCartridge(CartridgeType type2, int sizeKB) {
        try {
            this.util.getPlayer().insertCartridge(type2, sizeKB);
            this.util.getPlayer().play(SidTune.RESET);
        }
        catch (IOException ex) {
            System.err.println(String.format("Cannot insert cartridge of type '%s' and size '%d'KB.", type2.name(), sizeKB));
        }
    }

    private void insertCartridge(InputStream is) {
        try {
            this.util.getPlayer().insertCartridgeCRT(is);
            this.util.getPlayer().play(SidTune.RESET);
        }
        catch (IOException ex) {
            System.err.println("Cannot insert cartridge of type 'CRT'.");
        }
    }

    private C1541 getFirstFloppy() {
        return this.util.getPlayer().getFloppies()[0];
    }

    private void createHardCopy(String format) {
        this.video();
        try {
            javafx.scene.image.Image vicImage = Video.getVicImage();
            if (vicImage != null) {
                File file = new File(this.util.getConfig().getSidplay2Section().getTmpDir(), "screenshot" + ++this.hardcopyCounter + "." + format);
                if (format.equals("jpg")) {
                    BufferedImage image = SwingFXUtils.fromFXImage((javafx.scene.image.Image)vicImage, null);
                    BufferedImage vicImageRGB = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                    Graphics2D graphics = vicImageRGB.createGraphics();
                    graphics.drawImage((Image)image, 0, 0, null);
                    ImageIO.write((RenderedImage)vicImageRGB, format, file);
                    graphics.dispose();
                } else {
                    ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((javafx.scene.image.Image)vicImage, null), format, file);
                }
                DesktopUtil.open(file);
            } else {
                System.err.println("Screenshot not possible, there is currently no frame!");
            }
        }
        catch (IOException e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_WRITE_ERROR"), e.getMessage()));
        }
    }

    private void updatePlayerButtons(State state, boolean isFastForward) {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        SidTune sidTune = this.util.getPlayer().getTune();
        PlayList playList = this.util.getPlayer().getPlayList();
        this.btnNextFavoriteDisabledState.set(sidTune == SidTune.RESET || state == State.QUIT || sidplay2Section.getPlaybackType() == PlaybackType.PLAYBACK_OFF);
        this.btnNextSongDisabledState.set(sidTune == SidTune.RESET || state == State.QUIT);
        boolean isPlayOrPause = state == State.PLAY || state == State.PAUSE;
        this.pauseContinue.setSelected(state == State.PAUSE);
        this.previousSong.setDisable(this.btnNextSongDisabledState.get() || !playList.hasPrevious());
        this.previousSong.setText(String.format(this.util.getBundle().getString("PREVIOUS_SONG") + " (%d/%d)", playList.getPrevious(), playList.getLength()));
        this.nextSong.setDisable(this.btnNextSongDisabledState.get() || !playList.hasNext());
        this.nextSong.setText(String.format(this.util.getBundle().getString("NEXT_SONG") + " (%d/%d)", playList.getNext(), playList.getLength()));
        this.normalSpeed.setSelected(!isPlayOrPause || !isFastForward);
        this.normalSpeed.setDisable(!isPlayOrPause);
        this.fastForward.setDisable(!isPlayOrPause);
        this.fastForward.setSelected(isPlayOrPause && isFastForward);
        this.stop.setDisable(!isPlayOrPause);
        this.btnPlay.setDisable(state == State.PLAY);
        this.btnPause.setDisable(state != State.PLAY);
        this.btnFastForward.setDisable(!isPlayOrPause);
        this.btnFastForward.setSelected(isPlayOrPause && isFastForward);
        this.btnStop.setDisable(!isPlayOrPause);
        this.btnPreviousSong.setDisable(this.previousSong.isDisable());
        this.btnPreviousSongToolTip.setText(String.format(this.util.getBundle().getString("BTN_PREVIOUS_SONG") + " (%d/%d)", playList.getPrevious(), playList.getLength()));
        this.btnNextSong.setDisable(this.nextSong.isDisable());
        this.btnNextSongToolTip.setText(String.format(this.util.getBundle().getString("BTN_NEXT_SONG") + " (%d/%d)", playList.getNext(), playList.getLength()));
        this.saveTune.setDisable(sidTune == SidTune.RESET);
    }

    private void setCurrentTrack(SidTune sidTune) {
        StringBuilder trackInfo = new StringBuilder();
        StringBuilder trackInfoToolTip = new StringBuilder();
        if (sidTune != SidTune.RESET) {
            SidTuneInfo info = sidTune.getInfo();
            Iterator<String> detail = info.getInfoString().iterator();
            if (detail.hasNext()) {
                String title = detail.next();
                trackInfo.append(title).append(' ');
                trackInfoToolTip.append(title).append('\n');
            }
            if (detail.hasNext()) {
                trackInfoToolTip.append(detail.next()).append('\n');
            }
            if (detail.hasNext()) {
                trackInfoToolTip.append(detail.next());
            }
            trackInfo.append(String.format("%2d/%2d", info.getCurrentSong(), info.getSongs()));
        }
        this.tracks.setText(trackInfo.toString());
        this.tracks.setTooltip(new Tooltip(trackInfoToolTip.toString()));
    }

    private void openErrorDialog(String msg) {
        Alert alert = new Alert(Alert.AlertType.ERROR, msg, new ButtonType[0]);
        alert.setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        alert.showAndWait();
    }

    static {
        try (DataInputStream is2 = new DataInputStream(MenuBar.class.getResourceAsStream(EMPTY_D64));
             DataInputStream is = new DataInputStream(MenuBar.class.getResourceAsStream(NUVIE_PLAYER_PRG));){
            URL us3 = JSidPlay2Main.class.getResource(EMPTY_D64);
            EMPTY_DISK = new byte[us3.openConnection().getContentLength()];
            is2.readFully(EMPTY_DISK);
            URL us2 = JSidPlay2Main.class.getResource(NUVIE_PLAYER_PRG);
            NUVIE_PLAYER = new byte[us2.openConnection().getContentLength()];
            is.readFully(NUVIE_PLAYER);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private class StateChangeListener
    implements PropertyChangeListener {
        private StateChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Platform.runLater(() -> {
                if (event.getNewValue() == State.START) {
                    MenuBar.this.setCurrentTrack(MenuBar.this.util.getPlayer().getTune());
                }
                MenuBar.this.updatePlayerButtons((State)((Object)((Object)event.getNewValue())), MenuBar.this.util.getPlayer().getMixerInfo(mixer -> mixer.isFastForward(), false));
            });
        }
    }
}

