/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import libsidutils.IOUtils;
import libsidutils.stil.STIL;
import sidplay.Player;
import ui.JSidPlay2Main;
import ui.common.comparator.FileComparator;
import ui.common.filefilter.TuneFileFilter;
import ui.entities.config.SidPlay2Section;

public class MusicCollectionTreeItem
extends TreeItem<File> {
    private static final Image stilIcon = new Image(JSidPlay2Main.class.getResource("icons/stil.png").toString());
    private static final Image noStilIcon = new Image(JSidPlay2Main.class.getResource("icons/stil_no.png").toString());
    private final FileFilter fileFilter = new TuneFileFilter();
    private boolean hasLoadedChildren;
    private boolean isLeaf;
    private boolean hasSTIL;
    private Player player;
    private STIL.STILEntry stilEntry;

    public MusicCollectionTreeItem(Player player, File file) {
        super((Object)file);
        this.player = player;
        this.isLeaf = file.isFile();
        if (this.isLeaf && player != null) {
            SidPlay2Section sidPlay2Section = (SidPlay2Section)player.getConfig().getSidplay2Section();
            String collectionName = IOUtils.getCollectionName(sidPlay2Section.getHvsc(), file);
            this.stilEntry = player.getStilEntry(collectionName);
            this.hasSTIL = this.stilEntry != null;
        }
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public ObservableList<TreeItem<File>> getChildren() {
        if (!this.hasLoadedChildren) {
            this.loadChildren();
        }
        return super.getChildren();
    }

    public boolean hasSTIL() {
        return this.hasSTIL;
    }

    public STIL.STILEntry getStilEntry() {
        return this.stilEntry;
    }

    private void loadChildren() {
        this.hasLoadedChildren = true;
        ArrayList children = new ArrayList();
        Arrays.stream(Optional.ofNullable(((File)this.getValue()).listFiles(this.fileFilter)).orElse(new File[0])).sorted(new FileComparator()).forEach(file -> {
            MusicCollectionTreeItem childItem = new MusicCollectionTreeItem(this.player, (File)file);
            children.add(childItem);
            if (childItem.hasSTIL()) {
                childItem.setGraphic((Node)new ImageView(stilIcon));
            } else {
                childItem.setGraphic((Node)new ImageView(noStilIcon));
            }
        });
        super.getChildren().setAll(children);
    }
}

