/*
 * Decompiled with CFR 0.152.
 */
package ui.oscilloscope;

import builder.resid.ReSIDBase;
import javafx.fxml.FXML;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import libsidplay.common.SIDEmu;
import sidplay.Player;
import ui.common.C64Window;
import ui.oscilloscope.SIDGauge;

public final class WaveGauge
extends SIDGauge {
    @FXML
    private TitledPane border;
    @FXML
    private ImageView area;

    public WaveGauge() {
    }

    public WaveGauge(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    protected ImageView getArea() {
        return this.area;
    }

    @Override
    protected TitledPane getTitledPane() {
        return this.border;
    }

    @Override
    public SIDGauge sample(SIDEmu sidemu) {
        if (sidemu instanceof ReSIDBase) {
            this.accumulate((float)(((ReSIDBase)sidemu).readOSC(this.getVoice()) & 0xFF) / 255.0f);
        } else {
            this.accumulate(0.0f);
        }
        return this;
    }

    @Override
    public void addImage(SIDEmu sidemu) {
        if (sidemu != null) {
            byte wf = sidemu.readInternalRegister(4 + 7 * this.getVoice());
            byte filt = sidemu.readInternalRegister(23);
            this.setText(this.createText(wf, filt));
        }
        super.addImage(sidemu);
    }

    private String createText(byte wf, byte filt) {
        StringBuilder result = new StringBuilder();
        result.append(this.localizer.getString("WAVE"));
        result.append(" ");
        result.append(Integer.toHexString(wf >> 4 & 0xF));
        result.append(" ");
        if ((wf & 2) != 0) {
            result.append("S");
        }
        if ((wf & 4) != 0) {
            result.append("R");
        }
        if ((wf & 8) != 0) {
            result.append("T");
        }
        if ((filt & 1 << this.getVoice()) != 0) {
            result.append("F");
        }
        return result.toString();
    }
}

