/*
 * Decompiled with CFR 0.152.
 */
package ui.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import libsidplay.common.SamplingRate;
import libsidplay.components.mos656x.PALEmulation;
import libsidplay.config.IWhatsSidSystemProperties;
import libsidplay.sidtune.MD5Method;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.fingerprinting.FingerPrinting;
import libsidutils.fingerprinting.ini.IniFingerprintConfig;
import libsidutils.siddatabase.SidDatabase;
import sidplay.Player;
import sidplay.audio.AudioDriver;
import sidplay.filefilter.AudioTuneFileFilter;
import sidplay.filefilter.VideoTuneFileFilter;
import sidplay.ini.IniConfig;
import sidplay.ini.converter.FileToStringConverter;
import sidplay.player.DebugUtil;
import ui.entities.PersistenceProperties;
import ui.entities.whatssid.service.WhatsSidService;
import ui.tools.audio.WhatsSidDriver;

@Parameters(resourceBundle="ui.tools.RecordingTool")
public class RecordingTool {
    private static final AudioTuneFileFilter AUDIO_TUNE_FILE_FILTER;
    private static final VideoTuneFileFilter VIDEO_TUNE_FILE_FILTER;
    @Parameter(names={"--help", "-h"}, descriptionKey="USAGE", help=true, order=10000)
    private Boolean help = Boolean.FALSE;
    @Parameter(names={"--maxThreads"}, descriptionKey="MAX_THREADS", order=10001)
    private Integer maxThreads = Runtime.getRuntime().availableProcessors();
    @Parameter(names={"--destinationDirectory"}, descriptionKey="DESTINATION_DIRECTORY", converter=FileToStringConverter.class, order=10002)
    private File destinationDirectory;
    @Parameter(names={"--fingerprinting"}, descriptionKey="FINGERPRINTING", arity=1, order=10003)
    private Boolean fingerprinting = Boolean.FALSE;
    @Parameter(names={"--whatsSIDDatabaseDriver"}, descriptionKey="WHATSSID_DATABASE_DRIVER", order=10004)
    private String whatsSidDatabaseDriver;
    @Parameter(names={"--whatsSIDDatabaseUrl"}, descriptionKey="WHATSSID_DATABASE_URL", order=10005)
    private String whatsSidDatabaseUrl;
    @Parameter(names={"--whatsSIDDatabaseUsername"}, descriptionKey="WHATSSID_DATABASE_USERNAME", order=10006)
    private String whatsSidDatabaseUsername;
    @Parameter(names={"--whatsSIDDatabasePassword"}, descriptionKey="WHATSSID_DATABASE_PASSWORD", order=10007)
    private String whatsSidDatabasePassword;
    @Parameter(names={"--whatsSIDDatabaseDialect"}, descriptionKey="WHATSSID_DATABASE_DIALECT", order=10008)
    private String whatsSidDatabaseDialect;
    @Parameter(names={"--createIni"}, descriptionKey="CREATE_INI", arity=1, order=10009)
    private Boolean createIni = Boolean.FALSE;
    @Parameter(names={"--deleteAll"}, descriptionKey="DELETE_ALL", arity=1, order=10010)
    private Boolean deleteAll = Boolean.FALSE;
    @Parameter(names={"--previousDirectory"}, descriptionKey="PREVIOUS_DIRECTORY", converter=FileToStringConverter.class, order=10011)
    private File previousDirectory;
    @Parameter(descriptionKey="DIRECTORY", converter=FileToStringConverter.class)
    private File directory;
    @ParametersDelegate
    private IniConfig config = new IniConfig(false);
    private static final ThreadLocal<EntityManager> THREAD_LOCAL_ENTITY_MANAGER;
    private static EntityManagerFactory entityManagerFactory;
    private ExecutorService executor;
    private SidDatabase previousSidDatabase;
    private volatile boolean quit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] args) {
        try {
            JCommander commander = JCommander.newBuilder().addObject((Object)this).programName(this.getClass().getName()).build();
            commander.parse(args);
            if (this.help.booleanValue() || this.directory == null) {
                commander.usage();
                System.out.println("Press <enter> to exit!");
                System.in.read();
                System.exit(0);
            }
            if (this.config.getSidplay2Section().getHvsc() == null) {
                System.out.println("Parameter --hvsc is required!");
                System.exit(1);
            }
            if (this.fingerprinting.booleanValue()) {
                this.config.getAudioSection().setSamplingRate(SamplingRate.VERY_LOW);
            }
            this.config.getSidplay2Section().setEnableDatabase(true);
            this.config.getSidplay2Section().setSingle(false);
            if (this.previousDirectory != null) {
                this.previousSidDatabase = new SidDatabase(this.previousDirectory);
            }
            if (this.fingerprinting.booleanValue()) {
                entityManagerFactory = Persistence.createEntityManagerFactory((String)"whatssid-ds", (Map)new PersistenceProperties(this.whatsSidDatabaseDriver, this.whatsSidDatabaseUrl, this.whatsSidDatabaseUsername, this.whatsSidDatabasePassword, this.whatsSidDatabaseDialect));
                WhatsSidService whatsSidService = new WhatsSidService(RecordingTool.getEntityManager());
                if (Boolean.TRUE.equals(this.deleteAll)) {
                    this.deleteAllFingerprintings(whatsSidService);
                }
            }
            this.executor = Executors.newFixedThreadPool(this.maxThreads);
            System.out.println("Create Recordings... (To abort press q <return> and wait for termination)");
            this.processDirectory(this.executor, this.directory);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (this.executor != null) {
                try {
                    this.executor.shutdown();
                    if (!this.executor.awaitTermination(IWhatsSidSystemProperties.AWAIT_TERMINATION, TimeUnit.DAYS)) {
                        this.executor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.executor.shutdownNow();
                }
            }
            if (this.fingerprinting.booleanValue()) {
                RecordingTool.freeEntityManager();
            }
            if (entityManagerFactory != null && entityManagerFactory.isOpen()) {
                entityManagerFactory.close();
            }
            System.exit(0);
        }
    }

    private void deleteAllFingerprintings(WhatsSidService whatsSidService) throws IOException {
        System.out.println("Delete all fingerprintings...");
        switch (this.proceed()) {
            case 89: 
            case 121: {
                whatsSidService.deleteAll();
                System.out.println("Done!");
                break;
            }
            default: {
                System.out.println("Aborted by user!");
            }
        }
    }

    private int proceed() throws IOException {
        System.out.println("You are about to delete all fingerprintings from the database. Are you sure to proceed? (y/N)");
        return System.in.read();
    }

    private void processDirectory(ExecutorService executor, File dir) throws IOException, SidTuneError {
        if (this.quit) {
            return;
        }
        Object[] listFiles = Optional.ofNullable(dir.listFiles()).orElse(new File[0]);
        Arrays.sort(listFiles);
        for (Object file : listFiles) {
            if (((File)file).isDirectory()) {
                this.processDirectory(executor, (File)file);
                continue;
            }
            if (!((File)file).isFile() || this.quit || !AUDIO_TUNE_FILE_FILTER.accept((File)file) && !VIDEO_TUNE_FILE_FILTER.accept((File)file)) continue;
            executor.execute(() -> this.lambda$processDirectory$0((File)file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File file) throws IOException, SidTuneError {
        try {
            AudioDriver audioDriver;
            SidTune tune = SidTune.load(file);
            String collectionName = IOUtils.getCollectionName(this.directory, file);
            Player player = new Player(this.config);
            player.getC64().getVIC().setPalEmulation(PALEmulation.NONE);
            player.setSidDatabase(new SidDatabase(this.config.getSidplay2Section().getHvsc()));
            if (this.fingerprinting.booleanValue()) {
                WhatsSidService whatsSidService = new WhatsSidService(RecordingTool.getEntityManager());
                WhatsSidDriver whatsSidDriver = new WhatsSidDriver();
                whatsSidDriver.setFingerprintInserter(new FingerPrinting(new IniFingerprintConfig(this.createIni), whatsSidService));
                whatsSidDriver.setCollectionName(collectionName);
                whatsSidDriver.setTune(tune);
                audioDriver = whatsSidDriver;
                if (this.previousDirectory != null) {
                    this.copyRecordingsOfPreviousDirectory(player, whatsSidDriver, file, tune, collectionName);
                }
            } else {
                audioDriver = player.getConfig().getAudioSection().getAudio().newAudioDriver();
                boolean allRecordingsExist = true;
                for (int songNo = 1; songNo <= tune.getInfo().getSongs(); ++songNo) {
                    allRecordingsExist &= new File(this.getRecordingFilename(collectionName, file, tune, songNo) + audioDriver.getExtension()).exists();
                }
                if (allRecordingsExist) {
                    return;
                }
            }
            player.setAudioDriver(audioDriver);
            player.setRecordingFilenameProvider(theTune -> this.getRecordingFilename(collectionName, file, (SidTune)theTune, theTune.getInfo().getCurrentSong()));
            player.setTune(tune);
            player.startC64();
            player.stopC64(false);
        }
        finally {
            if (this.fingerprinting.booleanValue()) {
                RecordingTool.freeEntityManager();
            }
        }
    }

    private void copyRecordingsOfPreviousDirectory(Player player, AudioDriver whatsSidDriver, File file, SidTune tune, String collectionName) throws IOException, SidTuneError {
        File previousFile = new File(this.previousDirectory, collectionName);
        if (previousFile.exists()) {
            SidTune previousTune = SidTune.load(previousFile);
            if (Objects.equals(tune.getMD5Digest(MD5Method.MD5_CONTENTS), previousTune.getMD5Digest(MD5Method.MD5_CONTENTS)) && player.getSidDatabaseInfo(db -> db.getTuneLength(tune), 0.0).doubleValue() == this.previousSidDatabase.getTuneLength(previousTune)) {
                for (int songNo = 1; songNo <= tune.getInfo().getSongs(); ++songNo) {
                    File recordedFile = new File(this.getRecordingFilename(collectionName, file, tune, songNo) + whatsSidDriver.getExtension());
                    File previousRecordedFile = new File(this.getRecordingFilename(collectionName, previousFile, previousTune, songNo) + whatsSidDriver.getExtension());
                    if (recordedFile.exists() || !previousRecordedFile.exists()) continue;
                    System.out.println(String.format("Tune is unchanged, copy %s to %s", previousRecordedFile, recordedFile));
                    Files.copy(previousRecordedFile.toPath(), recordedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }

    private String getRecordingFilename(String collectionName, File file, SidTune tune, int song) {
        File targetFile;
        if (this.destinationDirectory != null) {
            targetFile = new File(this.destinationDirectory, collectionName);
            targetFile.getParentFile().mkdirs();
        } else {
            targetFile = file;
        }
        String filename = IOUtils.getFilenameWithoutSuffix(targetFile.getAbsolutePath());
        if (tune.getInfo().getSongs() > 1) {
            filename = filename + String.format("-%02d", song);
        }
        return filename;
    }

    public static EntityManager getEntityManager() throws IOException {
        if (entityManagerFactory == null) {
            throw new IOException("Database required, please specify command line parameters!");
        }
        EntityManager em = THREAD_LOCAL_ENTITY_MANAGER.get();
        if (em == null) {
            em = entityManagerFactory.createEntityManager();
            THREAD_LOCAL_ENTITY_MANAGER.set(em);
        }
        return em;
    }

    public static void freeEntityManager() {
        EntityManager em = THREAD_LOCAL_ENTITY_MANAGER.get();
        if (em != null) {
            em.clear();
        }
    }

    public static void main(String[] args) {
        new RecordingTool().execute(args);
    }

    private /* synthetic */ void lambda$processDirectory$0(File file) {
        try {
            int key;
            if (this.quit) {
                return;
            }
            this.processFile(file);
            if (System.in.available() > 0 && (key = System.in.read()) == 113) {
                this.quit = true;
                System.err.println("Termination after pressing q, please wait for last recordings to finish");
            }
        }
        catch (IOException | SidTuneError e) {
            e.printStackTrace();
        }
    }

    static {
        DebugUtil.init();
        AUDIO_TUNE_FILE_FILTER = new AudioTuneFileFilter();
        VIDEO_TUNE_FILE_FILTER = new VideoTuneFileFilter();
        THREAD_LOCAL_ENTITY_MANAGER = new ThreadLocal();
    }
}

