/*
 * Decompiled with CFR 0.152.
 */
package ui.webview;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.web.WebEngine;
import javafx.stage.Modality;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLImageElement;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.Convenience;
import ui.common.UIPart;
import ui.common.download.DownloadThread;
import ui.common.download.IDownloadListener;
import ui.tuneinfos.TuneInfos;
import ui.webview.WebViewType;

public class WebView
extends C64VBox
implements UIPart {
    @FXML
    private Button backward;
    @FXML
    private Button forward;
    @FXML
    private javafx.scene.web.WebView webView;
    @FXML
    private TextField urlField;
    @FXML
    private ToggleButton showTuneInfoButton;
    @FXML
    private Slider zoom;
    private Convenience convenience;
    private WebViewType type;
    private WebEngine engine;
    private boolean isDownloading;
    private ChangeListener<? super Number> progressListener;
    private ChangeListener<? super String> locationListener;
    private HyperlinkRedirectListener hyperlinkRedirectListener;
    private ChangeListener<? super Number> historyListener;
    private boolean showTuneInfos;

    public WebView() {
    }

    public WebView(C64Window window, Player player) {
        super(window, player);
    }

    public void setType(WebViewType type2) {
        this.type = type2;
        this.home();
    }

    @Override
    @FXML
    protected void initialize() {
        this.progressListener = (observable, oldValue, newValue) -> Platform.runLater(() -> {
            DoubleProperty progressProperty = this.util.progressProperty(this.webView.getScene());
            progressProperty.setValue(newValue);
        });
        this.locationListener = (observable, oldValue, newValue) -> this.urlField.setText(newValue);
        this.hyperlinkRedirectListener = new HyperlinkRedirectListener();
        this.historyListener = (observable, oldValue, newValue) -> {
            this.backward.setDisable(newValue.intValue() <= 0);
            this.forward.setDisable(newValue.intValue() + 1 >= this.engine.getHistory().getEntries().size());
        };
        this.convenience = new Convenience(this.util.getPlayer());
        this.engine = this.webView.getEngine();
        this.engine.getHistory().currentIndexProperty().addListener(this.historyListener);
        this.engine.locationProperty().addListener(this.locationListener);
        this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)this.hyperlinkRedirectListener);
        this.engine.getLoadWorker().progressProperty().addListener(this.progressListener);
        this.zoom.valueProperty().bindBidirectional((Property)this.util.getConfig().getOnlineSection().zoomProperty());
        this.zoom.valueProperty().addListener((observable, oldValue, newValue) -> this.webView.setZoom(newValue.doubleValue()));
        this.webView.setZoom(this.util.getConfig().getOnlineSection().getZoom());
        this.webView.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (this.isDownloading) {
                event.consume();
            }
        });
    }

    @Override
    public void doClose() {
        this.engine.getHistory().currentIndexProperty().removeListener(this.historyListener);
        this.engine.getLoadWorker().stateProperty().removeListener((ChangeListener)this.hyperlinkRedirectListener);
        this.engine.locationProperty().removeListener(this.locationListener);
        this.engine.getLoadWorker().progressProperty().removeListener(this.progressListener);
    }

    @FXML
    private void backward() {
        this.engine.getHistory().go(-1);
    }

    @FXML
    private void reload() {
        this.engine.reload();
    }

    @FXML
    private void home() {
        this.urlField.setText(this.type.getUrl());
        this.setUrl();
    }

    @FXML
    private void forward() {
        this.engine.getHistory().go(1);
    }

    @FXML
    private void setUrl() {
        this.engine.load(this.urlField.getText());
    }

    @FXML
    private void setShowTuneInfos() {
        this.showTuneInfos = this.showTuneInfoButton.isSelected();
    }

    private void showTuneInfos(SidTune sidTune, File tuneFile) {
        Platform.runLater(() -> {
            TuneInfos tuneInfos = new TuneInfos(this.util.getPlayer());
            tuneInfos.getStage().initModality(Modality.WINDOW_MODAL);
            tuneInfos.getStage().initOwner(this.urlField.getScene().getWindow());
            tuneInfos.open();
            tuneInfos.showTuneInfos(tuneFile, sidTune);
        });
    }

    public class HyperlinkRedirectListener
    implements ChangeListener<Worker.State> {
        private static final String IMG_TAG = "img";
        private static final String CLICK_EVENT = "click";
        private static final String ANCHOR_TAG = "a";

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            if (Worker.State.SUCCEEDED.equals((Object)newValue)) {
                Document document = WebView.this.webView.getEngine().getDocument();
                if (document == null) {
                    return;
                }
                NodeList anchors = document.getElementsByTagName(ANCHOR_TAG);
                for (int i = 0; i < anchors.getLength(); ++i) {
                    EventTarget eventTarget;
                    org.w3c.dom.Node node = anchors.item(i);
                    if (!(node instanceof EventTarget) || !(eventTarget = (EventTarget)((Object)node)).toString().matches("^(https?|ftp)://.*$") || eventTarget.toString().endsWith("#null")) continue;
                    eventTarget.addEventListener(CLICK_EVENT, new EventListener(){
                        private String href;

                        @Override
                        public void handleEvent(Event event) {
                            if (event.getCurrentTarget() instanceof HTMLAnchorElement) {
                                HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)event.getCurrentTarget());
                                this.href = anchorElement.getHref();
                                if (this.href == null) {
                                    return;
                                }
                                if (WebView.this.convenience.isSupportedMedia(new File(this.href))) {
                                    event.preventDefault();
                                }
                                Platform.runLater(() -> {
                                    try {
                                        new DownloadThread(WebView.this.util.getConfig(), new IDownloadListener(){

                                            @Override
                                            public void downloadStop(File downloadedFile) {
                                                try {
                                                    WebView.this.isDownloading = false;
                                                    Platform.runLater(() -> WebView.this.webView.setCursor(Cursor.DEFAULT));
                                                    if (downloadedFile != null) {
                                                        File targetDir = new File(WebView.this.util.getConfig().getSidplay2Section().getTmpDir(), UUID.randomUUID().toString());
                                                        File targetFile = new File(targetDir, downloadedFile.getName());
                                                        targetDir.mkdirs();
                                                        Files.move(Paths.get(downloadedFile.getAbsolutePath(), new String[0]), Paths.get(targetFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                                                        if (WebView.this.showTuneInfos && IOUtils.getFilenameSuffix(targetFile.getName()).equalsIgnoreCase(".sid")) {
                                                            WebView.this.showTuneInfos(WebView.this.util.getPlayer().getTune(), targetFile);
                                                        }
                                                        WebView.this.convenience.autostart(targetFile, Convenience.LEXICALLY_FIRST_MEDIA, null, true);
                                                        Platform.runLater(() -> WebView.this.util.setPlayingTab((Node)WebView.this, new ObjectProperty[0]));
                                                    }
                                                }
                                                catch (IOException | SidTuneError exception) {
                                                    // empty catch block
                                                }
                                            }

                                            @Override
                                            public void downloadStep(int step) {
                                                WebView.this.isDownloading = true;
                                                Platform.runLater(() -> {
                                                    WebView.this.webView.setCursor(Cursor.WAIT);
                                                    DoubleProperty progressProperty = WebView.this.util.progressProperty(WebView.this.webView.getScene());
                                                    progressProperty.setValue((Number)Float.valueOf((float)step / 100.0f));
                                                });
                                            }
                                        }, new URI(this.href).toURL(), false).start();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                });
                            }
                        }
                    }, false);
                }
                if (WebView.this.type == WebViewType.USERGUIDE) {
                    NodeList nodeList = document.getElementsByTagName(IMG_TAG);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        HTMLImageElement n = (HTMLImageElement)nodeList.item(i);
                        URL m = WebView.class.getResource(WebViewType.toAbsoluteUrl(n.getSrc()));
                        if (m == null) continue;
                        n.setSrc(m.toExternalForm());
                    }
                }
            }
        }
    }
}

