/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi;

import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import com.ftdi.utils.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataHandler.class);
    protected byte[] inputBuffer = new byte[2048];
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private AtomicBoolean receiverRunning = new AtomicBoolean();
    private BlockingQueue<byte[]> receiveQueue = new LinkedBlockingQueue<byte[]>();
    private AtomicLong receiveQueueWorkerThreadId = new AtomicLong();
    private String requestedPortName;
    private Thread receiveQueueWorker;
    private Thread receiverThread;
    private FTDevice device;

    protected abstract void createEventHandle();

    protected abstract void waitForNotificationEvent(FTDevice var1, int var2) throws FTD2XXException;

    protected abstract int readData(FTDevice var1) throws FTD2XXException;

    protected abstract void processMessages(byte[] var1);

    protected abstract void closeHandle();

    protected void configureDevice(FTDevice ftDevice) throws FTD2XXException {
    }

    protected Thread createReceiverThread() {
        return new ReceiverThread();
    }

    public void setFTDevice(FTDevice device) {
        this.device = device;
    }

    private FTDevice getFTDevice() {
        return this.device;
    }

    public void close() {
        if (this.device != null) {
            LOGGER.info("Close the port.");
            long start = System.currentTimeMillis();
            FTDevice portToClose = this.device;
            this.device = null;
            LOGGER.info("Set the receiver running flag to false.");
            this.receiverRunning.set(false);
            try {
                portToClose.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Close serial port failed.", (Throwable)ex);
            }
            this.stopReceiverThread();
            this.stopReceiveQueueWorker();
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
        } else {
            LOGGER.info("No port to close available.");
        }
    }

    protected void triggerClosePort() {
        LOGGER.warn("Close the port.");
        Thread worker = new Thread(() -> {
            LOGGER.info("Start close port because error was detected.");
            try {
                this.close();
            }
            catch (Exception ex) {
                LOGGER.warn("Close after error failed.", (Throwable)ex);
            }
            LOGGER.warn("The port was closed.");
        });
        worker.start();
    }

    public void startReceiverAndQueues() {
        LOGGER.info("Start receiver and queues.");
        if (this.receiverThread == null) {
            this.receiverThread = this.createReceiverThread();
        }
        this.receiverThread.start();
        this.startReceiveQueueWorker();
    }

    private void startReceiveQueueWorker() {
        this.receiverRunning.set(true);
        LOGGER.info("Start the receiveQueueWorker. Current receiveQueueWorker: {}", (Object)this.receiveQueueWorker);
        this.receiveQueueWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractDataHandler.this.processReceiveQueue();
                }
                catch (Exception ex) {
                    LOGGER.warn("The processing of the receive queue was terminated with an exception!", (Throwable)ex);
                }
                LOGGER.info("Process receive queue has finished.");
            }
        }, "receiveQueueWorker");
        try {
            this.receiveQueueWorkerThreadId.set(this.receiveQueueWorker.getId());
            this.receiveQueueWorker.start();
        }
        catch (Exception ex) {
            LOGGER.error("Start the receiveQueueWorker failed.", (Throwable)ex);
        }
        LOGGER.info("Start the receiveQueueWorker finished. Current receiveQueueWorker: {}", (Object)this.receiveQueueWorker);
    }

    private void stopReceiveQueueWorker() {
        LOGGER.info("Stop the receive queue worker.");
        this.receiverRunning.set(false);
        try {
            this.receiveQueueWorker.interrupt();
            this.receiveQueueWorker.join(1000L);
            LOGGER.info("receiveQueueWorker has finished.");
        }
        catch (Exception ex) {
            LOGGER.warn("Interrupt receiveQueueWorker failed.", (Throwable)ex);
        }
        this.receiveQueueWorker = null;
    }

    private void processReceiveQueue() {
        byte[] bytes = null;
        LOGGER.info("The receiveQueueWorker is ready for processing, requestedPortName: {}", (Object)this.requestedPortName);
        while (this.receiverRunning.get()) {
            try {
                bytes = this.receiveQueue.take();
                if (bytes == null) continue;
                try {
                    this.processMessages(bytes);
                }
                catch (Exception ex) {
                    LOGGER.warn("Process received bytes failed.", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Get message from receiveQueue failed because thread was interrupted.");
            }
            catch (Exception ex) {
                LOGGER.warn("Get message from receiveQueue failed.", (Throwable)ex);
                bytes = null;
            }
        }
        LOGGER.info("The receiveQueueWorker has finished processing, requestedPortName: {}", (Object)this.requestedPortName);
        this.receiveQueueWorkerThreadId.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiverThread() {
        LOGGER.info("Stop the receiver thread by set the running flag to false.");
        this.receiverRunning.set(false);
        if (this.receiverThread != null) {
            LOGGER.info("Wait for termination of receiver thread.");
            Thread thread = this.receiverThread;
            synchronized (thread) {
                this.closeHandle();
                try {
                    this.receiverThread.join(5000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for termination of receiver thread failed.", (Throwable)ex);
                }
            }
            LOGGER.info("Free the receiver thread.");
            this.receiverThread = null;
        }
    }

    private void addDataToReceiveQueue(ByteArrayOutputStream output) {
        boolean added;
        byte[] bytes = output.toByteArray();
        byte[] buffer = new byte[bytes.length];
        System.arraycopy(bytes, 0, buffer, 0, bytes.length);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("<<<< len: {}, data: {}, string: {}", new Object[]{bytes.length, ByteUtils.bytesToHex(buffer), new String(bytes)});
        }
        if (!(added = this.receiveQueue.offer(buffer))) {
            LOGGER.error("The message was not added to the receive queue: {}", (Object)ByteUtils.bytesToHex(buffer));
        }
        output.reset();
    }

    public class ReceiverThread
    extends Thread {
        public ReceiverThread() {
            super("FTDI-Receiver");
        }

        @Override
        public void run() {
            AbstractDataHandler.this.receiverRunning.set(true);
            Thread.currentThread().setPriority(4);
            FTDevice ftDevice = AbstractDataHandler.this.getFTDevice();
            try {
                AbstractDataHandler.this.configureDevice(ftDevice);
            }
            catch (FTD2XXException ex) {
                LOGGER.warn("Configure the device failed.", (Throwable)ex);
            }
            LOGGER.info("Started the receiver thread.");
            AbstractDataHandler.this.createEventHandle();
            int eventMask = 3;
            while (AbstractDataHandler.this.receiverRunning.get()) {
                try {
                    LOGGER.debug("Try to read data");
                    AbstractDataHandler.this.waitForNotificationEvent(ftDevice, eventMask);
                    int len = AbstractDataHandler.this.readData(ftDevice);
                    if (len < 0) {
                        boolean portClosed = !ftDevice.isOpen();
                        LOGGER.info("Port closed: {}", (Object)portClosed);
                        if (portClosed) {
                            LOGGER.info("The port is closed. Leave the receiver loop.");
                            AbstractDataHandler.this.receiverRunning.set(false);
                            continue;
                        }
                    }
                    if (len <= 0) continue;
                    AbstractDataHandler.this.output.write(AbstractDataHandler.this.inputBuffer, 0, len);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("<<<< len: {}, data: {}", (Object)AbstractDataHandler.this.output.size(), (Object)ByteUtils.bytesToHex(AbstractDataHandler.this.output.toByteArray()));
                    }
                    AbstractDataHandler.this.addDataToReceiveQueue(AbstractDataHandler.this.output);
                    if (AbstractDataHandler.this.output == null || AbstractDataHandler.this.output.size() <= 0) continue;
                    LOGGER.warn("Data in output: {}", (Object)AbstractDataHandler.this.output.toString());
                }
                catch (FTD2XXException ex) {
                    LOGGER.warn("Receive data failed with an exception!", (Throwable)ex);
                    AbstractDataHandler.this.receiverRunning.set(false);
                    if (ftDevice != null && !ftDevice.isOpen()) continue;
                    AbstractDataHandler.this.triggerClosePort();
                }
                catch (NullPointerException ex) {
                    LOGGER.error("Receive data failed with an NPE! The port might be closed.", (Throwable)ex);
                    AbstractDataHandler.this.receiverRunning.set(false);
                }
                catch (Exception ex) {
                    LOGGER.error("Message receiver returned from receive with an exception!", (Throwable)ex);
                }
            }
            AbstractDataHandler.this.closeHandle();
            LOGGER.info("Leaving receiver loop.");
        }
    }
}

