/*
 * Decompiled with CFR 0.152.
 */
package sidblaster;

import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sidblaster.ISIDBlaster;
import sidblaster.d2xx.D2XXDevice;

public class SIDBlaster
extends ISIDBlaster {
    private Integer SIDBLASTERUSB_WRITEBUFFER_SIZE = Integer.valueOf(System.getProperty("SIDBLASTERUSB_WRITEBUFFER_SIZE", String.valueOf(16)));
    private ByteBuffer buffer = ByteBuffer.allocate(this.SIDBLASTERUSB_WRITEBUFFER_SIZE != null ? this.SIDBLASTERUSB_WRITEBUFFER_SIZE : 16);
    private final FTDevice sid;

    public SIDBlaster(int deviceID, FTDevice device) {
        super(deviceID);
        this.sid = device;
    }

    @Override
    public int getWriteBufferSize() {
        return this.buffer.capacity();
    }

    @Override
    public void setWriteBufferSize(int size) {
        this.buffer = ByteBuffer.allocate(Math.max(0, Math.min(size, 256)));
    }

    @Override
    public void setLatencyTimer(short ms) throws FTD2XXException {
        D2XXDevice.setLatencyTimer(this.sid, ms);
    }

    @Override
    public void open() throws FTD2XXException {
        if (!this.sid.isOpen()) {
            D2XXDevice.open(this.sid);
            D2XXDevice.initialize(this.sid);
            if (!this.sid.isOpen()) {
                throw new RuntimeException("Failed to initialize SIDBlaster: " + this.toString());
            }
            this.flush();
        }
    }

    @Override
    public void close() throws FTD2XXException {
        if (this.sid.isOpen()) {
            this.reset();
            D2XXDevice.close(this.sid);
        }
    }

    @Override
    public void sync() throws FTD2XXException {
        this.softFlush();
    }

    @Override
    public byte read(byte reg) throws FTD2XXException {
        byte[] received;
        this.softFlush();
        D2XXDevice.send(this.sid, new byte[]{(byte)(reg | 0xA0)}, 1);
        while ((received = D2XXDevice.receive(this.sid)).length == 0) {
        }
        return received[0];
    }

    @Override
    public void mute(byte ch) throws FTD2XXException {
        this.softFlush();
        D2XXDevice.send(this.sid, new byte[]{(byte)(ch * 7 + 0 | 0xE0), 0, (byte)(ch * 7 + 1), 0});
    }

    @Override
    public void muteAll() throws FTD2XXException {
        this.softFlush();
        D2XXDevice.send(this.sid, new byte[]{-32, 0, -31, 0, -25, 0, -24, 0, -18, 0, -17, 0});
    }

    @Override
    public void reset() throws FTD2XXException {
        this.flush();
        this.sync();
        this.muteAll();
    }

    @Override
    public void write(byte reg, byte data) throws FTD2XXException {
        if (this.buffer.position() > 0) {
            this.softFlush();
        }
        D2XXDevice.send(this.sid, new byte[]{(byte)(reg | 0xE0), data});
    }

    @Override
    public void bufferWrite(byte reg, byte data) throws FTD2XXException {
        if (!this.buffer.hasRemaining()) {
            this.softFlush();
        }
        this.buffer.put(new byte[]{(byte)(reg | 0xE0), data});
    }

    @Override
    public void delay() {
    }

    @Override
    public void flush() {
        ((Buffer)this.buffer).clear();
    }

    @Override
    public void softFlush() throws FTD2XXException {
        D2XXDevice.send(this.sid, this.buffer.array(), this.buffer.position());
        ((Buffer)this.buffer).clear();
    }

    public String toString() {
        return this.sid.getDevSerialNumber();
    }
}

