/*
 * Decompiled with CFR 0.152.
 */
package sidblaster.async;

import com.ftdi.FTD2XXException;
import sidblaster.Command;
import sidblaster.CommandEnum;
import sidblaster.ICommandDispatcher;
import sidblaster.async.ThreadCommandReceiver;

public class AsyncDispatcher
implements ICommandDispatcher {
    private ThreadCommandReceiver receiver;
    private Thread sidWriteThread;
    private boolean isInitialized;

    @Override
    public int sendCommand(Command cmd) throws FTD2XXException, InterruptedException {
        this.ensureInitialized();
        int retval = 0;
        while (!this.sidWriteThread.isAlive()) {
            Thread.yield();
        }
        if (cmd.getCommand() == CommandEnum.Flush) {
            this.receiver.flush();
            while (!this.receiver.queueIsEmpty()) {
                Thread.yield();
            }
            return 0;
        }
        this.receiver.tryPutCommand(cmd);
        if (cmd.getCommand() == CommandEnum.Read) {
            while (!this.receiver.isReadResultReady()) {
                Thread.yield();
            }
            retval = this.receiver.readResult();
        }
        return retval;
    }

    @Override
    public void initialize() throws FTD2XXException {
        this.isInitialized = false;
    }

    public void ensureInitialized() throws FTD2XXException {
        if (!this.isInitialized) {
            assert (this.receiver == null);
            this.receiver = new ThreadCommandReceiver();
            this.sidWriteThread = new Thread(this.receiver);
            this.sidWriteThread.setDaemon(true);
            this.sidWriteThread.start();
            if (this.sidWriteThread.isAlive()) {
                while (!this.receiver.isDevicesAvailable()) {
                    Thread.yield();
                }
            }
            this.isInitialized = true;
        }
    }

    @Override
    public void uninitialize() throws FTD2XXException, InterruptedException {
        if (this.isInitialized) {
            this.receiver.setAbortSIDWriteThread();
            this.sidWriteThread.join();
            this.receiver.uninitialize();
            this.receiver = null;
            this.isInitialized = false;
        }
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public int deviceCount() throws FTD2XXException {
        this.ensureInitialized();
        return this.receiver.deviceCount();
    }

    @Override
    public void setWriteBufferSize(int bufferSize) {
        this.receiver.setWriteBufferSize(bufferSize);
    }

    @Override
    public void setLatencyTimer(short ms) throws FTD2XXException {
        this.receiver.setLatencyTimer(ms);
    }
}

