/*
 * Decompiled with CFR 0.152.
 */
package builder.jusbsid;

import builder.jusbsid.JUSBSIDBuilder;
import builder.resid.residfp.ReSIDfp;
import java.util.List;
import java.util.Objects;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.IEmulationSection;
import usbsid.USBSID;

public class USBSIDEmu
extends ReSIDfp {
    private final EventScheduler context;
    private final JUSBSIDBuilder jusbsidBuilder;
    private final Event event;
    private final USBSID usbsid;
    private final byte deviceID;
    private String deviceName;
    private int sidNum;
    private final ChipModel chipModel;
    private boolean[] voiceMute = new boolean[4];
    private boolean[] filterDisable = new boolean[3];

    public USBSIDEmu(JUSBSIDBuilder jusbsidBuilder, EventScheduler context, CPUClock cpuClock, USBSID usbsid, byte deviceId, int sidNum, ChipModel model, ChipModel defaultSidModel, boolean stereo) {
        super(context);
        this.jusbsidBuilder = jusbsidBuilder;
        this.context = context;
        this.usbsid = usbsid;
        this.deviceID = deviceId;
        this.sidNum = sidNum;
        this.chipModel = model;
        this.event = Event.of("USBSID Delay", event -> context.schedule((Event)event, jusbsidBuilder.eventuallyDelay(), Event.Phase.PHI2));
        super.setChipModel(model);
        super.setClockFrequency(cpuClock.getCpuFrequency());
        if (sidNum == 0) {
            // empty if block
        }
    }

    @Override
    public void write(int addr, byte data) {
        switch (addr & 0x1F) {
            case 4: 
            case 11: 
            case 18: {
                if (this.voiceMute[(addr - 4) / 7]) {
                    data = (byte)(data & 0xFE);
                }
                super.write(addr, data);
                break;
            }
            case 23: {
                if (this.filterDisable[this.sidNum]) {
                    data = (byte)(data & 0xF0);
                }
                super.write(addr, data);
                break;
            }
            case 24: {
                if (this.voiceMute[3] && (data & 0xF) < (this.readInternalRegister(addr) & 0xF)) {
                    return;
                }
                super.write(addr, data);
                break;
            }
            default: {
                super.write(addr, data);
            }
        }
        byte dataByte = data;
        if (addr > 24) {
            return;
        }
        this.doWriteDelayed(() -> {
            if (!Objects.equals(this.jusbsidBuilder.lastSidNum, this.sidNum)) {
                this.jusbsidBuilder.lastSidNum = this.sidNum;
            }
            this.usbsid.USBSID_clkdwrite(0L, (byte)addr, dataByte);
        });
    }

    @Override
    public void clock() {
        super.clock();
        short clocksSinceLastAccess = (short)this.jusbsidBuilder.clocksSinceLastAccess();
    }

    private void doWriteDelayed(Runnable runnable) {
        if (this.jusbsidBuilder.getDelay(this.sidNum) > 0) {
            this.context.schedule(Event.of("Delayed SID output", event -> runnable.run()), this.jusbsidBuilder.getDelay(this.sidNum));
        } else {
            runnable.run();
        }
    }

    protected boolean lock() {
        this.usbsid.USBSID_reset((byte)15);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.reset((byte)15);
        this.context.schedule(this.event, 0L, Event.Phase.PHI2);
        return true;
    }

    protected void unlock() {
        this.usbsid.USBSID_reset((byte)0);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.reset((byte)0);
        this.context.cancel(this.event);
    }

    @Override
    public void setVoiceMute(int num, boolean mute) {
        super.setVoiceMute(num, mute);
        if (num < 4) {
            this.voiceMute[num] = mute;
        }
    }

    @Override
    public void setFilterEnable(IEmulationSection emulation, int sidNum) {
        super.setFilterEnable(emulation, sidNum);
        this.filterDisable[sidNum] = !emulation.isFilterEnable(sidNum);
    }

    public byte getDeviceId() {
        return this.deviceID;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    protected ChipModel getChipModel() {
        return this.chipModel;
    }

    public static final String credits() {
        StringBuffer credits = new StringBuffer();
        credits.append("USBSID Java version by Ken H\u00e4ndel <kschwiersch@yahoo.de> Copyright (\u00a9) 2021\n");
        credits.append("\tHardware and driver code by Thibaut Thezan\n");
        credits.append("\thttp://hacks.slashdirt.org/hw/exsid/\n");
        return credits.toString();
    }

    public static class FakeStereo
    extends USBSIDEmu {
        private final IEmulationSection emulationSection;
        private final int prevNum;
        private final List<USBSIDEmu> sids;

        public FakeStereo(JUSBSIDBuilder jusbsidBuilder, EventScheduler context, CPUClock cpuClock, USBSID hardSID, byte deviceId, int sidNum, ChipModel model, ChipModel defaultChipModel, boolean stereo, List<USBSIDEmu> sids, IEmulationSection emulationSection) {
            super(jusbsidBuilder, context, cpuClock, hardSID, deviceId, sidNum, model, defaultChipModel, stereo);
            this.prevNum = sidNum - 1;
            this.sids = sids;
            this.emulationSection = emulationSection;
        }

        @Override
        public byte read(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).read(addr);
            }
            return super.read(addr);
        }

        @Override
        public byte readInternalRegister(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).readInternalRegister(addr);
            }
            return super.readInternalRegister(addr);
        }

        @Override
        public void write(int addr, byte data) {
            super.write(addr, data);
            this.sids.get(this.prevNum).write(addr, data);
        }
    }
}

