/*
 * Decompiled with CFR 0.152.
 */
package builder.resid;

import builder.resid.ReSIDBase;
import builder.resid.SIDMixer;
import builder.resid.resid.ReSID;
import builder.resid.residfp.ReSIDfp;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.EventScheduler;
import libsidplay.common.SIDBuilder;
import libsidplay.common.SIDEmu;
import libsidplay.components.cart.Cartridge;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;

public class ReSIDBuilder
extends SIDMixer
implements SIDBuilder {
    public ReSIDBuilder(EventScheduler context, IConfig config, CPUClock cpuClock, Cartridge cart) {
        super(context, config, cpuClock, cart);
    }

    @Override
    public SIDEmu lock(SIDEmu oldSIDEmu, int sidNum, SidTune tune) {
        ReSIDBase sid = this.getOrCreateSID(oldSIDEmu, tune, sidNum);
        IEmulationSection emulationSection = this.config.getEmulationSection();
        sid.setChipModel(ChipModel.getChipModel(emulationSection, tune, sidNum));
        sid.setClockFrequency(this.cpuClock.getCpuFrequency());
        sid.setFilter(this.config, sidNum);
        sid.setFilterEnable(emulationSection, sidNum);
        sid.setDigiBoost(emulationSection.isDigiBoosted8580());
        for (int voice = 0; voice < 4; ++voice) {
            sid.setVoiceMute(voice, emulationSection.isMuteVoice(sidNum, voice));
        }
        for (int i = 0; oldSIDEmu != null && !oldSIDEmu.equals(sid) && i < 32; ++i) {
            sid.write(i, oldSIDEmu.readInternalRegister(i));
        }
        this.add(sidNum, sid);
        return sid;
    }

    @Override
    public void unlock(SIDEmu sid) {
        this.remove((ReSIDBase)sid);
    }

    private ReSIDBase getOrCreateSID(SIDEmu oldSIDEmu, SidTune tune, int sidNum) {
        IEmulationSection emulationSection = this.config.getEmulationSection();
        Emulation emulation = Emulation.getEmulation(emulationSection, sidNum);
        boolean fakeStereo = SidTune.isFakeStereoSid(emulationSection, tune, sidNum);
        Class<? extends ReSIDBase> sidImplClass = this.getSIDImplClass(emulation, fakeStereo);
        if (oldSIDEmu != null && oldSIDEmu.getClass().equals(sidImplClass)) {
            return (ReSIDBase)oldSIDEmu;
        }
        return this.createSID(sidImplClass, sidNum);
    }

    private Class<? extends ReSIDBase> getSIDImplClass(Emulation emulation, boolean fakeStereo) {
        switch (emulation) {
            case RESID: {
                return fakeStereo ? ReSID.FakeStereo.class : ReSID.class;
            }
            case RESIDFP: {
                return fakeStereo ? ReSIDfp.FakeStereo.class : ReSIDfp.class;
            }
        }
        throw new RuntimeException("Unknown SID emulation: " + (Object)((Object)emulation));
    }

    private ReSIDBase createSID(Class<? extends ReSIDBase> sidImplCls, int sidNum) {
        if (ReSID.class.equals(sidImplCls)) {
            return new ReSID(this.context);
        }
        if (ReSIDfp.class.equals(sidImplCls)) {
            return new ReSIDfp(this.context);
        }
        if (ReSID.FakeStereo.class.equals(sidImplCls)) {
            return new ReSID.FakeStereo(this.context, this.config, sidNum - 1, this.sids);
        }
        if (ReSIDfp.FakeStereo.class.equals(sidImplCls)) {
            return new ReSIDfp.FakeStereo(this.context, this.config, sidNum - 1, this.sids);
        }
        throw new RuntimeException("Unknown SID impl.: " + sidImplCls);
    }
}

