/*
 * Decompiled with CFR 0.152.
 */
package builder.resid;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.function.IntConsumer;

public interface SampleMixer
extends IntConsumer {
    public void setVolume(int var1, int var2);

    public void setDelay(int var1);

    public void clear();

    public static class NoOpSampleMixer
    implements SampleMixer {
        @Override
        public void setVolume(int volumeL, int volumeR) {
        }

        @Override
        public void setDelay(int delayedSamples) {
        }

        @Override
        public void accept(int sample) {
        }

        @Override
        public void clear() {
        }
    }

    public static class DefaultSampleMixer
    implements SampleMixer {
        private IntBuffer bufferL;
        private IntBuffer bufferR;
        protected int volumeL;
        protected int volumeR;
        private IntBuffer delayedSamples;
        private boolean delayedSamplesEnabled;

        DefaultSampleMixer(IntBuffer audioBufferL, IntBuffer audioBufferR) {
            this.bufferL = audioBufferL;
            this.bufferR = audioBufferR;
            this.delayedSamplesEnabled = false;
            this.setVolume(1024, 1024);
            this.setDelay(0);
        }

        @Override
        public void setVolume(int volumeL, int volumeR) {
            this.volumeL = volumeL;
            this.volumeR = volumeR;
        }

        @Override
        public void setDelay(int delayedSamples) {
            this.delayedSamplesEnabled = delayedSamples != 0;
            this.delayedSamples = ByteBuffer.allocateDirect(4 * (delayedSamples + 1)).order(ByteOrder.nativeOrder()).asIntBuffer().put(new int[delayedSamples + 1]);
            ((Buffer)this.delayedSamples).flip();
        }

        @Override
        public void accept(int sample) {
            if (this.delayedSamplesEnabled) {
                if (!this.delayedSamples.put(sample).hasRemaining()) {
                    ((Buffer)this.delayedSamples).flip();
                }
                sample = this.delayedSamples.get(this.delayedSamples.position());
            }
            this.bufferL.put(this.bufferL.get(this.bufferL.position()) + sample * this.volumeL);
            this.bufferR.put(this.bufferR.get(this.bufferR.position()) + sample * this.volumeR);
        }

        @Override
        public void clear() {
            ((Buffer)this.bufferL).clear();
            ((Buffer)this.bufferR).clear();
        }
    }

    public static class LinearFadingSampleMixer
    extends DefaultSampleMixer {
        private long fadeInClocks;
        private long fadeOutClocks;
        private int maxVolL;
        private int maxVolR;
        private long fadeInStepL;
        private long fadeInStepR;
        private long fadeOutStepL;
        private long fadeOutStepR;
        private long fadeInValL;
        private long fadeInValR;
        private long fadeOutValL;
        private long fadeOutValR;

        LinearFadingSampleMixer(IntBuffer audioBufferL, IntBuffer audioBufferR) {
            super(audioBufferL, audioBufferR);
        }

        public void setFadeIn(long fadeIn) {
            this.fadeInClocks = fadeIn;
            super.setVolume(0, 0);
            this.fadeInStepL = this.maxVolL != 0 ? this.fadeInClocks / (long)this.maxVolL : 0L;
            this.fadeInValL = this.fadeInStepL;
            this.fadeInStepR = this.maxVolR != 0 ? this.fadeInClocks / (long)this.maxVolR : 0L;
            this.fadeInValR = this.fadeInStepR;
        }

        public void setFadeOut(long fadeOut) {
            this.fadeOutClocks = fadeOut;
            super.setVolume(this.maxVolL, this.maxVolR);
            this.fadeOutStepL = this.maxVolL != 0 ? this.fadeOutClocks / (long)this.maxVolL : 0L;
            this.fadeOutValL = this.fadeOutStepL;
            this.fadeOutStepR = this.maxVolR != 0 ? this.fadeOutClocks / (long)this.maxVolR : 0L;
            this.fadeOutValR = this.fadeOutStepR;
        }

        @Override
        public void setVolume(int volumeL, int volumeR) {
            super.setVolume(volumeL, volumeR);
            this.maxVolL = volumeL;
            this.maxVolR = volumeR;
        }

        @Override
        public void accept(int sample) {
            if (this.fadeInClocks > 0L) {
                --this.fadeInClocks;
                if (--this.fadeInValL == 0L) {
                    this.fadeInValL = this.fadeInStepL;
                    ++this.volumeL;
                }
                if (--this.fadeInValR == 0L) {
                    this.fadeInValR = this.fadeInStepR;
                    ++this.volumeR;
                }
            } else if (this.fadeOutClocks > 0L) {
                --this.fadeOutClocks;
                if (--this.fadeOutValL == 0L) {
                    this.fadeOutValL = this.fadeOutStepL;
                    --this.volumeL;
                }
                if (--this.fadeOutValR == 0L) {
                    this.fadeOutValR = this.fadeOutStepR;
                    --this.volumeR;
                }
            }
            super.accept(sample);
        }
    }
}

