/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.c;

import client.teavm.common.IImportedApi;
import java.io.DataOutputStream;
import java.io.IOException;
import libsidplay.components.printer.IPaper;

public class ImportedApi
implements IImportedApi {
    private DataOutputStream out;

    public ImportedApi(DataOutputStream out, int sampleRate, int numSamples) {
        try {
            this.out = out;
            int numChannels = 2;
            int bitsPerSample = 16;
            int byteRate = sampleRate * numChannels * bitsPerSample / 8;
            int blockAlign = numChannels * bitsPerSample / 8;
            int dataSize = numSamples * blockAlign;
            out.writeBytes("RIFF");
            out.writeInt(Integer.reverseBytes(36 + dataSize));
            out.writeBytes("WAVE");
            out.writeBytes("fmt ");
            out.writeInt(Integer.reverseBytes(16));
            out.writeShort(Short.reverseBytes((short)1));
            out.writeShort(Short.reverseBytes((short)numChannels));
            out.writeInt(Integer.reverseBytes(sampleRate));
            out.writeInt(Integer.reverseBytes(byteRate));
            out.writeShort(Short.reverseBytes((short)blockAlign));
            out.writeShort(Short.reverseBytes((short)bitsPerSample));
            out.writeBytes("data");
            out.writeInt(Integer.reverseBytes(dataSize));
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing WAV audio stream", e);
        }
    }

    @Override
    public void processSamples(float[] resultL, float[] resultR) {
        try {
            for (int i = 0; i < resultL.length; ++i) {
                this.out.writeShort(Short.reverseBytes(this.floatToPCM16(resultL[i])));
                this.out.writeShort(Short.reverseBytes(this.floatToPCM16(resultR[i])));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing WAV audio stream", e);
        }
    }

    private short floatToPCM16(float sample) {
        return (short)(sample < 0.0f ? (double)sample * 32768.0 : (double)sample * 32767.0);
    }

    @Override
    public void processPixels(byte[] array) {
    }

    @Override
    public void processSidWrite(long absTime, int relTime, int addr, int value) {
    }

    @Override
    public void processTimerEnd(double end) {
    }

    @Override
    public void processPrinter(IPaper.Outputs output) {
    }

    @Override
    public void whatsSid(byte[] array) {
    }
}

