/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.compiletime;

import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.Value;

@CompileTime
public class LookupTableTeaVM {
    @Meta
    public static native String getLookupTable(boolean var0);

    private static void getLookupTable(Value<Boolean> b) {
        double[] looupTable = IntStream.range(Short.MIN_VALUE, 32768).mapToDouble(i -> i < 0 ? (double)i / 32768.0 : (double)i / 32767.0).toArray();
        String audioLookupTable = DoubleStream.of(looupTable).mapToObj(f -> String.format(Locale.US, "%f", f)).collect(Collectors.joining(","));
        Value lookupTableValue = Metaprogramming.emit(() -> audioLookupTable);
        Metaprogramming.exit(() -> lookupTableValue.get());
    }
}

