/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.common;

import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;

public enum ChipModel {
    AUTO,
    MOS6581,
    MOS8580;


    public static ChipModel getChipModel(IEmulationSection emulation, SidTune tune, int sidNum) {
        ChipModel defaultSidModel;
        SidTune.Model tuneSidModel;
        ChipModel forcedChipModel = emulation.getForcedSidModel(sidNum);
        ChipModel overrideSidModel = emulation.getOverrideSection().getSidModel()[sidNum];
        switch (sidNum) {
            case 0: {
                tuneSidModel = tune != SidTune.RESET ? tune.getInfo().getSIDModel(0) : SidTune.Model.UNKNOWN;
                defaultSidModel = emulation.getDefaultSidModel();
                break;
            }
            case 1: {
                tuneSidModel = tune != SidTune.RESET ? tune.getInfo().getSIDModel(1) : SidTune.Model.UNKNOWN;
                defaultSidModel = ChipModel.getChipModel(emulation, tune, 0);
                break;
            }
            case 2: {
                tuneSidModel = tune != SidTune.RESET ? tune.getInfo().getSIDModel(2) : SidTune.Model.UNKNOWN;
                defaultSidModel = ChipModel.getChipModel(emulation, tune, 0);
                break;
            }
            default: {
                throw new RuntimeException("Maximum supported SIDS exceeded!");
            }
        }
        if (forcedChipModel != AUTO) {
            return forcedChipModel;
        }
        if (overrideSidModel != null) {
            return overrideSidModel;
        }
        switch (tuneSidModel) {
            case MOS6581: 
            case MOS8580: {
                return tuneSidModel.asChipModel();
            }
        }
        return defaultSidModel;
    }
}

