/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.cart.supported.core.OPL3;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;
import sidplay.audio.processors.AudioProcessor;

public class SFXSoundExpanderOPL3
extends Cartridge
implements AudioProcessor {
    private OPL3 opl3;
    private final Bank io2Bank = new Bank(){
        private int address;

        @Override
        public byte read(int address) {
            return SFXSoundExpanderOPL3.this.pla.getDisconnectedBusBank().read(address);
        }

        @Override
        public void write(int addr, byte val) {
            if ((addr &= 0xFF) == 64) {
                this.address = val & 0xFF;
            } else if (addr == 80) {
                SFXSoundExpanderOPL3.this.opl3.write(0, this.address, val & 0xFF);
            }
        }
    };

    public SFXSoundExpanderOPL3(DataInputStream dis, PLA pla, int sizeKB) {
        super(pla);
    }

    @Override
    public Bank getIO2() {
        return this.io2Bank;
    }

    @Override
    public void reset() {
        super.reset();
        this.pla.setGameExrom(true, true);
        this.opl3 = new OPL3();
    }

    @Override
    public void process(ByteBuffer sampleBuffer) {
        int len = sampleBuffer.position();
        ((Buffer)sampleBuffer).flip();
        ByteBuffer buffer = ByteBuffer.wrap(new byte[len]).order(sampleBuffer.order());
        for (int i = 0; i < len >> 2; ++i) {
            short[] shortsLeft = this.opl3.read();
            buffer.putShort((short)((shortsLeft[0] + shortsLeft[1] + shortsLeft[2] + shortsLeft[3]) / 2 + sampleBuffer.getShort()));
            shortsLeft = this.opl3.read();
            buffer.putShort((short)((shortsLeft[0] + shortsLeft[1] + shortsLeft[2] + shortsLeft[3]) / 2 + sampleBuffer.getShort()));
        }
        ((Buffer)sampleBuffer).flip();
        ((Buffer)buffer).flip();
        sampleBuffer.put(buffer);
    }

    @Override
    public boolean isCreatingSamples() {
        return true;
    }
}

