/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import libsidplay.components.cart.supported.core.OPL3;

abstract class Channel {
    int channelBaseAddress;
    double[] feedback;
    int fnuml;
    int fnumh;
    int kon;
    int block;
    int cha;
    int chb;
    int chc;
    int chd;
    int fb;
    int cnt;
    static final double toPhase = 4.0;

    Channel(int baseAddress) {
        this.channelBaseAddress = baseAddress;
        this.cnt = 0;
        this.fb = 0;
        this.chd = 0;
        this.chc = 0;
        this.chb = 0;
        this.cha = 0;
        this.block = 0;
        this.kon = 0;
        this.fnumh = 0;
        this.fnuml = 0;
        this.feedback = new double[2];
        this.feedback[1] = 0.0;
        this.feedback[0] = 0.0;
    }

    void update_2_KON1_BLOCK3_FNUMH2() {
        int _2_kon1_block3_fnumh2 = OPL3.registers[this.channelBaseAddress + 176];
        this.block = (_2_kon1_block3_fnumh2 & 0x1C) >> 2;
        this.fnumh = _2_kon1_block3_fnumh2 & 3;
        this.updateOperators();
        int newKon = (_2_kon1_block3_fnumh2 & 0x20) >> 5;
        if (newKon != this.kon) {
            if (newKon == 1) {
                this.keyOn();
            } else {
                this.keyOff();
            }
            this.kon = newKon;
        }
    }

    void update_FNUML8() {
        int fnuml8 = OPL3.registers[this.channelBaseAddress + 160];
        this.fnuml = fnuml8 & 0xFF;
        this.updateOperators();
    }

    void update_CHD1_CHC1_CHB1_CHA1_FB3_CNT1() {
        int chd1_chc1_chb1_cha1_fb3_cnt1 = OPL3.registers[this.channelBaseAddress + 192];
        this.chd = (chd1_chc1_chb1_cha1_fb3_cnt1 & 0x80) >> 7;
        this.chc = (chd1_chc1_chb1_cha1_fb3_cnt1 & 0x40) >> 6;
        this.chb = (chd1_chc1_chb1_cha1_fb3_cnt1 & 0x20) >> 5;
        this.cha = (chd1_chc1_chb1_cha1_fb3_cnt1 & 0x10) >> 4;
        this.fb = (chd1_chc1_chb1_cha1_fb3_cnt1 & 0xE) >> 1;
        this.cnt = chd1_chc1_chb1_cha1_fb3_cnt1 & 1;
        this.updateOperators();
    }

    void updateChannel() {
        this.update_2_KON1_BLOCK3_FNUMH2();
        this.update_FNUML8();
        this.update_CHD1_CHC1_CHB1_CHA1_FB3_CNT1();
    }

    protected double[] getInFourChannels(double channelOutput) {
        double[] output = new double[4];
        if (OPL3._new == 0) {
            output[2] = output[3] = channelOutput;
            output[1] = output[3];
            output[0] = output[3];
        } else {
            output[0] = this.cha == 1 ? channelOutput : 0.0;
            output[1] = this.chb == 1 ? channelOutput : 0.0;
            output[2] = this.chc == 1 ? channelOutput : 0.0;
            output[3] = this.chd == 1 ? channelOutput : 0.0;
        }
        return output;
    }

    abstract double[] getChannelOutput();

    protected abstract void keyOn();

    protected abstract void keyOff();

    protected abstract void updateOperators();
}

