/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import libsidplay.components.cart.supported.core.Channel;
import libsidplay.components.cart.supported.core.ChannelData;
import libsidplay.components.cart.supported.core.EnvelopeGenerator;
import libsidplay.components.cart.supported.core.OPL3;
import libsidplay.components.cart.supported.core.Operator;

class Channel4op
extends Channel {
    Operator op1;
    Operator op2;
    Operator op3;
    Operator op4;

    Channel4op(int baseAddress, Operator o1, Operator o2, Operator o3, Operator o4) {
        super(baseAddress);
        this.op1 = o1;
        this.op2 = o2;
        this.op3 = o3;
        this.op4 = o4;
    }

    @Override
    double[] getChannelOutput() {
        double channelOutput = 0.0;
        double op1Output = 0.0;
        double op2Output = 0.0;
        double op3Output = 0.0;
        double op4Output = 0.0;
        int secondChannelBaseAddress = this.channelBaseAddress + 3;
        int secondCnt = OPL3.registers[secondChannelBaseAddress + 192] & 1;
        int cnt4op = this.cnt << 1 | secondCnt;
        double feedbackOutput = (this.feedback[0] + this.feedback[1]) / 2.0;
        switch (cnt4op) {
            case 0: {
                if (this.op4.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF) {
                    return this.getInFourChannels(0.0);
                }
                op1Output = this.op1.getOperatorOutput(feedbackOutput);
                op2Output = this.op2.getOperatorOutput(op1Output * 4.0);
                op3Output = this.op3.getOperatorOutput(op2Output * 4.0);
                channelOutput = this.op4.getOperatorOutput(op3Output * 4.0);
                break;
            }
            case 1: {
                if (this.op2.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF && this.op4.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF) {
                    return this.getInFourChannels(0.0);
                }
                op1Output = this.op1.getOperatorOutput(feedbackOutput);
                op2Output = this.op2.getOperatorOutput(op1Output * 4.0);
                op3Output = this.op3.getOperatorOutput(0.0);
                op4Output = this.op4.getOperatorOutput(op3Output * 4.0);
                channelOutput = (op2Output + op4Output) / 2.0;
                break;
            }
            case 2: {
                if (this.op1.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF && this.op4.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF) {
                    return this.getInFourChannels(0.0);
                }
                op1Output = this.op1.getOperatorOutput(feedbackOutput);
                op2Output = this.op2.getOperatorOutput(0.0);
                op3Output = this.op3.getOperatorOutput(op2Output * 4.0);
                op4Output = this.op4.getOperatorOutput(op3Output * 4.0);
                channelOutput = (op1Output + op4Output) / 2.0;
                break;
            }
            case 3: {
                if (this.op1.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF && this.op3.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF && this.op4.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF) {
                    return this.getInFourChannels(0.0);
                }
                op1Output = this.op1.getOperatorOutput(feedbackOutput);
                op2Output = this.op2.getOperatorOutput(0.0);
                op3Output = this.op3.getOperatorOutput(op2Output * 4.0);
                op4Output = this.op4.getOperatorOutput(0.0);
                channelOutput = (op1Output + op3Output + op4Output) / 3.0;
            }
        }
        this.feedback[0] = this.feedback[1];
        this.feedback[1] = op1Output * ChannelData.feedback[this.fb] % 1.0;
        double[] output = this.getInFourChannels(channelOutput);
        return output;
    }

    @Override
    protected void keyOn() {
        this.op1.keyOn();
        this.op2.keyOn();
        this.op3.keyOn();
        this.op4.keyOn();
        this.feedback[1] = 0.0;
        this.feedback[0] = 0.0;
    }

    @Override
    protected void keyOff() {
        this.op1.keyOff();
        this.op2.keyOff();
        this.op3.keyOff();
        this.op4.keyOff();
    }

    @Override
    protected void updateOperators() {
        int keyScaleNumber = this.block * 2 + (this.fnumh >> OPL3.nts & 1);
        int f_number = this.fnumh << 8 | this.fnuml;
        this.op1.updateOperator(keyScaleNumber, f_number, this.block);
        this.op2.updateOperator(keyScaleNumber, f_number, this.block);
        this.op3.updateOperator(keyScaleNumber, f_number, this.block);
        this.op4.updateOperator(keyScaleNumber, f_number, this.block);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        int f_number = (this.fnumh << 8) + this.fnuml;
        str.append(String.format("channelBaseAddress: %d\n", this.channelBaseAddress));
        str.append(String.format("f_number: %d, block: %d\n", f_number, this.block));
        str.append(String.format("cnt: %d, feedback: %d\n", this.cnt, this.fb));
        str.append(String.format("op1:\n%s", this.op1.toString()));
        str.append(String.format("op2:\n%s", this.op2.toString()));
        str.append(String.format("op3:\n%s", this.op3.toString()));
        str.append(String.format("op4:\n%s", this.op4.toString()));
        return str.toString();
    }
}

