/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

class OPL3Data {
    static final int _1_NTS1_6_Offset = 8;
    static final int DAM1_DVB1_RYT1_BD1_SD1_TOM1_TC1_HH1_Offset = 189;
    static final int _7_NEW1_Offset = 261;
    static final int _2_CONNECTIONSEL6_Offset = 260;
    static final double sampleRate = 49700.0;
    static double[][] vibratoTable;
    static double[][] tremoloTable;

    OPL3Data() {
    }

    private static void loadVibratoTable() {
        int i;
        vibratoTable = new double[2][8192];
        double semitone = Math.pow(2.0, 0.08333333333333333);
        double cent = Math.pow(semitone, 0.01);
        double DVB0 = Math.pow(cent, 7.0);
        double DVB1 = Math.pow(cent, 14.0);
        for (i = 0; i < 1024; ++i) {
            OPL3Data.vibratoTable[1][i] = 1.0;
            OPL3Data.vibratoTable[0][i] = 1.0;
        }
        while (i < 2048) {
            OPL3Data.vibratoTable[0][i] = Math.sqrt(DVB0);
            OPL3Data.vibratoTable[1][i] = Math.sqrt(DVB1);
            ++i;
        }
        while (i < 3072) {
            OPL3Data.vibratoTable[0][i] = DVB0;
            OPL3Data.vibratoTable[1][i] = DVB1;
            ++i;
        }
        while (i < 4096) {
            OPL3Data.vibratoTable[0][i] = Math.sqrt(DVB0);
            OPL3Data.vibratoTable[1][i] = Math.sqrt(DVB1);
            ++i;
        }
        while (i < 5120) {
            OPL3Data.vibratoTable[1][i] = 1.0;
            OPL3Data.vibratoTable[0][i] = 1.0;
            ++i;
        }
        while (i < 6144) {
            OPL3Data.vibratoTable[0][i] = 1.0 / Math.sqrt(DVB0);
            OPL3Data.vibratoTable[1][i] = 1.0 / Math.sqrt(DVB1);
            ++i;
        }
        while (i < 7168) {
            OPL3Data.vibratoTable[0][i] = 1.0 / DVB0;
            OPL3Data.vibratoTable[1][i] = 1.0 / DVB1;
            ++i;
        }
        while (i < 8192) {
            OPL3Data.vibratoTable[0][i] = 1.0 / Math.sqrt(DVB0);
            OPL3Data.vibratoTable[1][i] = 1.0 / Math.sqrt(DVB1);
            ++i;
        }
    }

    private static void loadTremoloTable() {
        double tremoloFrequency = 3.7;
        double[] tremoloDepth = new double[]{-1.0, -4.8};
        double[] tremoloIncrement = new double[]{OPL3Data.calculateIncrement(tremoloDepth[0], 0.0, 0.13513513513513511), OPL3Data.calculateIncrement(tremoloDepth[1], 0.0, 0.13513513513513511)};
        int tremoloTableLength = 13432;
        tremoloTable = new double[2][tremoloTableLength];
        OPL3Data.tremoloTable[0][0] = tremoloDepth[0];
        OPL3Data.tremoloTable[1][0] = tremoloDepth[1];
        int counter = 0;
        while (tremoloTable[0][counter] < 0.0) {
            OPL3Data.tremoloTable[0][++counter] = tremoloTable[0][counter - 1] + tremoloIncrement[0];
            OPL3Data.tremoloTable[1][counter] = tremoloTable[1][counter - 1] + tremoloIncrement[1];
        }
        while (tremoloTable[0][counter] > tremoloDepth[0] && counter < tremoloTableLength - 1) {
            OPL3Data.tremoloTable[0][++counter] = tremoloTable[0][counter - 1] - tremoloIncrement[0];
            OPL3Data.tremoloTable[1][counter] = tremoloTable[1][counter - 1] - tremoloIncrement[1];
        }
    }

    static double calculateIncrement(double begin, double end, double period) {
        return (end - begin) / 49700.0 * (1.0 / period);
    }

    static {
        OPL3Data.loadVibratoTable();
        OPL3Data.loadTremoloTable();
    }
}

