/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import libsidplay.components.cart.supported.core.OPL3;
import libsidplay.components.cart.supported.core.OPL3Data;
import libsidplay.components.cart.supported.core.OperatorData;

class PhaseGenerator {
    double phase = 0.0;
    double phaseIncrement = 0.0;

    PhaseGenerator() {
    }

    void setFrequency(int f_number, int block, int mult) {
        double baseFrequency = (double)f_number * Math.pow(2.0, block - 1) * 49700.0 / Math.pow(2.0, 19.0);
        double operatorFrequency = baseFrequency * OperatorData.multTable[mult];
        this.phaseIncrement = operatorFrequency / 49700.0;
    }

    double getPhase(int vib) {
        this.phase = vib == 1 ? (this.phase += this.phaseIncrement * OPL3Data.vibratoTable[OPL3.dvb][OPL3.vibratoIndex]) : (this.phase += this.phaseIncrement);
        this.phase %= 1.0;
        return this.phase;
    }

    void keyOn() {
        this.phase = 0.0;
    }

    public String toString() {
        return String.format("Operator frequency: %f Hz.\n", 49700.0 * this.phaseIncrement);
    }
}

