/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import libsidplay.components.cart.supported.core.EnvelopeGenerator;
import libsidplay.components.cart.supported.core.OPL3;
import libsidplay.components.cart.supported.core.Operator;
import libsidplay.components.cart.supported.core.OperatorData;

class SnareDrumOperator
extends Operator {
    static final int snareDrumOperatorBaseAddress = 20;

    SnareDrumOperator() {
        super(20);
    }

    @Override
    double getOperatorOutput(double modulator) {
        if (this.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF) {
            return 0.0;
        }
        double envelopeInDB = this.envelopeGenerator.getEnvelope(this.egt, this.am);
        this.envelope = Math.pow(10.0, envelopeInDB / 10.0);
        int waveIndex = this.ws & (OPL3._new << 2) + 3;
        double[] waveform = OperatorData.waveforms[waveIndex];
        this.phase = OPL3.highHatOperator.phase * 2.0;
        double operatorOutput = this.getOutput(modulator, this.phase, waveform);
        double noise = Math.random() * this.envelope;
        if (operatorOutput / this.envelope != 1.0 && operatorOutput / this.envelope != -1.0) {
            operatorOutput = operatorOutput > 0.0 ? noise : (operatorOutput < 0.0 ? -noise : 0.0);
        }
        return operatorOutput * 2.0;
    }
}

