/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.sidtune;

import java.util.ArrayList;
import java.util.Collection;
import libsidplay.sidtune.SidTune;

public class SidTuneInfo {
    protected int loadAddr;
    protected int initAddr;
    protected int playAddr;
    protected int songs = 1;
    protected int startSong = 1;
    protected int currentSong;
    protected int[] sidChipBase = new int[3];
    protected SidTune.Model[] sidModel = new SidTune.Model[3];
    protected short relocStartPage;
    protected short relocPages;
    protected SidTune.Clock clockSpeed = SidTune.Clock.UNKNOWN;
    protected SidTune.Compatibility compatibility = SidTune.Compatibility.RSID_BASIC;
    protected Collection<String> infoString = new ArrayList<String>();
    protected Collection<String> commentString = new ArrayList<String>();
    protected int c64dataLen;
    protected int determinedDriverAddr;
    protected int determinedDriverLength;

    public SidTuneInfo() {
        this.sidChipBase[0] = 54272;
        for (int i = 0; i < this.sidModel.length; ++i) {
            this.sidModel[i] = SidTune.Model.UNKNOWN;
        }
    }

    public final int getLoadAddr() {
        return this.loadAddr;
    }

    public final int getInitAddr() {
        return this.initAddr;
    }

    public final int getPlayAddr() {
        return this.playAddr;
    }

    public final int getSongs() {
        return this.songs;
    }

    public final int getStartSong() {
        return this.startSong;
    }

    public final int getSIDChipBase(int sidNum) {
        return this.sidChipBase[sidNum];
    }

    public final SidTune.Model getSIDModel(int sidNum) {
        return this.sidModel[sidNum];
    }

    public final int getCurrentSong() {
        return this.currentSong;
    }

    public final SidTune.Clock getClockSpeed() {
        return this.clockSpeed;
    }

    public final short getRelocStartPage() {
        return this.relocStartPage;
    }

    public final short getRelocPages() {
        return this.relocPages;
    }

    public final SidTune.Compatibility getCompatibility() {
        return this.compatibility;
    }

    public final Collection<String> getInfoString() {
        return this.infoString;
    }

    public final Collection<String> getCommentString() {
        return this.commentString;
    }

    public final int getC64dataLen() {
        return this.c64dataLen;
    }

    public final int getDeterminedDriverAddr() {
        return this.determinedDriverAddr;
    }

    public final int getDeterminedDriverLength() {
        return this.determinedDriverLength;
    }

    public final void setSelectedSong(Integer song) {
        this.currentSong = song == null || song > this.songs ? this.startSong : song;
    }

    public int getSelectedSong() {
        return this.currentSong == 0 || this.currentSong > this.songs ? this.startSong : this.currentSong;
    }

    public int iomap(int addr) {
        switch (this.compatibility) {
            case RSIDv2: 
            case RSIDv3: 
            case RSID_BASIC: {
                return 0;
            }
        }
        if (addr == 0) {
            return 0;
        }
        if (addr < 40960) {
            return 55;
        }
        if (addr < 53248) {
            return 54;
        }
        if (addr >= 57344) {
            return 53;
        }
        return 52;
    }

    public String getAudioTypeString() {
        return this.getSIDChipBase(1) != 0 ? (this.getSIDChipBase(2) != 0 ? "3-SID" : "Stereo") : "Mono";
    }
}

