/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import libsidutils.ZipFileUtils;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TFile;

public class IOUtils {
    private static final Pattern SEPARATOR = Pattern.compile("[/\\\\]");
    private static final int COPY_BUFFER_CHUNK_SIZE = 16384;
    private static final int BUFFER_LENGTH = 64;

    public static final String getCollectionName(File collectionRoot, File file) {
        return IOUtils.createFilename(IOUtils.getFiles(file.getPath(), collectionRoot, null));
    }

    private static final String createFilename(List<File> files) {
        StringBuilder result = new StringBuilder();
        for (File file : files) {
            result.append("/").append(file.getName());
        }
        return result.toString();
    }

    public static final File getFile(String path, File hvscRoot, File cgscRoot) {
        List<File> files = IOUtils.getFiles(path, hvscRoot, null);
        if (files.size() > 0) {
            return files.get(files.size() - 1);
        }
        files = IOUtils.getFiles(path, cgscRoot, null);
        if (files.size() > 0) {
            return files.get(files.size() - 1);
        }
        return new File(path);
    }

    public static final List<File> getFiles(String path, File rootFile, FileFilter fileFilter) {
        if (rootFile == null) {
            return Collections.emptyList();
        }
        String rootPath = rootFile.getPath();
        if (path.startsWith(rootPath) && (path = path.substring(rootPath.length())).length() > 0) {
            path = path.substring(1);
        }
        ArrayList<File> pathSegs = new ArrayList<File>();
        try (Scanner scanner = new Scanner(path);){
            scanner.useDelimiter(SEPARATOR);
            block6: while (scanner.hasNext()) {
                String pathSeg = scanner.next();
                File[] childFiles = rootFile.listFiles(fileFilter);
                if (childFiles != null) {
                    for (File childFile : childFiles) {
                        if (!childFile.getName().equalsIgnoreCase(pathSeg)) continue;
                        rootFile = childFile;
                        pathSegs.add(rootFile);
                        continue block6;
                    }
                }
                List<File> list = Collections.emptyList();
                return list;
            }
            ArrayList<File> arrayList = pathSegs;
            return arrayList;
        }
    }

    public static final void deleteDirectory(File directory) throws IOException {
        Files.walkFileTree(Paths.get(directory.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final String getFilenameWithoutSuffix(String filename) {
        return filename.substring(0, filename.length() - IOUtils.getFilenameSuffix(filename).length());
    }

    public static final String getFilenameSuffix(String filename) {
        int lastIndexOf = filename.lastIndexOf(46);
        return lastIndexOf != -1 ? filename.substring(lastIndexOf) : "";
    }

    public static List<String> addUpperCase(List<String> fileExtensions) {
        ArrayList<String> result = new ArrayList<String>(fileExtensions);
        fileExtensions.stream().map(fileName -> fileName.toUpperCase(Locale.US)).forEach(result::add);
        return result;
    }

    public static String getPhysicalSize(long size) {
        if (size <= 0L) {
            return "0b";
        }
        String[] units = new String[]{"b", "Kb", "Mb", "Gb", "Tb"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + units[digitGroups];
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        ReadableByteChannel inputChannel = Channels.newChannel(is);
        WritableByteChannel outputChannel = Channels.newChannel(os);
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (inputChannel.read(buffer) != -1) {
            ((Buffer)buffer).flip();
            outputChannel.write(buffer);
            buffer.compact();
        }
        ((Buffer)buffer).flip();
        while (buffer.hasRemaining()) {
            outputChannel.write(buffer);
        }
    }

    public static String convertStreamToString(InputStream is, Charset charset) {
        return IOUtils.convertStreamToString(is, charset, new HashMap<String, String>());
    }

    public static String convertStreamToString(InputStream is, Charset charset, Map<String, String> replacements) {
        try (Scanner s = new Scanner(is, charset.name());){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                string = string.replace("${" + replacement.getKey() + "}", replacement.getValue());
            }
            String string2 = string;
            return string2;
        }
    }

    public static byte[] readAllBytes(InputStream is) throws IOException {
        int nRead;
        if (is == null) {
            throw new IOException("no InputStream");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] b = new byte[64];
        while ((nRead = is.read(b, 0, b.length)) != -1) {
            buffer.write(b, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static int readNBytes(InputStream is, byte[] b, int off, int len) throws IOException {
        int nRead;
        int count;
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        for (nRead = 0; nRead < len && (count = is.read(b, off + nRead, len - nRead)) >= 0; nRead += count) {
        }
        return nRead;
    }

    public static File extract(File baseDir, File inputFile) throws IOException {
        TFile file;
        if (inputFile != null && (file = new TFile(inputFile)).isEntry()) {
            File tmpFile;
            File tmpDir = new File(baseDir, UUID.randomUUID().toString());
            tmpDir.mkdirs();
            if (inputFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".gz")) {
                tmpFile = new File(tmpDir, IOUtils.getFilenameWithoutSuffix(inputFile.getName()));
                try (GZIPInputStream is = new GZIPInputStream(ZipFileUtils.newFileInputStream(inputFile));){
                    TFile.cp((InputStream)is, (File)tmpFile);
                }
            } else {
                tmpFile = new File(tmpDir, inputFile.getName());
                TFile.cp_rp((File)inputFile, (File)tmpFile, (TArchiveDetector)TArchiveDetector.ALL);
            }
            return tmpFile;
        }
        return inputFile;
    }
}

