/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.fingerprinting.fingerprint;

public class FindPeaks {
    private final int nPeaks;
    private final float[] power;
    private final int[] locate;

    public FindPeaks(int nPeaks) {
        this.nPeaks = nPeaks;
        this.power = new float[nPeaks];
        this.locate = new int[nPeaks];
    }

    public float[] getPower() {
        return this.power;
    }

    public int[] getLocate() {
        return this.locate;
    }

    public void findComplexPeaks(float[] data, int neighborRange) {
        int dataLength = data.length / 2;
        for (int i = 0; i < this.nPeaks; ++i) {
            this.power[i] = -500.0f;
            this.locate[i] = -1;
        }
        float[] dataPower = new float[dataLength];
        for (int i = 0; i < dataLength; ++i) {
            dataPower[i] = (float)(10.0 * Math.log10(data[2 * i] * data[2 * i] + data[2 * i + 1] * data[2 * i + 1]));
        }
        for (int k = 0; k < dataLength; ++k) {
            float pi = dataPower[k];
            boolean add = true;
            for (int j = 0; j < neighborRange; ++j) {
                float pl = k - neighborRange >= 0 ? dataPower[k - neighborRange] : pi - 1.0f;
                float pr = k + neighborRange < dataLength ? dataPower[k + neighborRange] : pi - 1.0f;
                if (!(pi < pl) || !(pi < pr)) continue;
                add = false;
            }
            if (!add) continue;
            this.add(pi, k);
        }
    }

    private void add(float p, int loc) {
        for (int i = 0; i < this.power.length; ++i) {
            if (!(this.power[i] < p)) continue;
            for (int j = this.power.length - 1; j > i; --j) {
                this.power[j] = this.power[j - 1];
                this.locate[j] = this.locate[j - 1];
            }
            this.power[i] = p;
            this.locate[i] = loc;
            break;
        }
    }
}

