/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.siddatabase;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import libsidplay.sidtune.MD5Method;
import libsidplay.sidtune.SidTune;
import libsidutils.ZipFileUtils;
import libsidutils.siddatabase.TimeConverter;
import sidplay.ini.IniReader;

public class SidDatabase {
    private static final String SONGLENGTHS_FILE_TXT = "DOCUMENTS/Songlengths.txt";
    private static final String SONGLENGTHS_FILE_MD5 = "DOCUMENTS/Songlengths.md5";
    private MD5Method version;
    private final IniReader database;
    protected Random random = new Random();

    public SidDatabase(File hvscRoot) throws IOException {
        try (InputStream is = this.getInputStreamAndSetVersion(hvscRoot);){
            this.database = new IniReader(is);
        }
    }

    private InputStream getInputStreamAndSetVersion(File hvscRoot) throws FileNotFoundException {
        File file = ZipFileUtils.newFile(hvscRoot, SONGLENGTHS_FILE_TXT);
        this.version = MD5Method.MD5_PSID_HEADER;
        File songLengthFileMd5 = ZipFileUtils.newFile(hvscRoot, SONGLENGTHS_FILE_MD5);
        if (songLengthFileMd5.exists() && songLengthFileMd5.canRead()) {
            file = songLengthFileMd5;
            this.version = MD5Method.MD5_CONTENTS;
        }
        return ZipFileUtils.newFileInputStream(file);
    }

    public double getTuneLength(SidTune tune) {
        double length = 0.0;
        String md5 = tune.getMD5Digest(this.version);
        for (int songNum = 1; songNum <= tune.getInfo().getSongs(); ++songNum) {
            length += this.getLength(md5, songNum);
        }
        BigDecimal bd = BigDecimal.valueOf(length);
        bd = bd.setScale(3, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public double getSongLength(SidTune tune) {
        if (tune == SidTune.RESET) {
            return 0.0;
        }
        int songNum = tune.getInfo().getCurrentSong();
        String md5 = tune.getMD5Digest(this.version);
        return songNum == 0 || md5 == null ? 0.0 : this.getLength(md5, songNum);
    }

    public String getPath(SidTune tune) {
        String md5 = tune.getMD5Digest(this.version);
        String comment = md5 != null ? this.database.getPropertyString("Database", "_" + md5, null) : null;
        return comment != null ? comment.substring(1).trim() : "";
    }

    public String getRandomPath() {
        String[] sectionProperties = this.database.sectionProperties("Database");
        int rndIndex = Math.abs(this.random.nextInt(Integer.MAX_VALUE)) % sectionProperties.length & 0x7FFFFFFE;
        return this.getPath(sectionProperties[rndIndex]);
    }

    public String getPath(String md5Comment) {
        String comment = md5Comment != null ? this.database.getPropertyString("Database", "_" + md5Comment, null) : null;
        return comment != null ? comment.substring(1).trim() : null;
    }

    public double getLength(String md5, int songNum) {
        String times = this.database.getPropertyString("Database", md5, null);
        return times != null ? new TimeConverter().fromString(times.split(" ")[songNum - 1]) : 0.0;
    }
}

