/*
 * Decompiled with CFR 0.152.
 */
package server.netsiddev;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import sidplay.audio.AudioConfig;

public class SIDDeviceSettings {
    private static final String FILE_NAME_PROPERTIES = "jsiddevice.properties";
    private static final String PROPERTY_DEVICE_INDEX = "deviceIndex";
    private static final String PROPERTY_DIGI_BOOST = "digiBoost";
    private static final String PROPERTY_WHATSSID_URL = "whatsSIDUrl";
    private static final String PROPERTY_WHATSSID_ENABLE = "whatsSIDEnable";
    private static final String PROPERTY_WHATSSID_USERNAME = "whatsSIDUsername";
    private static final String PROPERTY_WHATSSID_PASSWORD = "whatsSIDPassword";
    private static final String PROPERTY_WHATSSID_CONNECTION_TIMEOUT = "whatsSIDConnectionTimeout";
    private static final String PROPERTY_WHATSSID_CAPTURE_TIME = "whatsSIDCaptureTime";
    private static final String PROPERTY_WHATSSID_MATCH_RETRY_TIME = "whatsSIDMatchRetryTime";
    private static final String PROPERTY_WHATSSID_MINIMUM_RELATIVE_CONFIDENCE = "whatsSIDMinimumRelativeConfidence";
    private static final String PROPERTY_AUDIO_BUFFER_SIZE = "audioBufferSize";
    private static final String ALLOW_EXTERNAL_CONNECTIONS = "allowExternalConnections";
    private static final String PROPERTY_DEVICE_INDEX_COMMENT = "JSIDDevice settings";
    private static final SIDDeviceSettings instance = new SIDDeviceSettings();
    private Properties props = new Properties();

    private SIDDeviceSettings() {
        this.load();
    }

    public static SIDDeviceSettings getInstance() {
        return instance;
    }

    public synchronized int getDeviceIndex() {
        try {
            return Integer.valueOf(this.props.getProperty(PROPERTY_DEVICE_INDEX));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public synchronized int getAudioBufferSize() {
        try {
            return Integer.valueOf(this.props.getProperty(PROPERTY_AUDIO_BUFFER_SIZE));
        }
        catch (NumberFormatException nfe) {
            return AudioConfig.getDefaultBufferSize();
        }
    }

    public synchronized boolean getDigiBoostEnabled() {
        return Boolean.TRUE.equals(Boolean.valueOf(this.props.getProperty(PROPERTY_DIGI_BOOST)));
    }

    public synchronized boolean isWhatsSidEnable() {
        return Boolean.TRUE.equals(Boolean.valueOf(this.props.getProperty(PROPERTY_WHATSSID_ENABLE, "true")));
    }

    public synchronized String getWhatsSidUrl() {
        return this.props.getProperty(PROPERTY_WHATSSID_URL, "https://haendel.ddns.net:8443/jsidplay2service/JSIDPlay2REST");
    }

    public synchronized String getWhatsSidUsername() {
        return this.props.getProperty(PROPERTY_WHATSSID_USERNAME, "jsidplay2");
    }

    public synchronized String getWhatsSidPassword() {
        return this.props.getProperty(PROPERTY_WHATSSID_PASSWORD, "jsidplay2!");
    }

    public synchronized int getWhatsSidConnectionTimeout() {
        return Integer.valueOf(this.props.getProperty(PROPERTY_WHATSSID_CONNECTION_TIMEOUT, "5000"));
    }

    public synchronized int getWhatsSidCaptureTime() {
        return Integer.valueOf(this.props.getProperty(PROPERTY_WHATSSID_CAPTURE_TIME, "15"));
    }

    public synchronized int getWhatsSidMatchRetryTime() {
        return Integer.valueOf(this.props.getProperty(PROPERTY_WHATSSID_MATCH_RETRY_TIME, "15"));
    }

    public synchronized double getWhatsSidMinimumRelativeConfidence() {
        return Double.valueOf(this.props.getProperty(PROPERTY_WHATSSID_MINIMUM_RELATIVE_CONFIDENCE, "4.5"));
    }

    public synchronized boolean getAllowExternalConnections() {
        return Boolean.TRUE.equals(Boolean.valueOf(this.props.getProperty(ALLOW_EXTERNAL_CONNECTIONS)));
    }

    public synchronized void saveDeviceIndex(Integer deviceIndex) {
        this.props.setProperty(PROPERTY_DEVICE_INDEX, String.valueOf(deviceIndex));
        this.save();
    }

    public synchronized void saveAudioBufferSize(Integer audioBufferSize) {
        this.props.setProperty(PROPERTY_AUDIO_BUFFER_SIZE, String.valueOf(audioBufferSize));
        this.save();
    }

    public synchronized void saveDigiBoost(boolean digiBoost) {
        this.props.setProperty(PROPERTY_DIGI_BOOST, String.valueOf(digiBoost));
        this.save();
    }

    public void saveWhatsSidEnable(boolean whatsSidEnable) {
        this.props.setProperty(PROPERTY_WHATSSID_ENABLE, String.valueOf(whatsSidEnable));
        this.save();
    }

    public void saveWhatsSidUrl(String whatsSidUrl) {
        this.props.setProperty(PROPERTY_WHATSSID_URL, String.valueOf(whatsSidUrl));
        this.save();
    }

    public void saveWhatsSidUsername(String whatsSidUsername) {
        this.props.setProperty(PROPERTY_WHATSSID_USERNAME, String.valueOf(whatsSidUsername));
        this.save();
    }

    public void saveWhatsSidPassword(String whatsSidPassword) {
        this.props.setProperty(PROPERTY_WHATSSID_PASSWORD, String.valueOf(whatsSidPassword));
        this.save();
    }

    public void saveWhatsSidConnectionTimeout(int whatsSidConnectionTimeout) {
        this.props.setProperty(PROPERTY_WHATSSID_CONNECTION_TIMEOUT, String.valueOf(whatsSidConnectionTimeout));
        this.save();
    }

    public void saveWhatsSidCaptureTime(int whatsSidCaptureTime) {
        this.props.setProperty(PROPERTY_WHATSSID_CAPTURE_TIME, String.valueOf(whatsSidCaptureTime));
        this.save();
    }

    public void saveWhatsSidMatchRetryTime(int whatsSidMatchRetryTime) {
        this.props.setProperty(PROPERTY_WHATSSID_MATCH_RETRY_TIME, String.valueOf(whatsSidMatchRetryTime));
        this.save();
    }

    public void saveWhatsSidMinimumRelativeConfidence(double whatsSidMinimumRelativeConfidence) {
        this.props.setProperty(PROPERTY_WHATSSID_MINIMUM_RELATIVE_CONFIDENCE, String.valueOf(whatsSidMinimumRelativeConfidence));
        this.save();
    }

    public synchronized void saveAllowExternalConnections(boolean allowExternalConnections) {
        this.props.setProperty(ALLOW_EXTERNAL_CONNECTIONS, String.valueOf(allowExternalConnections));
        this.save();
    }

    public void load() {
        try (FileInputStream fis = new FileInputStream(FILE_NAME_PROPERTIES);){
            this.props.load(fis);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save() {
        try (FileOutputStream os = new FileOutputStream(FILE_NAME_PROPERTIES);){
            this.props.store(os, PROPERTY_DEVICE_INDEX_COMMENT);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

