/*
 * Decompiled with CFR 0.152.
 */
package server.netsiddev;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.sound.sampled.Mixer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import server.netsiddev.AudioDevice;
import server.netsiddev.AudioDeviceCompare;
import server.netsiddev.ClientContext;
import server.netsiddev.SIDDeviceSettings;
import server.netsiddev.SIDDeviceStage;
import sidplay.audio.JavaSound;

public class Settings
extends SIDDeviceStage {
    private static final long serialVersionUID = 1L;
    private JComboBox<AudioDevice> audioDevice;
    private JComboBox<Integer> audioBuffer;
    private JCheckBox allowExternalConnections;
    private JCheckBox digiBoost;
    private JCheckBox whatsSidEnable;
    private JTextField whatsSidURl;
    private JTextField whatsSidUsername;
    private JPasswordField whatsSidPassword;
    private JFormattedTextField whatsSidConnectionTimeout;
    private JFormattedTextField whatsSidCaptureTime;
    private JFormattedTextField whatsSidMatchRetryTime;
    private JFormattedTextField whatsSidMinimumRelativeConfidence;
    private JButton okButton;
    private Vector<AudioDevice> audioDevices;
    private Vector<Integer> audioBufferSizes;
    private SIDDeviceSettings settings;

    public Settings() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstants = new GridBagConstraints();
        gridBagConstants.weightx = 1.0;
        gridBagConstants.fill = 2;
        gridBagConstants.gridwidth = 0;
        gridBagConstants.insets.set(10, 10, 10, 10);
        JPanel audioPane = new JPanel();
        audioPane.setLayout(new BoxLayout(audioPane, 0));
        audioPane.setAlignmentX(0.5f);
        TitledBorder audioBorder = new TitledBorder(this.util.getBundle().getString("AUDIO_SETTINGS"));
        audioPane.setBorder(audioBorder);
        JLabel deviceLabel = new JLabel(this.util.getBundle().getString("DEVICE"));
        deviceLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        audioPane.add(deviceLabel);
        this.audioDevices = new Vector();
        this.audioDevice = new JComboBox<AudioDevice>(this.audioDevices);
        this.audioDevice.setRenderer(new ItemRenderer());
        this.audioDevice.addActionListener(event -> this.setAudioDevice());
        this.audioDevice.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        audioPane.add(this.audioDevice);
        JLabel audioBufferSizeLabel = new JLabel(this.util.getBundle().getString("AUDIO_BUFFER_SIZE"));
        audioBufferSizeLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        audioPane.add(audioBufferSizeLabel);
        this.audioBufferSizes = new Vector<Integer>(Arrays.asList(1024, 2048, 4096, 8192, 16384));
        this.audioBuffer = new JComboBox<Integer>(this.audioBufferSizes);
        this.audioBuffer.setRenderer(new ItemRenderer());
        this.audioBuffer.addActionListener(event -> this.setAudioBuffer());
        this.audioBuffer.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        audioPane.add(this.audioBuffer);
        this.getContentPane().add((Component)audioPane, gridBagConstants);
        JPanel connectionPane = new JPanel();
        connectionPane.setLayout(new BoxLayout(connectionPane, 0));
        connectionPane.setAlignmentX(0.5f);
        TitledBorder connectionBorder = new TitledBorder(this.util.getBundle().getString("CONNECTION_SETTINGS"));
        connectionPane.setBorder(connectionBorder);
        JLabel allowExternalConnectionsLabal = new JLabel(this.util.getBundle().getString("ALLOW_EXTERNAL_CONNECTIONS"));
        allowExternalConnectionsLabal.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        connectionPane.add(allowExternalConnectionsLabal);
        this.allowExternalConnections = new JCheckBox();
        this.allowExternalConnections.addActionListener(event -> this.setAllowExternalConnections());
        connectionPane.add(this.allowExternalConnections);
        this.scaleCheckBoxIcon(this.allowExternalConnections);
        this.getContentPane().add((Component)connectionPane, gridBagConstants);
        JPanel emulationPane = new JPanel();
        emulationPane.setLayout(new BoxLayout(emulationPane, 2));
        emulationPane.setAlignmentX(0.5f);
        TitledBorder emulationBorder = new TitledBorder(this.util.getBundle().getString("EMULATION_SETTINGS"));
        emulationPane.setBorder(emulationBorder);
        JLabel digiBoostLabal = new JLabel(this.util.getBundle().getString("DIGI_BOOST"));
        digiBoostLabal.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        emulationPane.add(digiBoostLabal);
        this.digiBoost = new JCheckBox();
        this.digiBoost.addActionListener(event -> this.setDigiBoost());
        emulationPane.add(this.digiBoost);
        this.scaleCheckBoxIcon(this.digiBoost);
        this.getContentPane().add((Component)emulationPane, gridBagConstants);
        JPanel whatsSidPane = new JPanel();
        whatsSidPane.setLayout(new BoxLayout(whatsSidPane, 1));
        whatsSidPane.setAlignmentX(0.5f);
        TitledBorder whatsSidBorder = new TitledBorder(this.util.getBundle().getString("WHATSSID_SETTINGS"));
        whatsSidPane.setBorder(whatsSidBorder);
        this.whatsSidEnable = new JCheckBox();
        this.whatsSidEnable.setText(this.util.getBundle().getString("WHATSSID_ENABLE"));
        this.whatsSidEnable.addActionListener(event -> this.setWhatsSidEnable());
        whatsSidPane.add(this.whatsSidEnable);
        this.scaleCheckBoxIcon(this.whatsSidEnable);
        JLabel urlLabel = new JLabel(this.util.getBundle().getString("WHATSSID_URL"));
        urlLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(urlLabel);
        this.whatsSidURl = new JTextField();
        this.whatsSidURl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Settings.this.setWhatsSidUrl();
            }
        });
        this.whatsSidURl.addActionListener(event -> this.setWhatsSidUrl());
        this.whatsSidURl.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(this.whatsSidURl);
        JLabel usernameLabel = new JLabel(this.util.getBundle().getString("WHATSSID_USERNAME"));
        usernameLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(usernameLabel);
        this.whatsSidUsername = new JTextField();
        this.whatsSidUsername.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Settings.this.setWhatsSidUsername();
            }
        });
        this.whatsSidUsername.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(this.whatsSidUsername);
        JLabel passwordLabel = new JLabel(this.util.getBundle().getString("WHATSSID_PASSWORD"));
        passwordLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(passwordLabel);
        this.whatsSidPassword = new JPasswordField();
        this.whatsSidPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Settings.this.setWhatsSidPassword();
            }
        });
        this.whatsSidPassword.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(this.whatsSidPassword);
        JLabel connectionTimeoutLabel = new JLabel(this.util.getBundle().getString("WHATSSID_CONNECTION_TIMEOUT"));
        connectionTimeoutLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(connectionTimeoutLabel);
        this.whatsSidConnectionTimeout = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.whatsSidConnectionTimeout.setColumns(2);
        this.whatsSidConnectionTimeout.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Settings.this.setWhatsSidConnectionTimeout();
            }
        });
        this.whatsSidConnectionTimeout.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(this.whatsSidConnectionTimeout);
        JLabel captureTimeLabel = new JLabel(this.util.getBundle().getString("WHATSSID_CAPTURE_TIME"));
        captureTimeLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(captureTimeLabel);
        this.whatsSidCaptureTime = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.whatsSidCaptureTime.setColumns(2);
        this.whatsSidCaptureTime.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Settings.this.setWhatsSidCaptureTime();
            }
        });
        this.whatsSidCaptureTime.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(this.whatsSidCaptureTime);
        JLabel matchRetryTimeLabel = new JLabel(this.util.getBundle().getString("WHATSSID_MATCH_RETRY_TIME"));
        matchRetryTimeLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(matchRetryTimeLabel);
        this.whatsSidMatchRetryTime = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.whatsSidMatchRetryTime.setColumns(2);
        this.whatsSidMatchRetryTime.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Settings.this.setWhatsSidMatchRetryTime();
            }
        });
        this.whatsSidMatchRetryTime.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(this.whatsSidMatchRetryTime);
        JLabel minimumRelativeConfidenceLabel = new JLabel(this.util.getBundle().getString("WHATSSID_MINIMUM_RELATIVE_CONFIDENCE"));
        minimumRelativeConfidenceLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(minimumRelativeConfidenceLabel);
        this.whatsSidMinimumRelativeConfidence = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.whatsSidMinimumRelativeConfidence.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Settings.this.setWhatsSidMinimumRelativeConfidence();
            }
        });
        this.whatsSidMinimumRelativeConfidence.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        whatsSidPane.add(this.whatsSidMinimumRelativeConfidence);
        this.getContentPane().add((Component)whatsSidPane, gridBagConstants);
        this.okButton = new JButton(this.util.getBundle().getString("OK"));
        this.okButton.addActionListener(event -> this.okPressed());
        this.getContentPane().add((Component)this.okButton, gridBagConstants);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon getScaledCheckBoxImageIcon(JCheckBox checkbox, boolean checkState) {
        boolean previousState = checkbox.isSelected();
        checkbox.setSelected(checkState);
        Icon checkBoxIcon = UIManager.getIcon("CheckBox.icon");
        BufferedImage checkBoxImage = new BufferedImage(checkBoxIcon.getIconWidth(), checkBoxIcon.getIconHeight(), 2);
        Graphics2D graphics = checkBoxImage.createGraphics();
        try {
            checkBoxIcon.paintIcon(checkbox, graphics, 0, 0);
        }
        finally {
            graphics.dispose();
        }
        FontMetrics fontMetrics = checkbox.getFontMetrics(checkbox.getFont());
        Image scaledCheckBoxImage = checkBoxImage.getScaledInstance(fontMetrics.getHeight(), fontMetrics.getHeight(), 4);
        checkbox.setSelected(previousState);
        return new ImageIcon(scaledCheckBoxImage);
    }

    private void scaleCheckBoxIcon(JCheckBox checkbox) {
        checkbox.setIcon(this.getScaledCheckBoxImageIcon(checkbox, false));
        checkbox.setSelectedIcon(this.getScaledCheckBoxImageIcon(checkbox, true));
    }

    private void initialize() {
        this.settings = SIDDeviceSettings.getInstance();
        AudioDeviceCompare cmp = new AudioDeviceCompare();
        AudioDevice selectedAudioDeviceItem = null;
        this.audioDevices.clear();
        int deviceIndex = 0;
        for (Mixer.Info deviceInfo : JavaSound.getDeviceInfos()) {
            AudioDevice audioDeviceItem = new AudioDevice(deviceIndex, deviceInfo);
            this.audioDevices.add(audioDeviceItem);
            if (deviceIndex == 0) {
                cmp.setPrimaryDeviceName(deviceInfo.getName());
            }
            if (audioDeviceItem.getIndex().intValue() == this.settings.getDeviceIndex()) {
                selectedAudioDeviceItem = audioDeviceItem;
            }
            ++deviceIndex;
        }
        Collections.sort(this.audioDevices, cmp);
        this.audioDevice.setSelectedItem(selectedAudioDeviceItem);
        this.allowExternalConnections.setSelected(this.settings.getAllowExternalConnections());
        this.digiBoost.setSelected(this.settings.getDigiBoostEnabled());
        this.audioBuffer.setSelectedItem(this.settings.getAudioBufferSize());
        this.whatsSidEnable.setSelected(this.settings.isWhatsSidEnable());
        this.whatsSidURl.setText(this.settings.getWhatsSidUrl());
        this.whatsSidUsername.setText(this.settings.getWhatsSidUsername());
        this.whatsSidPassword.setText(this.settings.getWhatsSidPassword());
        this.whatsSidConnectionTimeout.setValue(this.settings.getWhatsSidConnectionTimeout());
        this.whatsSidCaptureTime.setValue(this.settings.getWhatsSidCaptureTime());
        this.whatsSidMatchRetryTime.setValue(this.settings.getWhatsSidMatchRetryTime());
        this.whatsSidMinimumRelativeConfidence.setValue(this.settings.getWhatsSidMinimumRelativeConfidence());
    }

    @Override
    public void open() {
        SwingUtilities.invokeLater(() -> this.okButton.requestFocusInWindow());
        this.initialize();
        super.open();
    }

    private void setAudioDevice() {
        AudioDevice device = (AudioDevice)this.audioDevice.getSelectedItem();
        if (device != null) {
            ClientContext.changeDevice(device.getInfo());
            this.settings.saveDeviceIndex(device.getIndex());
        }
    }

    private void setAudioBuffer() {
        Integer audioBufferSize = (Integer)this.audioBuffer.getSelectedItem();
        if (audioBufferSize != null) {
            ClientContext.setAudioBufferSize(audioBufferSize);
            this.settings.saveAudioBufferSize(audioBufferSize);
        }
    }

    private void setAllowExternalConnections() {
        boolean isAllowExternalConnections = this.allowExternalConnections.isSelected();
        this.settings.saveAllowExternalConnections(isAllowExternalConnections);
        ClientContext.applyConnectionConfigChanges();
    }

    private void setDigiBoost() {
        boolean isDigiBoost = this.digiBoost.isSelected();
        ClientContext.setDigiBoost(isDigiBoost);
        this.settings.saveDigiBoost(isDigiBoost);
    }

    private void setWhatsSidEnable() {
        boolean whatsSidEnable = this.whatsSidEnable.isSelected();
        this.settings.saveWhatsSidEnable(whatsSidEnable);
    }

    private void setWhatsSidUrl() {
        String whatsSidUrl = this.whatsSidURl.getText();
        this.settings.saveWhatsSidUrl(whatsSidUrl);
    }

    private void setWhatsSidUsername() {
        String whatsSidUserName = this.whatsSidUsername.getText();
        this.settings.saveWhatsSidUsername(whatsSidUserName);
    }

    private void setWhatsSidPassword() {
        String whatsSidPasswd = new String(this.whatsSidPassword.getPassword());
        this.settings.saveWhatsSidPassword(whatsSidPasswd);
    }

    private void setWhatsSidConnectionTimeout() {
        Number whatsSidConnectionTimeout = (Number)this.whatsSidConnectionTimeout.getValue();
        this.settings.saveWhatsSidConnectionTimeout(whatsSidConnectionTimeout.intValue());
    }

    private void setWhatsSidCaptureTime() {
        Number whatsSidCaptureTime = (Number)this.whatsSidCaptureTime.getValue();
        this.settings.saveWhatsSidCaptureTime(whatsSidCaptureTime.intValue());
    }

    private void setWhatsSidMatchRetryTime() {
        Number whatsSidMatchRetryTime = (Number)this.whatsSidMatchRetryTime.getValue();
        this.settings.saveWhatsSidMatchRetryTime(whatsSidMatchRetryTime.intValue());
    }

    private void setWhatsSidMinimumRelativeConfidence() {
        Number whatsSidMinimumRelativeConfidence = (Number)this.whatsSidMinimumRelativeConfidence.getValue();
        this.settings.saveWhatsSidMinimumRelativeConfidence(whatsSidMinimumRelativeConfidence.doubleValue());
    }

    private void okPressed() {
        this.settings.saveDeviceIndex(this.settings.getDeviceIndex());
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private class ItemRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;

        private ItemRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            comp.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            return this;
        }
    }
}

