/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;

@WebFilter(filterName="HeadRequestFilter", displayName="HeadRequestFilter", servletNames={"ConvertServlet"}, description="Fake HEAD request to return unknown content-length")
public final class HeadRequestFilter
extends HttpFilter {
    public static final String FILTER_PARAMETER_CONTENT_TYPE = "contentType";
    private String contentType;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.contentType = Optional.ofNullable(filterConfig.getInitParameter(FILTER_PARAMETER_CONTENT_TYPE)).orElseThrow(() -> new UnavailableException(FILTER_PARAMETER_CONTENT_TYPE));
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if ("HEAD".equals(request.getMethod())) {
            response.setContentLengthLong(-1L);
            response.setContentType(this.contentType);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

