/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import server.restful.common.rtmp.PlayerCleanupTimerTask;

@WebFilter(filterName="RTMPBasedRateLimiterFilter", displayName="RTMPBasedRateLimiterFilter", servletNames={"ConvertServlet", "WhatsSidServlet"}, description="Ensure a maximum number of RTMP video creations in parallel (server overload protection)")
public final class RTMPBasedRateLimiterFilter
extends HttpFilter {
    public static final String FILTER_PARAMETER_MAX_RTMP_PER_SERVLET = "maxRtmpPerServlet";
    private int maxRtmpPerServlet;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.maxRtmpPerServlet = Integer.parseInt(Optional.ofNullable(filterConfig.getInitParameter(FILTER_PARAMETER_MAX_RTMP_PER_SERVLET)).orElseThrow(() -> new UnavailableException(FILTER_PARAMETER_MAX_RTMP_PER_SERVLET)));
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (PlayerCleanupTimerTask.count() < this.maxRtmpPerServlet) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendError(429, "Too Many Requests");
        }
    }
}

