/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.parameter.requestpath.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import libsidutils.IOUtils;
import net.java.truevfs.access.TFile;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import ui.assembly64.ContentEntry;
import ui.assembly64.ContentEntrySearchResult;
import ui.common.util.InternetUtil;
import ui.entities.config.Configuration;
import ui.entities.config.SidPlay2Section;

public abstract class FileRequestPathServletParametersImpl
extends UsageParameter {
    private static final String ASSEMBLY64_CSDB_REU_ID = "25";

    public File fetchFile(Configuration configuration, Properties directoryProperties, ServletParameterParser parser, boolean hasAdminAccess) throws IOException, URISyntaxException {
        SidPlay2Section sidplay2Section = configuration.getSidplay2Section();
        String path = this.getFilePath();
        if (path == null) {
            return null;
        }
        if (this.getItemId() != null && this.getCategoryId() != null) {
            File file = FileRequestPathServletParametersImpl.fetchAssembly64File(configuration, this.getItemId(), this.getCategoryId(), path.substring(1));
            if (file != null && file.exists()) {
                return file;
            }
        } else if (sidplay2Section.getHvsc() != null && path.startsWith("/C64Music")) {
            File file = IOUtils.getFile(path.substring("/C64Music".length()), sidplay2Section.getHvsc(), null);
            if (file.exists() && file.getAbsolutePath().startsWith(sidplay2Section.getHvsc().getAbsolutePath())) {
                return file;
            }
        } else if (sidplay2Section.getCgsc() != null && path.startsWith("/CGSC")) {
            File file = IOUtils.getFile(path.substring("/CGSC".length()), null, sidplay2Section.getCgsc());
            if (file.exists() && file.getAbsolutePath().startsWith(sidplay2Section.getCgsc().getAbsolutePath())) {
                return file;
            }
        } else if (new File(path).getAbsolutePath().startsWith(sidplay2Section.getTmpDir().getAbsolutePath())) {
            File file = new File(path);
            if (file.exists()) {
                return file;
            }
        } else {
            for (String directoryLogicalName : directoryProperties.stringPropertyNames()) {
                boolean needToBeAdmin;
                String[] splitted = directoryProperties.getProperty(directoryLogicalName).split(",");
                String directoryValue = splitted.length > 0 ? splitted[0] : null;
                boolean bl = needToBeAdmin = splitted.length > 1 ? Boolean.parseBoolean(splitted[1]) : false;
                if (needToBeAdmin && !hasAdminAccess || !path.startsWith(directoryLogicalName) || directoryValue == null) continue;
                TFile root = new TFile(directoryValue);
                File file = IOUtils.getFile(path.substring(directoryLogicalName.length()), (File)root, null);
                if (!file.exists() || !file.getAbsolutePath().startsWith(root.getAbsolutePath())) continue;
                return file;
            }
        }
        parser.setException(new FileNotFoundException(path));
        return null;
    }

    public boolean isREU() {
        return ASSEMBLY64_CSDB_REU_ID.equals(this.getCategoryId());
    }

    public static File fetchAssembly64File(Configuration configuration, String itemId, String categoryId, String fileId) throws IOException, URISyntaxException {
        String assembly64Url = configuration.getOnlineSection().getAssembly64Url();
        String encodedItemId = new String(Base64.getEncoder().encode(itemId.getBytes()));
        URL url = new URI(assembly64Url + "/leet/search/legacy/entries/" + encodedItemId + "/" + categoryId).toURL();
        URLConnection connection = InternetUtil.openConnection(url, configuration.getSidplay2Section());
        ContentEntrySearchResult contentEntries = (ContentEntrySearchResult)JSIDPlay2Servlet.OBJECT_MAPPER.readValue(connection.getInputStream(), ContentEntrySearchResult.class);
        File targetDir = new File(configuration.getSidplay2Section().getTmpDir(), UUID.randomUUID().toString());
        targetDir.mkdir();
        File file = new File(fileId);
        boolean mustFetchAttachments = JSIDPlay2Servlet.VIDEO_TUNE_FILE_FILTER.accept(file) || JSIDPlay2Servlet.DISK_FILE_FILTER.accept(file) || JSIDPlay2Servlet.TAPE_FILE_FILTER.accept(file) || JSIDPlay2Servlet.CART_FILE_FILTER.accept(file);
        List contentEntriesToFetch = contentEntries.getContentEntry().stream().filter(e -> !e.getId().startsWith("__MACOSX")).filter(contentEntry -> Objects.equals(contentEntry.getId(), fileId) || mustFetchAttachments && (JSIDPlay2Servlet.DISK_FILE_FILTER.accept(new File(contentEntry.getId())) || JSIDPlay2Servlet.TAPE_FILE_FILTER.accept(new File(contentEntry.getId())) || JSIDPlay2Servlet.CART_FILE_FILTER.accept(new File(contentEntry.getId())))).collect(Collectors.toList());
        File result = null;
        for (ContentEntry contentEntry2 : contentEntriesToFetch) {
            File contentEntryFile = new File(targetDir, contentEntry2.getId());
            contentEntryFile.getParentFile().mkdirs();
            FileRequestPathServletParametersImpl.fetchAssembly64File(configuration, itemId, categoryId, contentEntry2.getId(), contentEntryFile);
            if (!Objects.equals(contentEntry2.getId(), fileId)) continue;
            result = contentEntryFile;
        }
        return result;
    }

    public static void fetchAssembly64File(Configuration configuration, String itemId, String categoryId, String fileId, File contentEntryFile) throws IOException, URISyntaxException {
        String assembly64Url = configuration.getOnlineSection().getAssembly64Url();
        String encodedFileId = new String(Base64.getEncoder().encode(fileId.getBytes()));
        URL url = new URI(assembly64Url + "/leet/search/legacy/bin/" + itemId + "/" + categoryId + "/" + encodedFileId).toURL();
        URLConnection connection = InternetUtil.openConnection(url, configuration.getSidplay2Section());
        try (FileOutputStream outputStream = new FileOutputStream(contentEntryFile);){
            IOUtils.copy(connection.getInputStream(), outputStream);
        }
    }

    public abstract String getFilePath();

    public abstract String getItemId();

    public abstract String getCategoryId();
}

