/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.rtmp;

import java.io.File;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import libsidutils.status.Status;
import sidplay.Player;
import sidplay.audio.xuggle.XuggleVideoDriver;

public class StatusText {
    private static final int WAIT_FOR_SCROLL_IN_SECONDS = 10;
    private static final int SCROLL_EVERY_NTH_FRAME = 2;
    private final Player player;
    private final boolean showStatus;
    private final Status status;
    private final double waitForScrollInFrames;
    private Boolean currentDirection;
    private boolean newDirection;
    private String lastStatusText;
    private int lastStatusTextX;
    private int statusScrollCounter;

    public StatusText(Player player, boolean showStatus, Locale locale) {
        this.player = player;
        this.showStatus = showStatus;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(StatusText.class.getName(), locale);
        this.status = new Status(player, player.getTune(), player.getSidBuilder(), player.getAudioDriver(), tune -> player.getRecordingFilename(), () -> player.getSidDatabaseInfo(db -> db.getSongLength(player.getTune()), 0.0), () -> player.isPsid64Detected(), resourceBundle::getString);
        this.waitForScrollInFrames = 10.0 * player.getC64().getClock().getScreenRefresh();
    }

    public void update(File diskImage) {
        String newStatusText = this.createStatusText(diskImage);
        this.player.getAudioDriver().lookup(XuggleVideoDriver.class).ifPresent(xuggleVideoDriver -> {
            int statusTextX = xuggleVideoDriver.getStatusTextX();
            int statusTextOverflow = xuggleVideoDriver.getStatusTextOverflow();
            if (!Objects.equals(newStatusText, this.lastStatusText) || statusTextX != this.lastStatusTextX) {
                xuggleVideoDriver.setStatusText(newStatusText);
                this.lastStatusText = newStatusText;
                this.lastStatusTextX = statusTextX;
            }
            if (this.currentDirection == null) {
                int n = this.statusScrollCounter++;
                if ((double)n >= this.waitForScrollInFrames) {
                    this.currentDirection = this.newDirection;
                    this.statusScrollCounter = 0;
                }
            } else if (!this.currentDirection.booleanValue()) {
                if (this.statusScrollCounter++ == 2) {
                    if (statusTextOverflow > 0) {
                        xuggleVideoDriver.setStatusTextX(statusTextX + 1);
                    } else {
                        this.newDirection = this.currentDirection == false;
                        this.currentDirection = null;
                    }
                    this.statusScrollCounter = 0;
                }
            } else if (this.statusScrollCounter++ == 2) {
                if (statusTextX > 0) {
                    xuggleVideoDriver.setStatusTextX(statusTextX - 1);
                } else {
                    this.newDirection = this.currentDirection == false;
                    this.currentDirection = null;
                }
                this.statusScrollCounter = 0;
            }
        });
    }

    private String createStatusText(File diskImage) {
        StringBuilder result = new StringBuilder();
        if (Boolean.TRUE.equals(this.showStatus)) {
            String determinePSID64 = this.status.determinePSID64();
            String determineCartridge = this.status.determineCartridge();
            result.append(this.status.determineTime(false));
            result.append(", ");
            result.append(this.status.determineVideoNorm());
            result.append(", ");
            result.append(this.status.determineChipModels());
            result.append(", ");
            result.append(this.status.determineEmulations());
            result.append(determinePSID64.isEmpty() ? "" : ", " + determinePSID64);
            result.append(determineCartridge.isEmpty() ? "" : ", " + determineCartridge);
            result.append(", ");
            result.append(this.status.determineTapeActivity(false));
            result.append(this.status.determineDiskActivity(false));
            result.append(this.replaceIllegalFilenameCharacters(diskImage.getName()));
        }
        return result.toString();
    }

    private String replaceIllegalFilenameCharacters(String str) {
        return str.replace('_', '-');
    }
}

