/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import server.restful.JSIDPlay2Server;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.Order;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestparam.LogRequestParamServlet;
import ui.entities.debug.service.DebugService;

@WebServlet(name="CountLogsServlet", displayName="CountLogsServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/count-logs"}, description="Get number of log messages")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"admin"}))
public class CountLogsServlet
extends JSIDPlay2Servlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            CountLogsServletParameters servletParameters = new CountLogsServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            Long instant = servletParameters.getInstant();
            String sourceClassName = servletParameters.getSourceClassName();
            String sourceMethodName = servletParameters.getSourceMethodName();
            String level = servletParameters.getLevel();
            String message = servletParameters.getMessage();
            Order order = servletParameters.getOrder();
            Boolean tooMuchLogging = servletParameters.getTooMuchLogging();
            DebugService debugService = new DebugService(JSIDPlay2Server.getDebugEntityManager());
            Long result = debugService.countDebugEntries(instant, sourceClassName, sourceMethodName, level, message, order, tooMuchLogging);
            this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, (Object)result);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
        finally {
            JSIDPlay2Server.freeDebugEntityManager();
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.CountLogsServletParameters")
    public static class CountLogsServletParameters
    extends LogRequestParamServlet {
    }
}

