/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libsidplay.sidtune.SidTuneError;
import libsidutils.stil.STIL;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;

@WebServlet(name="STILServlet", displayName="STILServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/stil/*"}, description="Get SID tune information list (STIL)")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class STILServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.StilServlet.MAX_STIL_IN_PARALLEL, new DefaultThreadFactory("/stil"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.StilServlet.STIL_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        STILServletParameters servletParameters = new STILServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(STILServlet.this.configuration, STILServlet.this.directoryProperties, parser, STILServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        STIL.STILEntry stilEntry = STILServlet.this.createSTIL(file);
                        if (!this.isComplete()) {
                            STILServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, stilEntry);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(STILServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        STILServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    private STIL.STILEntry createSTIL(File file) throws IOException, SidTuneError {
        return this.stil != null ? this.stil.getSTILEntry(this.getCollectionName(file)) : null;
    }

    @Parameters(resourceBundle="server.restful.servlets.STILServletParameters")
    public static class STILServletParameters
    extends FileRequestPathServletParameters {
    }
}

