/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import ui.entities.config.SidPlay2Section;

@WebServlet(name="SongLengthServlet", displayName="SongLengthServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/songlength"}, description="Get SID tune's current song length")
public class SongLengthServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.SongLength.MAX_SONG_LENGTH_IN_PARALLEL, new DefaultThreadFactory("/songlength"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.SongLength.SONG_LENGTH_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block4: {
                    try {
                        SongLengthServletParameters servletParameters = new SongLengthServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        String md5 = servletParameters.getMd5();
                        Integer songNumber = servletParameters.getSongNumber();
                        double songLength = SongLengthServlet.this.getSongLength(md5, songNumber);
                        if (!this.isComplete()) {
                            SongLengthServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, songLength);
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(SongLengthServlet.this.getServletContext(), t, new Thread[0]);
                        if (this.isComplete()) break block4;
                        response.setStatus(500);
                        SongLengthServlet.this.setOutput(response, t);
                    }
                }
            }
        });
    }

    private double getSongLength(String md5, Integer songNumber) throws IOException, SidTuneError {
        SidPlay2Section sidplay2Section = this.configuration.getSidplay2Section();
        if (this.sidDatabase != null) {
            File file;
            String path = this.sidDatabase.getPath(md5);
            if (sidplay2Section.getHvsc() != null && path != null && (file = IOUtils.getFile(path, sidplay2Section.getHvsc(), null)).exists()) {
                SidTune tune = SidTune.load(file);
                tune.getInfo().setSelectedSong(songNumber);
                return this.sidDatabase.getLength(md5, tune.getInfo().getSelectedSong());
            }
        }
        return 0.0;
    }

    @Parameters(resourceBundle="server.restful.servlets.SongLengthServletParameters")
    public static class SongLengthServletParameters
    extends UsageParameter {
        private String md5;
        private Integer songNumber;

        public String getMd5() {
            return this.md5;
        }

        @Parameter(names={"--md5"}, descriptionKey="MD5", required=true, order=-2147483647)
        public void setMd5(String md5) {
            this.md5 = md5;
        }

        public Integer getSongNumber() {
            return this.songNumber;
        }

        @Parameter(names={"--songNumber"}, descriptionKey="SONG_NUMBER", order=-2147483646)
        public void setSongNumber(Integer songNumber) {
            this.songNumber = songNumber;
        }
    }
}

