/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import libsidutils.IOUtils;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.TeaVMFormat;
import server.restful.common.converter.Base64ParameterConverter;
import server.restful.common.parameter.ServletParameterHelper;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.WebResourceRequestPathServletParameters;
import server.restful.common.validator.MaxDirectoriesValidator;
import server.restful.servlets.ConvertServlet;
import sidplay.ini.IniConfig;

@WebServlet(name="StaticServlet", displayName="StaticServlet", urlPatterns={"/static/*"}, description="Get VUE demo pages or web resources")
public class StaticServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            StaticServletParameters servletParameters = new StaticServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            try (InputStream source = servletParameters.getResource();){
                ContentTypeAndFileExtensions mimeType = ContentTypeAndFileExtensions.getMimeType(IOUtils.getFilenameSuffix(request.getPathInfo()));
                if (mimeType.isCacheable()) {
                    response.setHeader("Cache-Control", IServletSystemProperties.JSIDPlay2Server.CACHE_CONTROL_RESPONSE_HEADER_CACHED);
                } else {
                    response.setHeader("Cache-Control", IServletSystemProperties.JSIDPlay2Server.CACHE_CONTROL_RESPONSE_HEADER_UNCACHED);
                }
                if (mimeType.isText()) {
                    this.setOutput(mimeType, response, this.convertStreamToStringWithDevTools(source, servletParameters));
                } else {
                    this.setOutput(mimeType, response, source);
                }
            }
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    private String convertStreamToStringWithDevTools(InputStream source, StaticServletParameters servletParameters) throws URISyntaxException, MalformedURLException, JsonProcessingException {
        String string = IOUtils.convertStreamToString(source, StandardCharsets.UTF_8, this.getReplacements(servletParameters));
        if (servletParameters.getUseDevTools().booleanValue()) {
            TeaVMFormat teaVMFormat = servletParameters.getTeaVMFormat();
            string = string.replace("// $DEVTOOLS_SECTION_1", DEV_TOOLS_SECTION1);
            string = string.replace("// $DEVTOOLS_SECTION_2", DEV_TOOLS_SECTION2 + "if (false)");
            string = string.replace("// $IMPORT_START", teaVMFormat.getImportStmtStart());
            string = string.replace("// $IMPORT_END", teaVMFormat.getImportStmtEnd());
            string = string.replace("// $DISCRIMINATOR_PATH_MAP", DISCRIMINATOR_PATH.toString());
        }
        return string;
    }

    private Map<String, String> getReplacements(StaticServletParameters servletParameters) throws URISyntaxException, MalformedURLException, JsonProcessingException {
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        Map<String, String> replacements = ServletUtil.createReplacements(servletParameters.useDevTools);
        replacements.put("convertOptions", this.createConvertServletParameters(servletParameters));
        replacements.put("defaultConvertOptions", ServletParameterHelper.CONVERT_OPTIONS);
        for (Locale locale : ServletParameterHelper.SUPPORTED_LOCALES) {
            String bundleName = control.toBundleName("convertMessages", locale);
            replacements.put(bundleName, ServletParameterHelper.CONVERT_MESSAGES.get(locale));
        }
        replacements.put("assembly64Url", this.configuration.getOnlineSection().getAssembly64Url());
        replacements.put("teaVMFormat", servletParameters.getTeaVMFormat().name().toLowerCase(Locale.US));
        replacements.put("teaVMFormatName", servletParameters.getTeaVMFormat().getTeaVMFormatName());
        replacements.put("teaVMFormatApproximateSize", servletParameters.getTeaVMFormat().getApproximateSize());
        replacements.put("teaVMFormatBrowsersExcept", servletParameters.getTeaVMFormat().getBrowsersExcept());
        replacements.put("teaVMWorkerAttrs", servletParameters.getTeaVMFormat().getWorkerAttributes());
        replacements.put("maxDirectories", String.valueOf(servletParameters.getMaxDirectories()));
        replacements.put("sleepTime", String.valueOf(servletParameters.getSleepTime()));
        replacements.put("url", Optional.ofNullable(servletParameters.getUrl()).orElse(""));
        return replacements;
    }

    private String createConvertServletParameters(StaticServletParameters servletParameters) throws JsonProcessingException {
        ConvertServlet.ConvertServletParameters convertServletParameters = new ConvertServlet.ConvertServletParameters();
        convertServletParameters.setConfig(servletParameters.getConfig());
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)convertServletParameters);
    }

    @Parameters(resourceBundle="server.restful.servlets.StaticServletParameters")
    public static class StaticServletParameters
    extends WebResourceRequestPathServletParameters {
        private Boolean useDevTools = Boolean.FALSE;
        private TeaVMFormat teaVMFormat = TeaVMFormat.WASM_GC;
        private Integer maxDirectories = 25;
        private Integer sleepTime = IServletSystemProperties.StaticServlet.SLEEP_TIME;
        private String url;
        @ParametersDelegate
        private IniConfig config = new IniConfig();

        public Boolean getUseDevTools() {
            return this.useDevTools;
        }

        @Parameter(names={"--devtools"}, arity=1, descriptionKey="USE_DEV_TOOLS", hidden=true, order=-2147483647)
        public void setUseDevTools(Boolean useDevTools) {
            this.useDevTools = useDevTools;
        }

        public TeaVMFormat getTeaVMFormat() {
            return this.teaVMFormat;
        }

        @Parameter(names={"--teavmFormat"}, arity=1, descriptionKey="TEAVM_FORMAT", order=-2147483646)
        public void setTeaVMFormat(TeaVMFormat teaVMFormat) {
            this.teaVMFormat = teaVMFormat;
        }

        public Integer getMaxDirectories() {
            return this.maxDirectories;
        }

        @Parameter(names={"--maxDirectories"}, descriptionKey="MAX_DIRECTORIES", validateWith={MaxDirectoriesValidator.class}, order=-2147483645)
        public void setMaxDirectories(Integer maxDirectories) {
            this.maxDirectories = maxDirectories;
        }

        public Integer getSleepTime() {
            return this.sleepTime;
        }

        @Parameter(names={"--sleepTime"}, descriptionKey="SLEEP_TIME", order=-2147483644)
        public void setSleepTime(Integer sleepTime) {
            this.sleepTime = sleepTime;
        }

        public String getUrl() {
            return this.url;
        }

        @Parameter(names={"--url"}, descriptionKey="URL", converter=Base64ParameterConverter.class, order=-2147483643)
        public void setUrl(String url) {
            this.url = url;
        }

        public IniConfig getConfig() {
            return this.config;
        }
    }
}

