/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.whatssid;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import libsidutils.fingerprinting.rest.beans.MusicInfoBean;
import libsidutils.fingerprinting.rest.beans.SongNoBean;
import server.restful.JSIDPlay2Server;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import ui.entities.whatssid.service.WhatsSidService;

@WebServlet(name="FindTuneServlet", displayName="FindTuneServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/tune"}, description="WhatsSID tune recognition. Find tunes")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class FindTuneServlet
extends JSIDPlay2Servlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            SongNoBean songNoBean = this.getInput(request, SongNoBean.class);
            WhatsSidService whatsSidService = new WhatsSidService(JSIDPlay2Server.getEntityManager());
            MusicInfoBean musicInfoBean = whatsSidService.findTune(songNoBean);
            this.setOutput(request, response, (Object)musicInfoBean);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
        finally {
            JSIDPlay2Server.freeEntityManager();
        }
    }
}

