/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Optional;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.EventScheduler;
import libsidplay.common.SamplingRate;
import libsidplay.config.IAudioSection;
import lowlevel.LameDecoder;
import sidplay.audio.AudioConfig;
import sidplay.audio.JavaSound;
import sidplay.audio.exceptions.IniConfigException;
import sidplay.audio.exceptions.SongEndException;

public class CmpToMP3FileDriver
extends JavaSound {
    protected LameDecoder jump3r;
    private int factor;
    private ByteBuffer decodedMP3Buffer;
    private ByteBuffer mp3Buffer;
    private IAudioSection audioSection;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        AudioConfig cfg = new AudioConfig(audioSection);
        this.audioSection = audioSection;
        File mp3 = audioSection.getMp3();
        if (mp3 == null) {
            throw new FileNotFoundException("mp3 file is missing");
        }
        if (!mp3.exists()) {
            throw new FileNotFoundException(mp3.getAbsolutePath() + " (No such file or directory)");
        }
        this.jump3r = new LameDecoder(mp3.getAbsolutePath());
        int sampleRate = this.jump3r.getSampleRate();
        int channels = this.jump3r.getChannels();
        int frameSize = this.jump3r.getFrameSize();
        Optional<SamplingRate> samplingRateFound = Arrays.asList(SamplingRate.values()).stream().filter(samplingRate -> samplingRate.getFrequency() == sampleRate).findFirst();
        if (!samplingRateFound.isPresent()) {
            throw new IOException("Unsupported sample rate: " + sampleRate + " in " + mp3);
        }
        if (sampleRate != audioSection.getSamplingRate().getFrequency()) {
            throw new IniConfigException("Sampling rate does not match " + sampleRate + ", switch to it", () -> audioSection.setSamplingRate((SamplingRate)((Object)((Object)samplingRateFound.get()))));
        }
        this.decodedMP3Buffer = ByteBuffer.wrap(new byte[frameSize * 2 * channels]).order(ByteOrder.nativeOrder());
        this.factor = Math.max(1, cfg.getBufferFrames() / frameSize);
        this.mp3Buffer = ByteBuffer.allocateDirect(this.factor * frameSize * 2 * cfg.getChannels()).order(ByteOrder.nativeOrder());
        super.open(cfg, CmpToMP3FileDriver.getDeviceInfo(audioSection));
        if (this.buffer().capacity() < this.mp3Buffer.capacity()) {
            cfg.setBufferFrames(this.mp3Buffer.capacity());
            cfg.setAudioBufferSize(this.mp3Buffer.capacity());
            super.open(cfg, CmpToMP3FileDriver.getDeviceInfo(audioSection));
        }
    }

    @Override
    public void write() throws InterruptedException {
        ((Buffer)this.mp3Buffer).clear();
        boolean decoded = true;
        for (int i = 0; i < this.factor; ++i) {
            ((Buffer)this.decodedMP3Buffer).clear();
            if (!(decoded &= this.jump3r.decode(this.decodedMP3Buffer))) break;
            if (this.jump3r.getChannels() == 1) {
                this.monoToStereo(this.decodedMP3Buffer, this.mp3Buffer);
                continue;
            }
            this.mp3Buffer.put(this.decodedMP3Buffer);
        }
        if (this.audioSection.isPlayOriginal()) {
            ((Buffer)this.buffer()).clear();
            ((Buffer)this.mp3Buffer).flip();
            this.buffer().put(this.mp3Buffer);
        }
        super.write();
        if (!decoded) {
            throw new SongEndException();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.jump3r != null) {
            this.jump3r.close();
        }
    }

    private void monoToStereo(ByteBuffer monoMP3Buffer, ByteBuffer stereoBuffer) {
        ShortBuffer monoBuffer = monoMP3Buffer.asShortBuffer();
        for (int i = 0; i < monoBuffer.limit(); ++i) {
            short monoSample = monoBuffer.get();
            stereoBuffer.putShort(monoSample);
            stereoBuffer.putShort(monoSample);
        }
    }
}

