/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.xuggle;

import com.xuggle.xuggler.Configuration;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IConfigurable;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.SamplingRate;
import libsidplay.components.mos656x.VIC;
import libsidplay.config.IAudioSection;
import libsidutils.C64FontUtils;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.VideoDriver;
import sidplay.audio.exceptions.IniConfigException;
import sidplay.audio.xuggle.XuggleBase;

public abstract class XuggleVideoDriver
extends XuggleBase
implements AudioDriver,
VideoDriver {
    private static final int STATUS_TEXT_Y = 10;
    private EventScheduler context;
    private IContainer container;
    private IStreamCoder videoCoder;
    private IStreamCoder audioCoder;
    private IConverter converter;
    private BufferedImage vicImage;
    private IntBuffer pictureBuffer;
    private int[] statusTextPixels;
    private int statusTextOffset;
    private int statusTextX;
    private int statusTextOverflow;
    private long frameNo;
    private long framesPerKeyFrames;
    private long firstAudioTimeStamp;
    private long firstVideoTimeStamp;
    private double ticksPerMicrosecond;
    private int audioDelayInMs;
    private ByteBuffer sampleBuffer;

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        this.context = context;
        AudioConfig cfg = new AudioConfig(audioSection);
        String url = this.getUrl(audioSection, recordingFilename);
        if (url == null) {
            throw new FileNotFoundException("url is missing, please set option --vcStreamingUrl");
        }
        if (!this.getSupportedSamplingRates().contains((Object)audioSection.getSamplingRate())) {
            throw new IniConfigException("Sampling rate is not supported by encoder, switch to default", () -> audioSection.setSamplingRate(this.getDefaultSamplingRate()));
        }
        this.container = IContainer.make();
        IContainerFormat containerFormat = IContainerFormat.make();
        containerFormat.setOutputFormat(this.getOutputFormatName(), url, null);
        this.container.setInputBufferLength(0L);
        this.throwExceptionOnError(this.container.open(url, IContainer.Type.WRITE, containerFormat), "Could not open: '" + url + "'");
        this.videoCoder = this.createVideoCoder(audioSection, cpuClock);
        this.throwExceptionOnError(this.videoCoder.open(null, null));
        this.audioCoder = this.createAudioCoder(audioSection, cfg);
        this.throwExceptionOnError(this.audioCoder.open(null, null));
        this.container.writeHeader();
        this.vicImage = new BufferedImage(384, 312, 2);
        this.pictureBuffer = IntBuffer.wrap(((DataBufferInt)this.vicImage.getRaster().getDataBuffer()).getData());
        this.converter = ConverterFactory.createConverter((BufferedImage)this.vicImage, (IPixelFormat.Type)IPixelFormat.Type.YUV420P);
        this.setStatusText("Recorded by JSIDPlay2!");
        this.frameNo = 0L;
        this.firstAudioTimeStamp = 0L;
        this.firstVideoTimeStamp = 0L;
        this.statusTextOffset = 384 * ((cpuClock == CPUClock.PAL ? 285 : 236) + 10);
        this.statusTextX = 0;
        this.statusTextOverflow = 0;
        this.audioDelayInMs = audioSection.getVideoCoderAudioDelay();
        this.ticksPerMicrosecond = cpuClock.getCpuFrequency() / 1000000.0;
        this.framesPerKeyFrames = (int)cpuClock.getScreenRefresh();
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * 2 * cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void write() throws InterruptedException {
        long timeStamp = this.getAudioTimeStamp();
        int numSamples = this.sampleBuffer.position() >> 2;
        IAudioSamples audioSamples = IAudioSamples.make((long)numSamples, (long)this.audioCoder.getChannels(), (IAudioSamples.Format)IAudioSamples.Format.FMT_S16);
        audioSamples.getData().put(this.sampleBuffer.array(), 0, 0, this.sampleBuffer.position());
        audioSamples.setComplete(true, (long)numSamples, this.audioCoder.getSampleRate(), this.audioCoder.getChannels(), IAudioSamples.Format.FMT_S16, timeStamp);
        int samplesConsumed = 0;
        IPacket packet = IPacket.make();
        while ((long)samplesConsumed < audioSamples.getNumSamples()) {
            samplesConsumed += this.throwExceptionOnError(this.audioCoder.encodeAudio(packet, audioSamples, (long)samplesConsumed));
            if (!packet.isComplete()) continue;
            this.container.writePacket(packet);
        }
        audioSamples.delete();
        packet.delete();
    }

    @Override
    public void accept(VIC vic) {
        long timeStamp = this.getVideoTimeStamp();
        IntBuffer pixels = vic.getPalEmulation().getPixelsAsIntBuffer();
        ((Buffer)pixels).rewind();
        ((Buffer)pixels).limit(this.statusTextOffset);
        this.pictureBuffer.put(pixels).put(this.statusTextPixels);
        ((Buffer)this.pictureBuffer).clear();
        IVideoPicture videoPicture = this.converter.toPicture(this.vicImage, timeStamp);
        videoPicture.setKeyFrame(this.frameNo++ % this.framesPerKeyFrames == 0L);
        IPacket packet = IPacket.make();
        this.throwExceptionOnError(this.videoCoder.encodeVideo(packet, videoPicture, 0));
        if (packet.isComplete()) {
            this.container.writePacket(packet);
        }
        videoPicture.delete();
        packet.delete();
    }

    @Override
    public void close() {
        if (this.container != null) {
            if (this.container.isOpened()) {
                this.container.writeTrailer();
            }
            if (this.audioCoder != null) {
                if (this.audioCoder.isOpen()) {
                    this.audioCoder.close();
                }
                this.audioCoder = null;
            }
            if (this.videoCoder != null) {
                if (this.videoCoder.isOpen()) {
                    this.videoCoder.close();
                }
                this.videoCoder = null;
            }
            if (this.container.isOpened()) {
                this.container.close();
            }
            this.container = null;
        }
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return true;
    }

    public void setStatusText(String text) {
        String fontText = C64FontUtils.petsciiToFont(text.toUpperCase(Locale.ENGLISH), 57344);
        BufferedImage statusImage = new BufferedImage(384, c64Font.getSize(), 2);
        Graphics2D graphics = statusImage.createGraphics();
        graphics.setFont(c64Font);
        graphics.drawString(fontText, -this.statusTextX, graphics.getFontMetrics(c64Font).getAscent());
        graphics.dispose();
        this.statusTextOverflow = Math.max(0, c64Font.getSize() * text.length() - this.statusTextX - 384);
        this.statusTextPixels = ((DataBufferInt)statusImage.getRaster().getDataBuffer()).getData();
    }

    public int getStatusTextOverflow() {
        return this.statusTextOverflow;
    }

    public int getStatusTextX() {
        return this.statusTextX;
    }

    public void setStatusTextX(int statusTextX) {
        this.statusTextX = statusTextX;
    }

    private IStreamCoder createVideoCoder(IAudioSection audioSection, CPUClock cpuClock) {
        IStreamCoder videoCoder = this.container.addNewStream(this.getVideoCodec()).getStreamCoder();
        videoCoder.setNumPicturesInGroupOfPictures(audioSection.getVideoCoderNumPicturesInGroupOfPictures());
        videoCoder.setBitRate(audioSection.getVideoCoderBitRate());
        videoCoder.setBitRateTolerance(audioSection.getVideoCoderBitRateTolerance());
        videoCoder.setTimeBase(IRational.make((double)(1.0 / cpuClock.getScreenRefresh())));
        videoCoder.setPixelType(IPixelFormat.Type.YUV420P);
        videoCoder.setHeight(312);
        videoCoder.setWidth(384);
        videoCoder.setFlag(IStreamCoder.Flags.FLAG_QSCALE, true);
        videoCoder.setGlobalQuality(audioSection.getVideoCoderGlobalQuality());
        this.configurePreset((IConfigurable)videoCoder, audioSection.getVideoCoderPreset().getPresetName());
        return videoCoder;
    }

    private void configurePreset(IConfigurable configurable, String presetName) {
        try (InputStream is = XuggleVideoDriver.class.getResourceAsStream(presetName);){
            Properties props = new Properties();
            props.load(is);
            Configuration.configure((Properties)props, (IConfigurable)configurable);
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException("You need preset " + presetName + " in your classpath.");
        }
    }

    private IStreamCoder createAudioCoder(IAudioSection audioSection, AudioConfig cfg) {
        IStreamCoder audioCoder = this.container.addNewStream(this.getAudioCodec()).getStreamCoder();
        audioCoder.setChannels(cfg.getChannels());
        audioCoder.setSampleFormat(IAudioSamples.Format.FMT_S16);
        audioCoder.setBitRate(audioSection.getAudioCoderBitRate());
        audioCoder.setBitRateTolerance(audioSection.getAudioCoderBitRateTolerance());
        audioCoder.setSampleRate(cfg.getFrameRate());
        return audioCoder;
    }

    private long getAudioTimeStamp() {
        long now = this.context.getTime(Event.Phase.PHI2);
        if (this.firstAudioTimeStamp == 0L) {
            this.firstAudioTimeStamp = now;
        }
        return (long)((double)(now - this.firstAudioTimeStamp) / this.ticksPerMicrosecond) + (long)(this.audioDelayInMs * 1000);
    }

    private long getVideoTimeStamp() {
        long now = this.context.getTime(Event.Phase.PHI2);
        if (this.firstVideoTimeStamp == 0L) {
            this.firstVideoTimeStamp = now;
        }
        return (long)((double)(now - this.firstVideoTimeStamp) / this.ticksPerMicrosecond);
    }

    protected abstract String getOutputFormatName();

    protected abstract List<SamplingRate> getSupportedSamplingRates();

    protected abstract SamplingRate getDefaultSamplingRate();

    protected abstract ICodec.ID getVideoCodec();

    protected abstract ICodec.ID getAudioCodec();

    protected abstract String getUrl(IAudioSection var1, String var2);
}

