/*
 * Decompiled with CFR 0.152.
 */
package sidplay.consoleplayer;

import builder.resid.SIDMixer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.function.Function;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.Mixer;
import libsidplay.config.IConfig;
import libsidplay.config.IConsoleSection;
import libsidplay.config.IEmulationSection;
import libsidplay.config.IWhatsSidSection;
import libsidplay.sidtune.SidTune;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import sidplay.Player;
import sidplay.player.PlayList;
import sidplay.player.Timer;

public class ConsoleIO {
    private final Function<String, String> resourceBundle;
    private IConfig config;
    private String filename;

    public ConsoleIO(IConfig config, String filename, Function<String, String> resourceBundle) {
        this.config = config;
        this.filename = filename;
        this.resourceBundle = resourceBundle;
    }

    public void menu(SidTune tune, PlayList playList, Timer timer, int verboseLevel, boolean quiet, boolean keys, PrintStream out) {
        if (quiet) {
            return;
        }
        IConsoleSection console = this.config.getConsoleSection();
        this.printTopLine(out, console);
        this.printHeading(out, console);
        this.printSeparatorLine(out, console);
        if (tune.getInfo().getInfoString().size() == 3) {
            this.printTitleAutorReleased(out, console, tune);
        } else {
            this.printDecription(out, console, tune);
        }
        if (tune.getInfo().getInfoString().size() > 0) {
            this.printSeparatorLine(out, console);
        }
        if (verboseLevel != 0) {
            this.printFileDetails(out, console, tune);
        }
        this.printPlaylist(out, console, tune, playList);
        if (verboseLevel > 0) {
            this.printHorizontalBottomLine(out, console);
            this.printSongSpeedCIAorVBI(out, console, tune, playList);
        }
        this.printSongLength(out, console, timer);
        if (verboseLevel > 0) {
            this.printHorizontalBottomLine(out, console);
            this.printAddresses(out, console, tune);
            this.printSIDDetails(out, console, tune);
        }
        this.printHorizontalBottomLine(out, console);
        if (keys) {
            this.printKeyboardControls(out);
        }
    }

    public void decodeKeys(Player player, InputStream in) {
        try {
            if (in.available() == 0) {
                return;
            }
            int key = in.read();
            IEmulationSection emulation = this.config.getEmulationSection();
            IWhatsSidSection whatsSid = this.config.getWhatsSidSection();
            switch (key) {
                case 104: {
                    player.firstSong();
                    break;
                }
                case 101: {
                    player.lastSong();
                    break;
                }
                case 62: {
                    if (!player.getPlayList().hasNext()) break;
                    player.nextSong();
                    break;
                }
                case 60: {
                    if (!player.getPlayList().hasPrevious()) break;
                    player.previousSong();
                    break;
                }
                case 110: {
                    player.getPlayList().last();
                    player.getTimer().end();
                    break;
                }
                case 46: {
                    player.configureMixer(Mixer::fastForward);
                    break;
                }
                case 44: {
                    player.configureMixer(Mixer::normalSpeed);
                    break;
                }
                case 112: {
                    player.pauseContinue();
                    break;
                }
                case 49: {
                    boolean isMuteVoice = emulation.isMuteVoice(0, 0) ^ true;
                    emulation.setMuteVoice(0, 0, isMuteVoice);
                    player.configureSID(0, sid -> sid.setVoiceMute(0, isMuteVoice));
                    break;
                }
                case 50: {
                    boolean isMuteVoice = emulation.isMuteVoice(0, 1) ^ true;
                    emulation.setMuteVoice(0, 1, isMuteVoice);
                    player.configureSID(0, sid -> sid.setVoiceMute(1, isMuteVoice));
                    break;
                }
                case 51: {
                    boolean isMuteVoice = emulation.isMuteVoice(0, 2) ^ true;
                    emulation.setMuteVoice(0, 2, isMuteVoice);
                    player.configureSID(0, sid -> sid.setVoiceMute(2, isMuteVoice));
                    break;
                }
                case 52: {
                    boolean isMuteVoice = emulation.isMuteVoice(0, 3) ^ true;
                    emulation.setMuteVoice(0, 3, isMuteVoice);
                    player.configureSID(0, sid -> sid.setVoiceMute(3, isMuteVoice));
                    break;
                }
                case 53: {
                    boolean isMuteVoice = emulation.isMuteVoice(1, 0) ^ true;
                    emulation.setMuteVoice(1, 0, isMuteVoice);
                    player.configureSID(1, sid -> sid.setVoiceMute(0, isMuteVoice));
                    break;
                }
                case 54: {
                    boolean isMuteVoice = emulation.isMuteVoice(1, 1) ^ true;
                    emulation.setMuteVoice(1, 1, isMuteVoice);
                    player.configureSID(1, sid -> sid.setVoiceMute(1, isMuteVoice));
                    break;
                }
                case 55: {
                    boolean isMuteVoice = emulation.isMuteVoice(1, 2) ^ true;
                    emulation.setMuteVoice(1, 2, isMuteVoice);
                    player.configureSID(1, sid -> sid.setVoiceMute(2, isMuteVoice));
                    break;
                }
                case 56: {
                    boolean isMuteVoice = emulation.isMuteVoice(1, 3) ^ true;
                    emulation.setMuteVoice(1, 3, isMuteVoice);
                    player.configureSID(1, sid -> sid.setVoiceMute(3, isMuteVoice));
                    break;
                }
                case 57: {
                    boolean isMuteVoice = emulation.isMuteVoice(2, 0) ^ true;
                    emulation.setMuteVoice(2, 0, isMuteVoice);
                    player.configureSID(2, sid -> sid.setVoiceMute(0, isMuteVoice));
                    break;
                }
                case 97: {
                    boolean isMuteVoice = emulation.isMuteVoice(2, 1) ^ true;
                    emulation.setMuteVoice(2, 1, isMuteVoice);
                    player.configureSID(2, sid -> sid.setVoiceMute(1, isMuteVoice));
                    break;
                }
                case 98: {
                    boolean isMuteVoice = emulation.isMuteVoice(2, 2) ^ true;
                    emulation.setMuteVoice(2, 2, isMuteVoice);
                    player.configureSID(2, sid -> sid.setVoiceMute(2, isMuteVoice));
                    break;
                }
                case 99: {
                    boolean isMuteVoice = emulation.isMuteVoice(2, 3) ^ true;
                    emulation.setMuteVoice(2, 3, isMuteVoice);
                    player.configureSID(2, sid -> sid.setVoiceMute(3, isMuteVoice));
                    break;
                }
                case 102: {
                    boolean filterEnable = emulation.isFilter() ^ true;
                    emulation.setFilter(filterEnable);
                    player.configureSID(0, sid -> sid.setFilterEnable(emulation, 0));
                    break;
                }
                case 103: {
                    boolean filterEnable = emulation.isStereoFilter() ^ true;
                    emulation.setStereoFilter(filterEnable);
                    player.configureSID(1, sid -> sid.setFilterEnable(emulation, 1));
                    break;
                }
                case 71: {
                    boolean filterEnable = emulation.isThirdSIDFilter() ^ true;
                    emulation.setThirdSIDFilter(filterEnable);
                    player.configureSID(2, sid -> sid.setFilterEnable(emulation, 2));
                    break;
                }
                case 119: {
                    boolean whatsSidEnable = whatsSid.isEnable() ^ true;
                    whatsSid.setEnable(whatsSidEnable);
                    player.configureMixer(mixer -> {
                        if (mixer instanceof SIDMixer) {
                            ((SIDMixer)mixer).setWhatsSidEnabled(whatsSidEnable);
                        }
                    });
                    break;
                }
                case 113: {
                    player.quit();
                    break;
                }
            }
        }
        catch (IOException e) {
            player.quit();
        }
    }

    public void whatsSid(MusicInfoWithConfidenceBean musicInfoWithConfidence, boolean quiet, PrintStream out) {
        if (quiet) {
            return;
        }
        out.println(musicInfoWithConfidence);
    }

    private void printTopLine(PrintStream out, IConsoleSection console) {
        out.printf("%c%s%c\n", Character.valueOf(console.getTopLeft()), this.setFill(console.getHorizontal(), 54), Character.valueOf(console.getTopRight()));
    }

    private void printHeading(PrintStream out, IConsoleSection console) {
        out.printf("%c %52s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("HEADING"), Character.valueOf(console.getVertical()));
    }

    private void printSeparatorLine(PrintStream out, IConsoleSection console) {
        out.printf("%c%s%c\n", Character.valueOf(console.getJunctionLeft()), this.setFill(console.getHorizontal(), 54), Character.valueOf(console.getJunctionRight()));
    }

    private void printTitleAutorReleased(PrintStream out, IConsoleSection console, SidTune tune) {
        Iterator<String> description = tune.getInfo().getInfoString().iterator();
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("TITLE"), description.next(), Character.valueOf(console.getVertical()));
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("AUTHOR"), description.next(), Character.valueOf(console.getVertical()));
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("RELEASED"), description.next(), Character.valueOf(console.getVertical()));
    }

    private void printDecription(PrintStream out, IConsoleSection console, SidTune tune) {
        for (String description : tune.getInfo().getInfoString()) {
            out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("DESCRIPTION"), description, Character.valueOf(console.getVertical()));
        }
    }

    private void printFileDetails(PrintStream out, IConsoleSection console, SidTune tune) {
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("FILE_FORMAT"), tune.getClass().getSimpleName(), Character.valueOf(console.getVertical()));
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("FILENAMES"), this.filename, Character.valueOf(console.getVertical()));
    }

    private void printPlaylist(PrintStream out, IConsoleSection console, SidTune tune, PlayList playList) {
        int trackNum = playList.getTrackNum();
        out.printf("%c %-12s : ", Character.valueOf(console.getVertical()), this.resourceBundle.apply("PLAYLIST"));
        StringBuffer trackList = new StringBuffer();
        trackList.append(trackNum).append("/").append(playList.getLength());
        trackList.append(" (tune ").append(tune.getInfo().getCurrentSong()).append("/").append(tune.getInfo().getSongs());
        trackList.append("[").append(tune.getInfo().getStartSong()).append("])");
        if (this.config.getSidplay2Section().isLoop()) {
            trackList.append(" [" + this.resourceBundle.apply("LOOPING") + "]");
        }
        out.printf("%37s %c\n", trackList.toString(), Character.valueOf(console.getVertical()));
    }

    private void printSongSpeedCIAorVBI(PrintStream out, IConsoleSection console, SidTune tune, PlayList playList) {
        out.printf("%c %-12s : %37s %c\n", new Object[]{Character.valueOf(console.getVertical()), this.resourceBundle.apply("SONG_SPEED"), tune.getSongSpeed(playList.getCurrent()), Character.valueOf(console.getVertical())});
    }

    private void printSongLength(PrintStream out, IConsoleSection console, Timer timer) {
        out.printf("%c %-12s : ", Character.valueOf(console.getVertical()), this.resourceBundle.apply("SONG_LENGTH"));
        if (timer.getEnd() != 0.0) {
            String time = new SimpleDateFormat("mm:ss.SSS").format(new Date((long)(timer.getEnd() * 1000.0)));
            out.printf("%37s %c\n", time, Character.valueOf(console.getVertical()));
        } else {
            out.printf("%37s %c\n", this.resourceBundle.apply("UNLIMITED"), Character.valueOf(console.getVertical()));
        }
    }

    private void printHorizontalBottomLine(PrintStream out, IConsoleSection console) {
        out.printf("%c%s%c\n", Character.valueOf(console.getBottomLeft()), this.setFill(console.getHorizontal(), 54), Character.valueOf(console.getBottomRight()));
    }

    private void printAddresses(PrintStream out, IConsoleSection console, SidTune tune) {
        StringBuffer line = new StringBuffer();
        line.append(this.resourceBundle.apply("DRIVER_ADDR") + " = ");
        if (tune.getInfo().getDeterminedDriverAddr() == 0) {
            line.append(this.resourceBundle.apply("NOT_PRESENT"));
        } else {
            line.append(String.format("$%04x", tune.getInfo().getDeterminedDriverAddr()));
            line.append(String.format("-$%04x", tune.getInfo().getDeterminedDriverAddr() + tune.getInfo().getDeterminedDriverLength() - 1));
        }
        if (tune.getInfo().getPlayAddr() == 65535) {
            line.append(String.format(", " + this.resourceBundle.apply("SYS") + " = $%04x", tune.getInfo().getInitAddr()));
        } else {
            line.append(String.format(", " + this.resourceBundle.apply("INIT") + " = $%04x", tune.getInfo().getInitAddr()));
        }
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("ADDRESSES"), line.toString(), Character.valueOf(console.getVertical()));
        line = new StringBuffer();
        line.append(String.format(this.resourceBundle.apply("LOAD") + " = $%04x", tune.getInfo().getLoadAddr()));
        line.append(String.format("-$%04x", tune.getInfo().getLoadAddr() + tune.getInfo().getC64dataLen() - 1));
        if (tune.getInfo().getPlayAddr() != 65535) {
            line.append(String.format(", %s = $%04x", this.resourceBundle.apply("PLAY"), tune.getInfo().getPlayAddr()));
        }
        out.printf("%c              : %37s %c\n", Character.valueOf(console.getVertical()), line.toString(), Character.valueOf(console.getVertical()));
    }

    private void printSIDDetails(PrintStream out, IConsoleSection console, SidTune tune) {
        Engine engine;
        int sidNum;
        StringBuffer line = new StringBuffer();
        IEmulationSection emulationSection = this.config.getEmulationSection();
        line.append(this.resourceBundle.apply("FILTER") + (emulationSection.isFilter() ? " = on" : " = off"));
        out.printf("%c %-12s : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("SID_DETAILS"), line.toString(), Character.valueOf(console.getVertical()));
        for (sidNum = 0; sidNum < 3; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            engine = Engine.getEngine(emulationSection, tune);
            out.printf("%c %-10s %d : %37s %c\n", new Object[]{Character.valueOf(console.getVertical()), this.resourceBundle.apply("ENGINE"), sidNum + 1, engine, Character.valueOf(console.getVertical())});
        }
        for (sidNum = 0; sidNum < 3; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            Emulation emulation = Emulation.getEmulation(emulationSection, sidNum);
            out.printf("%c %-10s %d : %37s %c\n", new Object[]{Character.valueOf(console.getVertical()), this.resourceBundle.apply("EMULATION"), sidNum + 1, emulation, Character.valueOf(console.getVertical())});
        }
        for (sidNum = 0; sidNum < 3; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
            out.printf("%c %-10s %d : %37s %c\n", new Object[]{Character.valueOf(console.getVertical()), this.resourceBundle.apply("MODEL"), sidNum + 1, chipModel, Character.valueOf(console.getVertical())});
        }
        for (sidNum = 0; sidNum < 3; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            engine = Engine.getEngine(emulationSection, tune);
            Emulation emulation = Emulation.getEmulation(emulationSection, sidNum);
            ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
            String filterName = emulationSection.getFilterName(sidNum, engine, emulation, chipModel);
            out.printf("%c %-10s %d : %37s %c\n", Character.valueOf(console.getVertical()), this.resourceBundle.apply("SID_FILTER"), sidNum + 1, filterName, Character.valueOf(console.getVertical()));
        }
    }

    private void printKeyboardControls(PrintStream out) {
        out.println(this.resourceBundle.apply("KEYBOARD_CONTROLS"));
        out.println(this.resourceBundle.apply("FORWARD_REWIND"));
        out.println(this.resourceBundle.apply("FIRST_LAST"));
        out.println(this.resourceBundle.apply("NORMAL_FAST"));
        out.println(this.resourceBundle.apply("FORWARD_TUNE"));
        out.println(this.resourceBundle.apply("PAUSE_CONTINUE"));
        out.println(this.resourceBundle.apply("MUTE_1"));
        out.println(this.resourceBundle.apply("MUTE_2"));
        out.println(this.resourceBundle.apply("MUTE_3"));
        out.println(this.resourceBundle.apply("MUTE_4"));
        out.println(this.resourceBundle.apply("MUTE_5"));
        out.println(this.resourceBundle.apply("MUTE_6"));
        out.println(this.resourceBundle.apply("MUTE_7"));
        out.println(this.resourceBundle.apply("MUTE_8"));
        out.println(this.resourceBundle.apply("MUTE_9"));
        out.println(this.resourceBundle.apply("MUTE_10"));
        out.println(this.resourceBundle.apply("MUTE_11"));
        out.println(this.resourceBundle.apply("MUTE_12"));
        out.println(this.resourceBundle.apply("FILTER_ENABLE"));
        out.println(this.resourceBundle.apply("STEREO_FILTER_ENABLE"));
        out.println(this.resourceBundle.apply("3RD_SID_FILTER_ENABLE"));
        out.println(this.resourceBundle.apply("WHATSSID_ENABLE"));
        out.println(this.resourceBundle.apply("QUIT"));
    }

    private String setFill(char ch, int length) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            ret.append(ch);
        }
        return ret.toString();
    }
}

